/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.ui.containers.AbstractProjectsStateHelper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JavaProjectsStateHelper
extends AbstractProjectsStateHelper {
    private static final Logger log = Logger.getLogger(JavaProjectsStateHelper.class);
    @Inject
    private IStorage2UriMapperJdtExtensions uriMapperExtensions;

    public void setUriMapperExtensions(IStorage2UriMapperJdtExtensions uriMapperExtensions) {
        this.uriMapperExtensions = uriMapperExtensions;
    }

    public String initHandle(URI uri) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(uri);
        if (root != null) {
            return root.getHandleIdentifier();
        }
        return null;
    }

    public List<String> initVisibleHandles(String handle) {
        IJavaElement javaElement = JavaCore.create((String)handle);
        if (javaElement != null) {
            IJavaProject project = javaElement.getJavaProject();
            if (this.isAccessibleXtextProject(project.getProject())) {
                List<String> rootHandles = this.getPackageFragmentRootHandles(project);
                return rootHandles;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public Collection<URI> initContainedURIs(String containerHandle) {
        IJavaElement javaElement = JavaCore.create((String)containerHandle);
        if (javaElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
            IJavaProject javaProject = root.getJavaProject();
            if (!this.isAccessibleXtextProject(javaProject.getProject())) {
                return Collections.emptyList();
            }
            Map<URI, IStorage> entries = this.uriMapperExtensions.getAllEntries(root);
            return entries.keySet();
        }
        return Collections.emptyList();
    }

    protected List<String> getPackageFragmentRootHandles(IJavaProject project) {
        ArrayList result;
        block4: {
            result = Lists.newArrayList();
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getAllPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root != null && !JavaRuntime.newDefaultJREContainerPath().isPrefixOf(root.getRawClasspathEntry().getPath())) {
                        result.add(root.getHandleIdentifier());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block4;
                log.error((Object)("Cannot find rootHandles in project " + project.getProject().getName()), (Throwable)e);
            }
        }
        return result;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(URI uri) {
        if (uri.isArchive() || !uri.isPlatform()) {
            return this.getJarWithEntry(uri);
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (file == null) {
            return this.getJarWithEntry(uri);
        }
        IPackageFragmentRoot root = this.getJavaElement(file);
        if (root == null) {
            return this.getJarWithEntry(uri);
        }
        return root;
    }

    protected IPackageFragmentRoot getJavaElement(IFile file) {
        block5: {
            IJavaProject jp = JavaCore.create((IProject)file.getProject());
            if (!jp.exists()) {
                return null;
            }
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jp.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource2;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && (resource2 = root.getUnderlyingResource()).contains((ISchedulingRule)file)) {
                        return root;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block5;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected IPackageFragmentRoot getJarWithEntry(URI uri) {
        Iterable<Pair<IStorage, IProject>> storages = this.getStorages(uri);
        IPackageFragmentRoot result = null;
        for (Pair<IStorage, IProject> storage2Project : storages) {
            IPackageFragmentRoot fragmentRoot;
            IStorage storage = (IStorage)storage2Project.getFirst();
            if (!(storage instanceof IJarEntryResource) || (fragmentRoot = ((IJarEntryResource)storage).getPackageFragmentRoot()) == null) continue;
            IJavaProject javaProject = fragmentRoot.getJavaProject();
            if (this.isAccessibleXtextProject(javaProject.getProject())) {
                return fragmentRoot;
            }
            if (result != null) continue;
            result = fragmentRoot;
        }
        return result;
    }
}

