/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.service.CatalogBranding;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogSwitcher;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class MarketplacePage
extends CatalogPage {
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogDescriptor previousCatalogDescriptor;
    private boolean updated;
    private Link selectionLink;
    private TabFolder tabFolder;
    private TabItem searchTabItem;
    private TabItem recentTabItem;
    private TabItem popularTabItem;
    private Control tabContent;
    private TabItem installedTabItem;
    protected boolean disableTabSelection;
    protected CatalogDescriptor lastSelection;

    public MarketplacePage(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog);
        this.configuration = configuration;
        this.setDescription(Messages.MarketplacePage_selectSolutionsToInstall);
        this.setTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.configuration.getCatalogDescriptor() != null) {
            this.setTitle(this.configuration.getCatalogDescriptor().getLabel());
        }
    }

    public void createControl(Composite originalParent) {
        Composite parent = originalParent;
        boolean needSwitchMarketplaceControl = this.configuration.getCatalogDescriptors().size() > 1;
        parent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 5).applyTo(parent);
        this.tabFolder = new TabFolder(parent, 128);
        if (originalParent != parent) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        }
        super.createControl((Composite)this.tabFolder);
        this.tabContent = this.getControl();
        this.createSearchTab();
        this.createRecentTab();
        this.createPopularTab();
        this.createInstalltedTab();
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceViewer.ContentType contentType;
                if (MarketplacePage.this.disableTabSelection) {
                    return;
                }
                if (e.item == MarketplacePage.this.searchTabItem) {
                    contentType = MarketplaceViewer.ContentType.SEARCH;
                } else if (e.item == MarketplacePage.this.recentTabItem) {
                    contentType = MarketplaceViewer.ContentType.RECENT;
                } else if (e.item == MarketplacePage.this.popularTabItem) {
                    contentType = MarketplaceViewer.ContentType.POPULAR;
                } else if (e.item == MarketplacePage.this.installedTabItem) {
                    contentType = MarketplaceViewer.ContentType.INSTALLED;
                } else {
                    throw new IllegalStateException();
                }
                MarketplacePage.this.getViewer().setContentType(contentType);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectionLink = new Link(parent, 0);
        this.selectionLink.setToolTipText(Messages.MarketplacePage_showSelection);
        this.selectionLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.selectionLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.selectionLink);
        this.computeSelectionLinkText();
        if (needSwitchMarketplaceControl) {
            this.createMarketplaceSwitcher(parent);
        } else {
            this.updateBranding();
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private int previousSelectionSize = 0;

            public void selectionChanged(SelectionChangedEvent event) {
                IWizardPage nextPage;
                IWizardPage currentPage;
                if (!MarketplacePage.this.isCurrentPage()) {
                    return;
                }
                SelectionModel selectionModel = MarketplacePage.this.getWizard().getSelectionModel();
                int newSelectionSize = selectionModel.getItemToOperation().size();
                if (!event.getSelection().isEmpty() && this.previousSelectionSize == 0 && newSelectionSize == 1 && selectionModel.computeProvisioningOperationViable() && (currentPage = MarketplacePage.this.getContainer().getCurrentPage()).isPageComplete() && (nextPage = MarketplacePage.this.getWizard().getNextPage((IWizardPage)MarketplacePage.this)) != null) {
                    MarketplacePage.this.getContainer().showPage(nextPage);
                }
                this.previousSelectionSize = newSelectionSize;
            }
        });
        this.getViewer().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(MarketplaceViewer.CONTENT_TYPE_PROPERTY) && event.getNewValue() == MarketplaceViewer.ContentType.SEARCH) {
                    MarketplacePage.this.tabFolder.setSelection(MarketplacePage.this.searchTabItem);
                }
            }
        });
        this.setControl((Control)(parent == originalParent ? this.tabFolder : parent));
        MarketplaceClientUi.setDefaultHelp(this.tabContent);
    }

    private void createInstalltedTab() {
        this.installedTabItem = new TabItem(this.tabFolder, 0);
        this.installedTabItem.setText(Messages.MarketplacePage_installed);
        this.installedTabItem.setControl(this.tabContent);
    }

    private void createPopularTab() {
        this.popularTabItem = new TabItem(this.tabFolder, 0);
        this.popularTabItem.setText(Messages.MarketplacePage_popular);
        this.popularTabItem.setControl(this.tabContent);
    }

    private void createRecentTab() {
        this.recentTabItem = new TabItem(this.tabFolder, 0);
        this.recentTabItem.setText(Messages.MarketplacePage_recent);
        this.recentTabItem.setControl(this.tabContent);
    }

    private void createSearchTab() {
        this.searchTabItem = new TabItem(this.tabFolder, 0);
        this.searchTabItem.setText(Messages.MarketplacePage_search);
        this.searchTabItem.setControl(this.tabContent);
    }

    private void createMarketplaceSwitcher(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        final CatalogSwitcher switcher = new CatalogSwitcher(composite, 2048, this.configuration);
        switcher.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CatalogDescriptor descriptor = (CatalogDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (MarketplacePage.this.getWizard().getSelectionModel().getSelectedCatalogItems().size() > 0) {
                    boolean discardSelection = MessageDialog.openConfirm((Shell)MarketplacePage.this.getShell(), (String)Messages.MarketplacePage_selectionSolutions, (String)Messages.MarketplacePage_discardPendingSolutions);
                    if (discardSelection) {
                        MarketplacePage.this.getWizard().getSelectionModel().clear();
                        MarketplacePage.this.computeSelectionLinkText();
                    } else {
                        switcher.setSelection((ISelection)new StructuredSelection((Object)MarketplacePage.this.lastSelection));
                        return;
                    }
                }
                MarketplacePage.this.lastSelection = descriptor;
                MarketplacePage.this.configuration.setCatalogDescriptor(descriptor);
                MarketplacePage.this.getWizard().initializeCatalog();
                MarketplacePage.this.getViewer().updateCatalog();
                MarketplacePage.this.updateBranding();
            }
        });
        CatalogDescriptor selectedDescriptor = this.configuration.getCatalogDescriptor();
        if (selectedDescriptor != null) {
            switcher.setSelection((ISelection)new StructuredSelection((Object)selectedDescriptor));
        }
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(1, switcher.getPreferredHeight()).hint(500, switcher.getPreferredHeight()).applyTo((Control)composite);
    }

    private void computeSelectionLinkText() {
        if (this.selectionLink != null) {
            String originalText = this.selectionLink.getText();
            String text = " ";
            int count = this.getWizard().getSelectionModel().getItemToOperation().size();
            if (count == 1) {
                text = Messages.MarketplacePage_linkShowSelection_One;
            } else if (count > 0) {
                text = NLS.bind((String)Messages.MarketplacePage_linkShowSelection_Multiple, (Object)count);
            }
            if (!(text == originalText || text != null && text.equals(originalText))) {
                boolean exclude = text == null || text.trim().length() == 0;
                boolean originalExclude = ((GridData)this.selectionLink.getLayoutData()).exclude;
                this.selectionLink.setText(text);
                if (originalExclude != exclude) {
                    this.selectionLink.setVisible(!exclude);
                    ((GridData)this.selectionLink.getLayoutData()).exclude = exclude;
                    ((Composite)this.getControl()).layout(true, true);
                }
            }
        }
    }

    protected void selectionLinkActivated() {
        this.tabFolder.setSelection(this.searchTabItem);
        this.getViewer().showSelected();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        MarketplaceViewer viewer = new MarketplaceViewer(this.getCatalog(), (IShellProvider)this, this.getWizard());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        return viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!MarketplacePage.this.getControl().isDisposed() && MarketplacePage.this.isCurrentPage()) {
                        MarketplacePage.this.getViewer().updateCatalog();
                    }
                }
            });
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
            if (catalogDescriptor != null) {
                this.setTitle(catalogDescriptor.getLabel());
            }
            if (this.previousCatalogDescriptor == null || !this.previousCatalogDescriptor.equals(catalogDescriptor)) {
                this.previousCatalogDescriptor = catalogDescriptor;
                this.tabFolder.setSelection(this.searchTabItem);
                this.getViewer().setContentType(MarketplaceViewer.ContentType.SEARCH);
                this.getWizard().initializeCatalog();
                this.updated = false;
            }
        }
        super.setVisible(visible);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = this.getWizard().getSelectionModel().computeProvisioningOperationViable();
        }
        this.computeMessages();
        super.setPageComplete(complete);
    }

    private void computeMessages() {
        this.computeStatusMessage();
        this.computeSelectionLinkText();
    }

    private void computeStatusMessage() {
        IStatus viability;
        String message = null;
        int messageType = 0;
        if (this.getWizard() != null && (viability = this.getWizard().getSelectionModel().computeProvisioningOperationViability()) != null) {
            message = viability.getMessage();
            messageType = Util.computeMessageType(viability);
        }
        this.setMessage(message, messageType);
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    private void updateBranding() {
        boolean hasPopularTab;
        boolean hasRecentTab;
        this.disableTabSelection = true;
        this.updateTitle();
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        CatalogBranding branding = CatalogRegistry.getInstance().getCatalogBranding(descriptor);
        if (branding == null) {
            branding = this.getDefaultBranding();
        }
        this.searchTabItem.dispose();
        this.recentTabItem.dispose();
        this.popularTabItem.dispose();
        this.installedTabItem.dispose();
        boolean hasSearchTab = branding.hasSearchTab();
        if (hasSearchTab) {
            this.createSearchTab();
            this.searchTabItem.setText(branding.getSearchTabName());
        }
        if (hasRecentTab = branding.hasRecentTab()) {
            this.createRecentTab();
            this.recentTabItem.setText(branding.getRecentTabName());
        }
        if (hasPopularTab = branding.hasPopularTab()) {
            this.createPopularTab();
            this.popularTabItem.setText(branding.getPopularTabName());
        }
        this.createInstalltedTab();
        this.tabFolder.setSelection(0);
        try {
            ImageDescriptor wizardIconDescriptor = branding.getWizardIcon() == null ? DiscoveryImages.BANNER_DISOVERY : ImageDescriptor.createFromURL((URL)new URL(branding.getWizardIcon()));
            this.setImageDescriptor(wizardIconDescriptor);
        }
        catch (MalformedURLException e) {
            MarketplaceClientUi.error(e);
        }
        this.disableTabSelection = false;
    }

    private CatalogBranding getDefaultBranding() {
        CatalogBranding branding = new CatalogBranding();
        branding.setHasSearchTab(true);
        branding.setHasPopularTab(true);
        branding.setHasRecentTab(true);
        branding.setSearchTabName(Messages.MarketplacePage_search);
        branding.setPopularTabName(Messages.MarketplacePage_popular);
        branding.setRecentTabName(Messages.MarketplacePage_recent);
        branding.setWizardTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        return branding;
    }
}

