/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.commonmark.internal.SimpleLocator;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;
import org.eclipse.mylyn.wikitext.parser.Locator;

public class Line {
    private final String text;
    private final int offset;
    private final int lineNumber;

    public Line(int lineNumber, int offset, String text) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((lineNumber >= 0 ? 1 : 0) != 0);
        this.lineNumber = lineNumber;
        this.offset = offset;
        this.text = (String)Preconditions.checkNotNull((Object)text);
    }

    public boolean isEmpty() {
        return !CharMatcher.WHITESPACE.negate().matchesAnyOf((CharSequence)this.text);
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Line segment(int offset, int length) {
        return new Line(this.lineNumber, this.offset + offset, this.text.substring(offset, offset + length));
    }

    public Locator toLocator() {
        return new SimpleLocator(this);
    }

    public String toString() {
        return Objects.toStringHelper(Line.class).add("lineNumber", this.lineNumber).add("offset", this.offset).add("text", (Object)ToStringHelper.toStringValue(this.text)).toString();
    }
}

