/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.markdown.internal.block.NestableBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.util.LookAheadReader;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class ListBlock
extends NestableBlock {
    private static final Pattern itemStartPattern = Pattern.compile(" {0,3}(?:([\\*\\+\\-])|([0-9]+\\.))\\s+(.+?)");
    private static final Pattern nestedItemStartPattern = Pattern.compile("( +)(?:([\\*\\+\\-])|([0-9]+\\.))\\s+(.+?)");
    private static final Pattern indentedParagraphPattern = Pattern.compile("( +).*");
    private int blockLineCount = 0;
    private ListBlock nestedBlock = null;
    private ParagraphBlock nestedParagraph = null;
    private int thisIndentation = 0;
    private boolean nextLineStartsNewParagraph = false;

    public boolean canStart(String line, int lineOffset) {
        Matcher matcher = itemStartPattern.matcher(line.substring(lineOffset));
        return matcher.matches();
    }

    protected int processLineContent(String line, int offset) {
        String text = line.substring(offset);
        Matcher itemStartMatcher = itemStartPattern.matcher(text);
        Matcher nestedItemStartMatcher = nestedItemStartPattern.matcher(text);
        boolean thisLineStartsNewParagraph = this.nextLineStartsNewParagraph;
        this.nextLineStartsNewParagraph = false;
        if (itemStartMatcher.matches()) {
            this.handleItem(text, itemStartMatcher);
        } else if (nestedItemStartMatcher.matches()) {
            this.handleNestedItem(text, nestedItemStartMatcher);
        } else if (this.getMarkupLanguage().isEmptyLine(text) && this.canContinueWithNextLine()) {
            this.closeNestedParagraph();
            this.nextLineStartsNewParagraph = true;
        } else if (!this.getMarkupLanguage().isEmptyLine(text)) {
            this.handleText(text, thisLineStartsNewParagraph);
        } else {
            this.setClosed(true);
            return offset;
        }
        ++this.blockLineCount;
        return -1;
    }

    private void handleItem(String text, Matcher itemStartMatcher) {
        int contentStart;
        if (this.blockLineCount == 0) {
            DocumentBuilder.BlockType blockType = itemStartMatcher.group(1) != null ? DocumentBuilder.BlockType.BULLETED_LIST : DocumentBuilder.BlockType.NUMERIC_LIST;
            this.builder.beginBlock(blockType, new Attributes());
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        } else {
            if (this.nestedBlock != null) {
                this.nestedBlock.setClosed(true);
                this.nestedBlock = null;
            } else {
                this.builder.endBlock();
            }
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.thisIndentation = contentStart = itemStartMatcher.start(3);
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.getState(), text, contentStart);
    }

    private void handleNestedItem(String text, Matcher nestedItemStartMatcher) {
        if (this.nestedBlock == null) {
            this.builder.endBlock();
            int nestedOffset = nestedItemStartMatcher.end(1);
            this.nestedBlock = new ListBlock();
            this.nestedBlock.setParser(this.getParser());
            this.nestedBlock.setState(this.getState());
            this.nestedBlock.processLine(text, nestedOffset);
        } else {
            this.nestedBlock.processLine(text, this.thisIndentation);
        }
    }

    private boolean canContinueWithNextLine() {
        String nextLine = this.getNextLine();
        if (nextLine == null) {
            return false;
        }
        Matcher indentedParagraph = indentedParagraphPattern.matcher(nextLine);
        Matcher nextItem = itemStartPattern.matcher(nextLine);
        Matcher nestedItem = nestedItemStartPattern.matcher(nextLine);
        return indentedParagraph.matches() && indentedParagraph.end(1) == this.thisIndentation || nextItem.matches() || nestedItem.matches();
    }

    private void handleText(String text, boolean startsNewParagraph) {
        if (this.nestedParagraph == null) {
            this.builder.characters("\n");
            if (startsNewParagraph) {
                this.nestedParagraph = new ParagraphBlock();
                this.nestedParagraph.setParser(this.getParser());
                this.nestedParagraph.setState(this.getState());
                this.nestedParagraph.processLine(text, this.thisIndentation);
                startsNewParagraph = false;
            } else {
                Matcher matcher = indentedParagraphPattern.matcher(text);
                if (matcher.matches() && matcher.end(1) == this.thisIndentation) {
                    this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.getState(), text, this.thisIndentation);
                } else {
                    this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.getState(), text, 0);
                }
            }
        } else {
            Matcher matcher = indentedParagraphPattern.matcher(text);
            if (matcher.matches() && matcher.end(1) == this.thisIndentation) {
                this.nestedParagraph.processLine(text, this.thisIndentation);
            } else {
                this.nestedParagraph.processLine(text, 0);
            }
        }
    }

    private void closeNestedParagraph() {
        if (this.nestedParagraph != null) {
            this.nestedParagraph.setClosed(true);
            this.nestedParagraph = null;
        }
    }

    private String getNextLine() {
        LookAheadReader lookAhead = new LookAheadReader();
        lookAhead.setContentState(this.getState());
        return lookAhead.lookAhead();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.closeNestedParagraph();
            if (this.nestedBlock != null && !this.nestedBlock.isClosed()) {
                this.nestedBlock.setClosed(closed);
                this.nestedBlock = null;
            } else {
                this.builder.endBlock();
            }
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

