/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.ImageAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ImageDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    private final SourceViewer viewer;

    public ImageDrawingStrategy(SourceViewer viewer) {
        this.viewer = viewer;
    }

    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (gc != null) {
            Position position = this.viewer.getAnnotationModel().getPosition(annotation);
            ImageAnnotation imageAnnotation = (ImageAnnotation)annotation;
            Image image = imageAnnotation.getImage();
            if (image != null) {
                if (position != null) {
                    offset = position.offset;
                }
                Point left = textWidget.getLocationAtOffset(offset);
                if (position == null && length > 0) {
                    Point right = textWidget.getLocationAtOffset(offset + length);
                    if (left.x > right.x) {
                        left.x = 0;
                        left.y = right.y;
                    }
                }
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setForeground(textWidget.getBackground());
                gc.setBackground(textWidget.getBackground());
                Rectangle bounds = image.getBounds();
                gc.fillRectangle(new Rectangle(left.x, left.y, bounds.width, bounds.height));
                gc.setForeground(foreground);
                gc.setBackground(background);
                gc.drawImage(image, left.x, left.y);
            }
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }
}

