/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;

public class TextSegment {
    private final List<Line> lines;
    private final String text;

    public TextSegment(Iterable<Line> lines) {
        this.lines = ImmutableList.copyOf(lines);
        this.text = TextSegment.computeText(this.lines);
    }

    private static String computeText(List<Line> lines) {
        String text = "";
        for (Line line : lines) {
            if (text.length() > 0) {
                text = text + "\n";
            }
            text = text + line.getText();
        }
        return text;
    }

    public String getText() {
        return this.text;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public int offsetOf(int textOffset) {
        Preconditions.checkArgument((textOffset >= 0 ? 1 : 0) != 0);
        int textOffsetOfLine = 0;
        int remainder = textOffset;
        for (Line line : this.lines) {
            textOffsetOfLine = line.getOffset();
            int linePlusSeparatorLength = line.getText().length() + 1;
            if (linePlusSeparatorLength > remainder) break;
            remainder -= linePlusSeparatorLength;
        }
        return textOffsetOfLine + remainder;
    }

    public int toTextOffset(int documentOffset) {
        int textOffset = 0;
        for (Line line : this.lines) {
            int lineRelativeOffset = documentOffset - line.getOffset();
            int linePlusSeparatorLength = line.getText().length() + 1;
            if (lineRelativeOffset >= 0 && lineRelativeOffset < linePlusSeparatorLength) {
                return textOffset + lineRelativeOffset;
            }
            textOffset += linePlusSeparatorLength;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return MoreObjects.toStringHelper(TextSegment.class).add("text", (Object)ToStringHelper.toStringValue(this.text)).toString();
    }

    public Line getLineAtOffset(int textOffset) {
        int documentOffset = this.offsetOf(textOffset);
        Line previous = null;
        for (Line line : this.lines) {
            if (line.getOffset() > documentOffset) break;
            previous = line;
        }
        return (Line)Preconditions.checkNotNull(previous);
    }
}

