/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.wikitext.html.internal.CompositeSpanStrategy;
import org.eclipse.mylyn.wikitext.html.internal.ElementStrategies;
import org.eclipse.mylyn.wikitext.html.internal.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SpanStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SubstitutionSpanStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SubstitutionWithoutCssSpanStrategy;
import org.eclipse.mylyn.wikitext.html.internal.SupportedSpanStrategy;
import org.eclipse.mylyn.wikitext.html.internal.UnsupportedSpanStrategy;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.css.CssParser;
import org.eclipse.mylyn.wikitext.parser.css.CssRule;

public class SpanStrategies
extends ElementStrategies<DocumentBuilder.SpanType, SpanStrategy, SpanHtmlElementStrategy> {
    private static final Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> spanTypeToAlternatives = SpanStrategies.createSpanTypeToAlternatives();

    private static Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> createSpanTypeToAlternatives() {
        HashMap alternatives = Maps.newHashMap();
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.STRONG);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.STRONG, DocumentBuilder.SpanType.BOLD);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.CODE, DocumentBuilder.SpanType.MONOSPACE);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.EMPHASIS, DocumentBuilder.SpanType.ITALIC);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.INSERTED, DocumentBuilder.SpanType.UNDERLINED);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.ITALIC, DocumentBuilder.SpanType.EMPHASIS);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.MONOSPACE, DocumentBuilder.SpanType.CODE);
        return ImmutableMap.copyOf((Map)alternatives);
    }

    private static void addAlternatives(Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> alternatives, DocumentBuilder.SpanType spanType, DocumentBuilder.SpanType ... spanTypes) {
        Preconditions.checkState((!alternatives.containsKey(spanType) ? 1 : 0) != 0, (String)"Duplicate %s", (Object)spanType);
        Preconditions.checkArgument((spanTypes.length > 0 ? 1 : 0) != 0);
        alternatives.put(spanType, (List<DocumentBuilder.SpanType>)ImmutableList.copyOf((Object[])spanTypes));
    }

    SpanStrategies(Set<DocumentBuilder.SpanType> elementTypes, List<SpanHtmlElementStrategy> spanElementStrategies) {
        super(DocumentBuilder.SpanType.class, elementTypes, spanElementStrategies);
    }

    @Override
    void addImplicitElementTypes(Map<DocumentBuilder.SpanType, SpanStrategy> blockStrategyByElementType, Set<DocumentBuilder.SpanType> elementTypes) {
    }

    @Override
    SpanStrategy getSupportedStrategy(DocumentBuilder.SpanType elementType) {
        return SupportedSpanStrategy.instance;
    }

    @Override
    SpanStrategy getUnsupportedElementStrategy(DocumentBuilder.SpanType elementType) {
        return UnsupportedSpanStrategy.instance;
    }

    @Override
    SpanStrategy createSubstitutionElementStrategy(DocumentBuilder.SpanType alternative) {
        return new SubstitutionSpanStrategy(alternative);
    }

    @Override
    Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> getElementTypeToAlternatives() {
        return spanTypeToAlternatives;
    }

    @Override
    SpanStrategy getElementStrategy(SpanHtmlElementStrategy strategy) {
        return strategy.spanStrategy();
    }

    @Override
    public SpanStrategy getStrategy(DocumentBuilder.SpanType elementType, Attributes attributes) {
        SpanStrategy alternateStrategy;
        SpanStrategy strategy = (SpanStrategy)super.getStrategy(elementType, attributes);
        if (elementType == DocumentBuilder.SpanType.SPAN && strategy instanceof UnsupportedSpanStrategy && (alternateStrategy = this.calculateAlternateSpanStrategy(attributes)) != null) {
            strategy = alternateStrategy;
        }
        return strategy;
    }

    private SpanStrategy calculateAlternateSpanStrategy(Attributes attributes) {
        ImmutableList strategies = new ArrayList();
        String cssStyle = attributes.getCssStyle();
        if (cssStyle != null) {
            Iterator rules = new CssParser().createRuleIterator(cssStyle);
            while (rules.hasNext()) {
                CssRule rule = (CssRule)rules.next();
                if (rule.name.equals("font-weight") && rule.value.equals("bold")) {
                    strategies.add(this.calculateAlternateSpanStrategy(DocumentBuilder.SpanType.BOLD));
                    continue;
                }
                if (rule.name.equals("font-style") && rule.value.equals("italic")) {
                    strategies.add(this.calculateAlternateSpanStrategy(DocumentBuilder.SpanType.ITALIC));
                    continue;
                }
                if (rule.name.equals("text-decoration") && rule.value.equalsIgnoreCase("underline")) {
                    strategies.add(this.calculateAlternateSpanStrategy(DocumentBuilder.SpanType.UNDERLINED));
                    continue;
                }
                if (rule.name.equals("text-decoration") && rule.value.equalsIgnoreCase("line-through")) {
                    strategies.add(this.calculateAlternateSpanStrategy(DocumentBuilder.SpanType.DELETED));
                    continue;
                }
                if (!rule.name.equals("font-family") || !this.isFontFamilyMonospace(rule)) continue;
                strategies.add(new SubstitutionWithoutCssSpanStrategy(DocumentBuilder.SpanType.MONOSPACE));
            }
        }
        if ((strategies = ImmutableList.copyOf((Iterable)FluentIterable.from(strategies).filter(Predicates.not((Predicate)Predicates.isNull())))).isEmpty()) {
            return null;
        }
        if (strategies.size() == 1) {
            return (SpanStrategy)strategies.get(0);
        }
        return new CompositeSpanStrategy((List<SpanStrategy>)strategies);
    }

    private boolean isFontFamilyMonospace(CssRule rule) {
        for (String value : Splitter.on((char)',').trimResults(CharMatcher.whitespace()).split((CharSequence)rule.value)) {
            if (!"monospace".equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private SpanStrategy calculateAlternateSpanStrategy(DocumentBuilder.SpanType spanType) {
        SpanStrategy strategy = (SpanStrategy)super.getStrategy(spanType, new Attributes());
        if (strategy instanceof SupportedSpanStrategy) {
            return new SubstitutionWithoutCssSpanStrategy(spanType);
        }
        if (strategy instanceof SubstitutionSpanStrategy) {
            return new SubstitutionWithoutCssSpanStrategy(((SubstitutionSpanStrategy)strategy).getType());
        }
        return null;
    }
}

