/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AttributeDefinitionBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class HeadingBlock
extends Block {
    private static final Pattern pattern = Pattern.compile("(={1,})\\s+(.+?)(\\s*)((?:=*\\s*))?");
    private Matcher matcher;
    int lineCount;

    public boolean canStart(String line, int lineOffset) {
        Matcher m;
        if (lineOffset == 0 && (m = pattern.matcher(line)).matches() && m.group(1).length() < 6) {
            this.matcher = m;
            return true;
        }
        this.matcher = null;
        return false;
    }

    public int processLineContent(String line, int offset) {
        if (this.lineCount == 0) {
            int declaredLevel = this.matcher.group(1).length();
            int level = LanguageSupport.computeHeadingLevel(declaredLevel, this.getAsciiDocState());
            if (level == 1) {
                AsciiDocContentState asciiDocState = this.getAsciiDocState();
                if (asciiDocState.isHeading1Present() || declaredLevel != 1) {
                    this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
                    this.setClosed(true);
                    return -1;
                }
                asciiDocState.setHeading1Present(true);
            }
            this.emitHeading(level);
            if (level != 1) {
                this.setClosed(true);
            } else {
                ++this.lineCount;
            }
        } else {
            if (line.trim().isEmpty()) {
                this.setClosed(true);
            } else {
                this.processHeaderLine(line);
            }
            ++this.lineCount;
        }
        return -1;
    }

    private void processHeaderLine(String line) {
        if (this.lineCount == 1 && this.processAuthors(line)) {
            return;
        }
        AttributeDefinitionBlock attributeBlock = new AttributeDefinitionBlock();
        if (attributeBlock.canStart(line, 0)) {
            attributeBlock.setState(this.getState());
            attributeBlock.processLineContent(line, 0);
            return;
        }
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, 0);
    }

    private void emitHeading(int level) {
        String text = this.matcher.group(2);
        String closingGroup = this.matcher.group(4);
        HeadingAttributes attributes = new HeadingAttributes();
        if (level == 1) {
            attributes.setId("header");
        } else {
            attributes.setId(this.state.getIdGenerator().newId(null, text));
        }
        this.builder.beginHeading(level, (Attributes)attributes);
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, this.matcher.start(2), text, 0);
        if (closingGroup.length() > 0 && closingGroup.length() != level) {
            this.builder.characters(this.matcher.group(3));
            this.builder.characters(closingGroup);
        }
        this.builder.endHeading();
    }

    private boolean processAuthors(String line) {
        Matcher authorMatcher = Pattern.compile("(?:^|;)\\s*((?:\\w+\\s+)+)\\s*<([^>]+)>\\s*").matcher(line);
        int authorCount = 0;
        while (authorMatcher.find()) {
            if (authorCount == 0) {
                Attributes attributes = new Attributes(null, "details", null, null);
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
            }
            String idCount = ++authorCount > 1 ? Integer.toString(authorCount) : "";
            Attributes attributes = new Attributes("author" + idCount, "author", null, null);
            this.builder.beginSpan(DocumentBuilder.SpanType.SPAN, attributes);
            this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, authorMatcher.group(1).trim(), 0);
            this.builder.endSpan();
            attributes = new Attributes("email" + idCount, "email", null, null);
            this.builder.beginSpan(DocumentBuilder.SpanType.SPAN, attributes);
            this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, authorMatcher.group(2).trim(), 0);
            this.builder.endSpan();
        }
        if (authorCount > 0) {
            this.builder.endBlock();
        }
        return authorCount > 0;
    }

    protected AsciiDocContentState getAsciiDocState() {
        return (AsciiDocContentState)this.state;
    }
}

