/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.mylyn.docs.epub.core.ILogger;
import org.eclipse.mylyn.docs.epub.core.Messages;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.core.ValidationMessage;
import org.eclipse.mylyn.docs.epub.internal.EPUBXMLHelperImp;
import org.eclipse.mylyn.docs.epub.internal.OPSValidator;
import org.eclipse.mylyn.docs.epub.internal.TOCGenerator;
import org.eclipse.mylyn.docs.epub.ncx.DocTitle;
import org.eclipse.mylyn.docs.epub.ncx.Head;
import org.eclipse.mylyn.docs.epub.ncx.Meta;
import org.eclipse.mylyn.docs.epub.ncx.NCXFactory;
import org.eclipse.mylyn.docs.epub.ncx.NCXPackage;
import org.eclipse.mylyn.docs.epub.ncx.NavMap;
import org.eclipse.mylyn.docs.epub.ncx.Ncx;
import org.eclipse.mylyn.docs.epub.ncx.Text;
import org.eclipse.mylyn.docs.epub.ncx.util.NCXResourceFactoryImpl;
import org.eclipse.mylyn.docs.epub.ncx.util.NCXResourceImpl;
import org.eclipse.mylyn.docs.epub.opf.Guide;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.eclipse.mylyn.docs.epub.opf.Itemref;
import org.eclipse.mylyn.docs.epub.opf.Manifest;
import org.eclipse.mylyn.docs.epub.opf.Metadata;
import org.eclipse.mylyn.docs.epub.opf.OPFFactory;
import org.eclipse.mylyn.docs.epub.opf.Spine;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OPSPublication
extends Publication {
    private static final String MIMETYPE_NCX = "application/x-dtbncx+xml";
    private static final String NCX_FILE_SUFFIX = "ncx";
    private static final String TABLE_OF_CONTENTS_ID = "ncx";
    private static final String TOCFILE_NAME = "toc.ncx";
    private static final String[] CORE_MEDIA_TYPES = new String[]{"image/gif", "image/jpeg", "image/png", "image/svg+xml", "application/xhtml+xml", "application/x-dtbook+xml", "text/css", "application/xml", "text/x-oeb1-document", "text/x-oeb1-css", "application/x-dtbncx+xml"};
    private Ncx ncxTOC;

    public OPSPublication() {
        this.setup();
    }

    public OPSPublication(ILogger logger) {
        super(logger);
        this.setup();
    }

    public org.eclipse.mylyn.docs.epub.opf.Meta addMeta(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("A name must be specified");
        }
        org.eclipse.mylyn.docs.epub.opf.Meta opf = OPFFactory.eINSTANCE.createMeta();
        opf.setName(name);
        opf.setContent(value);
        this.opfPackage.getMetadata().getMetas().add((Object)opf);
        return opf;
    }

    @Override
    protected void generateTableOfContents() throws ParserConfigurationException, SAXException, IOException {
        this.log(Messages.getString("OPS2Publication.0"), ILogger.Severity.INFO, this.indent++);
        Meta meta = NCXFactory.eINSTANCE.createMeta();
        meta.setName("dtb:uid");
        meta.setContent(this.getIdentifier().getMixed().getValue(0).toString());
        this.ncxTOC.getHead().getMetas().add((Object)meta);
        int playOrder = 0;
        EList<Itemref> spineItems = this.getSpine().getSpineItems();
        EList<Item> manifestItems = this.opfPackage.getManifest().getItems();
        for (Itemref itemref : spineItems) {
            Item referencedItem = null;
            String id = itemref.getIdref();
            for (Item item : manifestItems) {
                if (!item.getId().equals(id)) continue;
                referencedItem = item;
                break;
            }
            if (referencedItem == null || referencedItem.isNoToc() || !referencedItem.getMedia_type().equals("application/xhtml+xml")) continue;
            File file = new File(referencedItem.getFile());
            FileInputStream fis = new FileInputStream(file);
            this.log(MessageFormat.format(Messages.getString("OPS2Publication.1"), referencedItem.getHref()), ILogger.Severity.VERBOSE, this.indent);
            playOrder = TOCGenerator.parse(new InputSource(fis), referencedItem.getHref(), this.ncxTOC, playOrder);
        }
        --this.indent;
    }

    @Override
    public Object getTableOfContents() {
        return this.ncxTOC;
    }

    @Override
    protected String getVersion() {
        return "2.0";
    }

    private boolean isLegalType(Item item) {
        boolean legal = false;
        for (String type : CORE_MEDIA_TYPES) {
            if (!item.getMedia_type().equals(type)) continue;
            legal = true;
        }
        return legal;
    }

    @Override
    protected void readTableOfContents(File tocFile) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)tocFile.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(null);
        this.ncxTOC = (Ncx)resource.getContents().get(0);
    }

    private void registerNCXResourceFactory() {
        NCXPackage packageInstance = NCXPackage.eINSTANCE;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ncx", new NCXResourceFactoryImpl(){

            @Override
            public Resource createResource(URI uri) {
                NCXResourceImpl xmiResource = new NCXResourceImpl(uri){

                    protected XMLHelper createXMLHelper() {
                        EPUBXMLHelperImp xmlHelper = new EPUBXMLHelperImp();
                        return xmlHelper;
                    }
                };
                Map loadOptions = xmiResource.getDefaultLoadOptions();
                Map saveOptions = xmiResource.getDefaultSaveOptions();
                saveOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
                loadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                saveOptions.put("ENCODING", "UTF-8");
                HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
                parserFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
                parserFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                loadOptions.put("PARSER_FEATURES", parserFeatures);
                return xmiResource;
            }
        });
    }

    @Override
    public void setCover(File image, String title) {
        Item item = this.addItem("cover-image", null, image, null, null, false, false, true);
        item.setTitle(title);
        this.addMeta("cover", "cover-image");
        this.opfPackage.setGenerateCoverHTML(true);
    }

    @Override
    public void setTableOfContents(File ncxFile) {
        Item item = this.addItem(this.opfPackage.getSpine().getToc(), null, ncxFile, null, MIMETYPE_NCX, false, false, false);
        this.opfPackage.getManifest().getItems().move(0, (Object)item);
        this.log(MessageFormat.format("Using table of contents file {0} for OPS", ncxFile.getName()), ILogger.Severity.VERBOSE, this.indent);
    }

    private void setup() {
        this.opfPackage.setVersion(this.getVersion());
        this.configureNCX();
        Metadata opfMetadata = OPFFactory.eINSTANCE.createMetadata();
        this.opfPackage.setMetadata(opfMetadata);
        Guide opfGuide = OPFFactory.eINSTANCE.createGuide();
        this.opfPackage.setGuide(opfGuide);
        Manifest opfManifest = OPFFactory.eINSTANCE.createManifest();
        this.opfPackage.setManifest(opfManifest);
        Spine opfSpine = OPFFactory.eINSTANCE.createSpine();
        opfSpine.setToc("ncx");
        this.opfPackage.setSpine(opfSpine);
        this.registerNCXResourceFactory();
        this.opfPackage.setGenerateTableOfContents(true);
    }

    private void configureNCX() {
        this.ncxTOC = NCXFactory.eINSTANCE.createNcx();
        this.ncxTOC.setVersion("2005-1");
        Head head = NCXFactory.eINSTANCE.createHead();
        this.ncxTOC.setHead(head);
        DocTitle docTitle = NCXFactory.eINSTANCE.createDocTitle();
        Text text = NCXFactory.eINSTANCE.createText();
        FeatureMapUtil.addText((FeatureMap)text.getMixed(), (String)"Table of contents");
        docTitle.setText(text);
        this.ncxTOC.setDocTitle(docTitle);
        NavMap navMap = NCXFactory.eINSTANCE.createNavMap();
        this.ncxTOC.setNavMap(navMap);
    }

    @Override
    protected List<ValidationMessage> validateContents() throws ParserConfigurationException, SAXException, IOException {
        EList<Item> manifestItems = this.opfPackage.getManifest().getItems();
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Item item : manifestItems) {
            if (item.getFile() == null) {
                String href;
                File rootFolder = this.getRootFolder();
                File file = new File(rootFolder, href = item.getHref());
                if (!file.exists()) {
                    messages.add(new ValidationMessage(ValidationMessage.Severity.ERROR, MessageFormat.format(Messages.getString("OPSPublication.7"), item.getHref())));
                }
                item.setFile(file.toString());
            }
            if (!this.isLegalType(item)) {
                Item fallback = this.getItemById(item.getFallback());
                if (fallback == null) {
                    messages.add(new ValidationMessage(ValidationMessage.Severity.WARNING, MessageFormat.format(Messages.getString("OPS2Publication.13"), item.getHref())));
                } else if (!this.isLegalType(fallback)) {
                    messages.add(new ValidationMessage(ValidationMessage.Severity.WARNING, MessageFormat.format(Messages.getString("OPS2Publication.14"), item.getHref())));
                } else {
                    messages.add(new ValidationMessage(ValidationMessage.Severity.WARNING, MessageFormat.format(Messages.getString("OPS2Publication.15"), item.getHref())));
                }
            }
            if (!item.getMedia_type().equals("application/xhtml+xml")) continue;
            File file = new File(item.getFile());
            FileReader fr = new FileReader(file);
            messages.addAll(OPSValidator.validate(new InputSource(fr), item.getHref()));
        }
        return messages;
    }

    @Override
    protected void writeTableOfContents(File oepbsFolder) throws IOException, ParserConfigurationException, SAXException {
        if (this.getItemById(this.opfPackage.getSpine().getToc()) == null) {
            this.configureNCX();
            File ncxFile = new File(oepbsFolder.getAbsolutePath() + File.separator + TOCFILE_NAME);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getPackageRegistry().put((Object)"http://www.daisy.org/z3986/2005/ncx/", (Object)NCXPackage.eINSTANCE);
            URI fileURI = URI.createFileURI((String)ncxFile.getAbsolutePath());
            Resource resource = resourceSet.createResource(fileURI);
            if (this.opfPackage.isGenerateTableOfContents()) {
                this.generateTableOfContents();
            }
            resource.getContents().add((Object)this.ncxTOC);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("ENCODING", "UTF-8");
            options.put("EXTENDED_META_DATA", Boolean.TRUE);
            resource.save(options);
            Item item = this.addItem(this.opfPackage.getSpine().getToc(), null, ncxFile, null, MIMETYPE_NCX, false, false, false);
            this.opfPackage.getManifest().getItems().move(0, (Object)item);
        }
    }
}

