/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class EscapedCharacter
extends Inline {
    private final char character;

    public EscapedCharacter(Line line, int offset, char c) {
        super(line, offset, 2);
        this.character = c;
    }

    @Override
    public void emit(DocumentBuilder builder) {
        builder.characters(Character.toString(this.character));
    }

    public char getCharacter() {
        return this.character;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOffset(), this.getLength(), Character.valueOf(this.character));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EscapedCharacter other = (EscapedCharacter)obj;
        return this.character == other.character;
    }
}

