/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.ActionExecutionMonitor;
import org.eclipse.mylyn.internal.monitor.ui.ActivityChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.KeybindingCommandMonitor;
import org.eclipse.mylyn.internal.monitor.ui.MenuCommandMonitor;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.monitor.ui.PerspectiveChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.PreferenceChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.WindowChangeMonitor;
import org.eclipse.mylyn.internal.monitor.usage.CheckForUploadJob;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylyn.internal.monitor.usage.LogMoveUtility;
import org.eclipse.mylyn.internal.monitor.usage.Messages;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorExtensionPointReader;
import org.eclipse.mylyn.internal.monitor.usage.UsageUploadManager;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.ui.AbstractCommandMonitor;
import org.eclipse.mylyn.monitor.ui.IActionExecutionListener;
import org.eclipse.mylyn.monitor.ui.IMonitorLifecycleListener;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UiUsageMonitorPlugin
extends AbstractUIPlugin {
    private static final int MINUTE = 60000;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long DELAY_ON_USER_REQUEST = 432000000L;
    public static final long DEFAULT_DELAY_DAYS_BETWEEN_TRANSMITS = 21L;
    public static final long DEFAULT_DELAY_BETWEEN_TRANSMITS = 1814400000L;
    private static final long START_CHECK_UPLOAD_JOB_DELAY = 120000L;
    private static final long CHECK_UPLOAD_JOB_INTERVAL = 90000000L;
    private static final String METADATA_MYLYN_DIR = "/.metadata/.mylyn";
    public static final String MONITOR_LOG_NAME = "monitor-log";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.monitor.usage";
    private InteractionEventLogger interactionLogger;
    private PreferenceChangeMonitor preferenceMonitor;
    private PerspectiveChangeMonitor perspectiveMonitor;
    private ActivityChangeMonitor activityMonitor;
    private MenuCommandMonitor menuMonitor;
    private WindowChangeMonitor windowMonitor;
    private KeybindingCommandMonitor keybindingCommandMonitor;
    private static UiUsageMonitorPlugin plugin;
    private final List<IActionExecutionListener> actionExecutionListeners = new ArrayList<IActionExecutionListener>();
    private final List<AbstractCommandMonitor> commandMonitors = new ArrayList<AbstractCommandMonitor>();
    private static boolean performingUpload;
    private StudyParameters studyParameters = new StudyParameters();
    private final ListenerList lifecycleListeners = new ListenerList();
    private final UsageUploadManager uploadManager = new UsageUploadManager();
    private LogMoveUtility logMoveUtility;
    private Job checkForUploadJob;
    private boolean isSubmissionWizardOpen;

    static {
        performingUpload = false;
    }

    public UiUsageMonitorPlugin() {
        plugin = this;
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.obfuscate", true);
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.enabled", true);
        }
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.submission.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.submission.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.enable.submission", true);
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.ui.events.observed.last.upload")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.events.observed.last.upload", this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed"));
        }
        this.checkForUploadJob = new CheckForUploadJob(display);
        this.checkForUploadJob.setSystem(true);
        this.checkForUploadJob.schedule(120000L);
        this.checkForUploadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() != null && event.getResult().isOK()) {
                    UiUsageMonitorPlugin.this.checkForUploadJob.schedule(90000000L);
                }
            }
        });
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    UiUsageMonitorExtensionPointReader uiUsageMonitorExtensionPointReader = new UiUsageMonitorExtensionPointReader();
                    UiUsageMonitorPlugin.this.studyParameters = uiUsageMonitorExtensionPointReader.getStudyParameters();
                    if (UiUsageMonitorPlugin.this.studyParameters == null || UiUsageMonitorPlugin.this.studyParameters.isEmpty()) {
                        UiUsageMonitorPlugin.this.initializeDefaultStudyParameters();
                    }
                    if (UiUsageMonitorPlugin.this.preferenceMonitor == null) {
                        UiUsageMonitorPlugin.this.preferenceMonitor = new PreferenceChangeMonitor();
                    }
                    UiUsageMonitorPlugin.this.interactionLogger = new InteractionEventLogger(UiUsageMonitorPlugin.this.getMonitorLogFile());
                    UiUsageMonitorPlugin.this.perspectiveMonitor = new PerspectiveChangeMonitor();
                    UiUsageMonitorPlugin.this.activityMonitor = new ActivityChangeMonitor();
                    UiUsageMonitorPlugin.this.windowMonitor = new WindowChangeMonitor();
                    UiUsageMonitorPlugin.this.menuMonitor = new MenuCommandMonitor();
                    UiUsageMonitorPlugin.this.keybindingCommandMonitor = new KeybindingCommandMonitor();
                    if (UiUsageMonitorPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled")) {
                        UiUsageMonitorPlugin.this.startMonitoring();
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, UiUsageMonitorPlugin.ID_PLUGIN, "Monitor failed to start", t));
                }
            }
        });
    }

    public void startMonitoring() {
        if (this.studyParameters == null || !this.studyParameters.isComplete()) {
            return;
        }
        if (this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.monitoring.started")) {
            return;
        }
        this.interactionLogger.startMonitoring();
        for (IInteractionEventListener listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.startMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MonitorUi.addInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().add((AbstractCommandMonitor)this.keybindingCommandMonitor);
        this.getActionExecutionListeners().add((IActionExecutionListener)new ActionExecutionMonitor());
        if (this.logMoveUtility == null) {
            this.logMoveUtility = new LogMoveUtility();
        }
        this.logMoveUtility.start();
        MonitorUiPlugin.getDefault().addWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        workbench.getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this.activityMonitor);
        workbench.getDisplay().addFilter(13, (Listener)this.menuMonitor);
        workbench.addWindowListener((IWindowListener)this.windowMonitor);
        Object[] objectArray = this.lifecycleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMonitorLifecycleListener)listener).startMonitoring();
            ++n2;
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", true);
    }

    public void addMonitoredPreferences(IPreferenceStore preferences) {
        if (this.preferenceMonitor == null) {
            this.preferenceMonitor = new PreferenceChangeMonitor();
        }
        preferences.addPropertyChangeListener((IPropertyChangeListener)this.preferenceMonitor);
    }

    public void removeMonitoredPreferences(IPreferenceStore preferences) {
        if (this.preferenceMonitor != null) {
            preferences.removePropertyChangeListener((IPropertyChangeListener)this.preferenceMonitor);
        } else {
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "UI Usage Monitor not started", (Throwable)new Exception()));
        }
    }

    public boolean isObfuscationEnabled() {
        return UiUsageMonitorPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.obfuscate") || this.studyParameters != null && this.studyParameters.forceObfuscation();
    }

    public void stopMonitoring() {
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.monitoring.started")) {
            return;
        }
        Object[] objectArray = this.lifecycleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMonitorLifecycleListener)listener).stopMonitoring();
            ++n2;
        }
        for (Object listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.stopMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MonitorUi.removeInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().remove(this.keybindingCommandMonitor);
        this.getActionExecutionListeners().remove(new ActionExecutionMonitor());
        this.logMoveUtility.stop();
        MonitorUiPlugin.getDefault().removeWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        if (workbench != null) {
            if (workbench.getActivitySupport() != null) {
                workbench.getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this.activityMonitor);
            }
            if (workbench.getDisplay() != null && !workbench.getDisplay().isDisposed()) {
                workbench.getDisplay().removeFilter(13, (Listener)this.menuMonitor);
                workbench.removeWindowListener((IWindowListener)this.windowMonitor);
            }
        }
        this.interactionLogger.stopMonitoring();
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", false);
    }

    public void addMonitoringLifecycleListener(IMonitorLifecycleListener listener) {
        this.lifecycleListeners.add((Object)listener);
        if (this.isMonitoringEnabled()) {
            listener.startMonitoring();
        }
    }

    public void removeMonitoringLifecycleListener(IMonitorLifecycleListener listener) {
        this.lifecycleListeners.remove((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        this.stopMonitoring();
        super.stop(context);
        plugin = null;
    }

    public void actionObserved(IAction action, String info) {
        for (IActionExecutionListener listener : this.actionExecutionListeners) {
            listener.actionObserved(action);
        }
    }

    public List<IActionExecutionListener> getActionExecutionListeners() {
        return this.actionExecutionListeners;
    }

    public List<AbstractCommandMonitor> getCommandMonitors() {
        return this.commandMonitors;
    }

    public File getMonitorLogFile() {
        File rootDir = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + METADATA_MYLYN_DIR);
        File file = new File(rootDir, "monitor-log.xml");
        if (!file.exists() || !file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not create monitor file", (Throwable)e));
            }
        }
        return file;
    }

    public void userCancelSubmitFeedback(Date currentTime, boolean delay) {
        Date lastTransmit = this.getLastTransmitDate();
        if (delay) {
            lastTransmit.setTime(currentTime.getTime() + 432000000L - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        } else {
            long day = 86400000L;
            lastTransmit.setTime(currentTime.getTime() + day - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
    }

    public Date getLastTransmitDate() {
        Date lastTransmit;
        if (UiUsageMonitorPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.monitor.ui.upload.previousTransmit")) {
            lastTransmit = new Date(UiUsageMonitorPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.upload.previousTransmit"));
        } else {
            lastTransmit = new Date();
            UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
        return lastTransmit;
    }

    public static UiUsageMonitorPlugin getDefault() {
        return plugin;
    }

    public void incrementObservedEvents(int increment) {
        int numEvents = this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed");
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.events.observed", numEvents += increment);
        numEvents = this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed.last.upload");
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.events.observed.last.upload", numEvents += increment);
        this.savePluginPreferences();
    }

    public void resetEventsSinceUpload() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.events.observed.last.upload", 0);
        this.savePluginPreferences();
    }

    public static boolean isPerformingUpload() {
        return performingUpload;
    }

    public static void setPerformingUpload(boolean performingUpload) {
        UiUsageMonitorPlugin.performingUpload = performingUpload;
    }

    public InteractionEventLogger getInteractionLogger() {
        return this.interactionLogger;
    }

    public StudyParameters getStudyParameters() {
        return this.studyParameters;
    }

    public boolean isMonitoringEnabled() {
        return this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled");
    }

    private void initializeDefaultStudyParameters() {
        this.studyParameters = new StudyParameters();
        this.studyParameters.setVersion("");
        this.studyParameters.setUploadServletUrl("http://mylyn.eclipse.org/monitor/upload/MylarUsageUploadServlet");
        this.studyParameters.setUserIdServletUrl("http://mylyn.eclipse.org/monitor/upload/GetUserIDServlet");
        this.studyParameters.setTitle(Messages.UiUsageMonitorPlugin_Mylyn_Feedback);
        this.studyParameters.setDescription(Messages.UiUsageMonitorPlugin_Fill_Out_Form);
        this.studyParameters.setTransmitPromptPeriod(1814400000L);
        this.studyParameters.setUseContactField("false");
        this.studyParameters.setAcceptedUrlList("");
        this.studyParameters.setFormsConsent("/doc/study-ethics.html");
        this.studyParameters.setUsagePageUrl("http://mylyn.eclipse.org/monitor/upload/usageSummary.html");
        this.studyParameters.setStudyName(Messages.UiUsageMonitorPlugin_Eclipse_Mylyn);
        this.studyParameters.addFilteredIdPattern("org.eclipse.");
    }

    public UsageUploadManager getUploadManager() {
        return this.uploadManager;
    }

    public boolean isSubmissionWizardOpen() {
        return this.isSubmissionWizardOpen;
    }

    public void setSubmissionWizardOpen(boolean isSubmissionWizardOpen) {
        this.isSubmissionWizardOpen = isSubmissionWizardOpen;
    }

    public static class UiUsageMonitorStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

