/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.internal.sandbox.search.ui.AbstractUiHandler;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.sandbox.search.ui.Search;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;

public class PerfomSearchHandler
extends AbstractUiHandler
implements IHandler {
    public static final String PARAM_SEARCH_TEXT = "org.eclipse.mylyn.sandbox.search.ui.searchText";
    public static final String PARAM_FILENAME_FILTER = "org.eclipse.mylyn.sandbox.search.ui.filenameFilter";

    @Override
    protected Runnable computeUiRunnable(final ExecutionEvent event) {
        String searchText = event.getParameter(PARAM_SEARCH_TEXT);
        String filenameFilter = event.getParameter(PARAM_FILENAME_FILTER);
        final SearchCriteria criteria = new SearchCriteria();
        criteria.setFilenamePatternsAsText(filenameFilter);
        criteria.setText(searchText);
        return new Runnable(){

            @Override
            public void run() {
                ISearchQuery searchQuery;
                try {
                    searchQuery = Search.createSearchQuery(criteria);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)PerfomSearchHandler.this.computeWorkbenchWindow(event).getShell(), (String)Messages.DesktopSearchPage_SearchFailedTitle, (String)NLS.bind((String)Messages.DesktopSearchPage_SearchFailedMessage, (Object)e.getStatus().getMessage()), (IStatus)e.getStatus());
                    return;
                }
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
        };
    }
}

