/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SearchResultLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

    public Image getImage(Object element) {
        return this.labelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    public void dispose() {
        this.labelProvider.dispose();
        this.labelProvider = null;
        super.dispose();
    }

    public StyledString getStyledText(Object element) {
        String name = null;
        String qualifier = null;
        if (element instanceof SearchResult) {
            SearchResult result = (SearchResult)((Object)element);
            name = result.getFile().getName();
            IResource resource = result.getResource();
            if (resource != null) {
                element = resource;
            }
            qualifier = result.getFile().getParentFile().getPath();
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            name = resource.getName();
            qualifier = resource.getParent().getFullPath().toString();
        }
        if (name != null) {
            StyledString string = new StyledString(name);
            String decorated = NLS.bind((String)Messages.SearchResultLabelProvider_QualifierFormat, (Object[])new String[]{string.toString(), qualifier});
            StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)string);
            return string;
        }
        return new StyledString(this.labelProvider.getText(element));
    }
}

