/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell.decorator;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PaddingDecorator
extends CellPainterWrapper {
    private final int topPadding;
    private final int rightPadding;
    private final int bottomPadding;
    private final int leftPadding;

    public PaddingDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, 2);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int padding) {
        this(interiorPainter, padding, padding, padding, padding);
    }

    public PaddingDecorator(ICellPainter interiorPainter, int topPadding, int rightPadding, int bottomPadding, int leftPadding) {
        super(interiorPainter);
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.leftPadding + super.getPreferredWidth(cell, gc, configRegistry) + this.rightPadding;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.topPadding + super.getPreferredHeight(cell, gc, configRegistry) + this.bottomPadding;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle interiorBounds = this.getInteriorBounds(adjustedCellBounds);
        Color originalBg = gc.getBackground();
        Color cellStyleBackground = this.getBackgroundColor(cell, configRegistry);
        gc.setBackground(cellStyleBackground != null ? cellStyleBackground : originalBg);
        gc.fillRectangle(adjustedCellBounds);
        gc.setBackground(originalBg);
        if (interiorBounds.width > 0 && interiorBounds.height > 0) {
            super.paintCell(cell, gc, interiorBounds, configRegistry);
        }
    }

    public Rectangle getInteriorBounds(Rectangle adjustedCellBounds) {
        return new Rectangle(adjustedCellBounds.x + this.leftPadding, adjustedCellBounds.y + this.topPadding, adjustedCellBounds.width - this.leftPadding - this.rightPadding, adjustedCellBounds.height - this.topPadding - this.bottomPadding);
    }

    protected Color getBackgroundColor(ILayerCell cell, IConfigRegistry configRegistry) {
        return CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }
}

