/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._100_Layers;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TreeList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.DetailGlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.SortableTreeComparator;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TreeGridExample
extends AbstractNatExample {
    protected static final String NO_SORT_LABEL = "noSortLabel";
    private Map<String, Datum> datums = new HashMap<String, Datum>();

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(800, 400, new TreeGridExample());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)DefaultComparator.getInstance());
        this.createDatums();
        EventList eventList = GlazedLists.eventList(this.datums.values());
        SortedList sortedList = new SortedList(eventList, null);
        String[] propertyNames = new String[]{"foo", "bar"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        GlazedListsSortModel sortModel = new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer);
        TreeList treeList = new TreeList((EventList)sortedList, (TreeList.Format)new DatumTreeFormat((ISortModel)sortModel), (TreeList.ExpansionModel)new DatumExpansionModel());
        GlazedListTreeData treeData = new GlazedListTreeData(treeList);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)treeList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        DetailGlazedListsEventLayer glazedListsEventLayer = new DetailGlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, (EventList)treeList);
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        RowHideShowLayer rowHideShowLayer = new RowHideShowLayer((IUniqueIndexLayer)columnHideShowLayer);
        TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)rowHideShowLayer, (ITreeRowModel)new GlazedListTreeRowModel(treeData), false);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)treeLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)columnHeaderDataLayer);
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)sortModel, false);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
                return super.createRowHeaderMenu(natTable).withHideRowMenuItem().withShowAllRowsMenuItem();
            }
        });
        natTable.addConfiguration((IConfiguration)new DefaultTreeLayerConfiguration(treeLayer));
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.configure();
        return natTable;
    }

    protected void printTree(TreeList<Datum> treeList, ITreeData<Datum> treeData) {
        System.out.println(treeList.size());
        int i = 0;
        while (i < treeList.size()) {
            Datum location = (Datum)treeList.get(i);
            int depth = treeList.depth(i);
            boolean hasChildren = treeList.hasChildren(i);
            boolean isExpanded = treeList.isExpanded(i);
            int j = 0;
            while (j < depth) {
                System.out.print("\t");
                ++j;
            }
            if (hasChildren) {
                System.out.print(isExpanded ? "- " : "+ ");
            } else {
                System.out.print("  ");
            }
            System.out.println(location.getFoo());
            ++i;
        }
    }

    private void createDatum(String parent, String foo, int bar) {
        Datum datum = new Datum(this.datums.get(parent), foo, bar);
        this.datums.put(foo, datum);
    }

    private void createDatums() {
        this.createDatum(null, "root", 2);
        this.createDatum("root", "A", 10);
        this.createDatum("A", "A.1", 100);
        this.createDatum("A", "A.2", 110);
        this.createDatum("A", "A.3", 120);
        this.createDatum("root", "B", 20);
        this.createDatum("B", "B.1", 200);
        this.createDatum("B", "B.2", 210);
        this.createDatum("root", "C", 30);
        this.createDatum("C", "C.1", 330);
        this.createDatum("C", "C.2", 370);
        this.createDatum("C", "C.3", 322);
        this.createDatum("C", "C.4", 310);
        this.createDatum("C", "C.5", 315);
        this.createDatum(null, "root2", 2);
        this.createDatum("root2", "X", 70);
        this.createDatum("X", "X.1", 700);
        this.createDatum("X", "X.2", 710);
        this.createDatum("X", "X.3", 720);
        this.createDatum("root2", "Y", 80);
        this.createDatum("Y", "Y.1", 800);
        this.createDatum("Y", "Y.2", 810);
        this.createDatum("root2", "Z", 90);
        this.createDatum("Z", "Z.1", 900);
        this.createDatum("Z", "Z.2", 910);
        this.createDatum("Z", "Z.3", 920);
        this.createDatum("Z", "Z.4", 930);
        this.createDatum("Z", "Z.5", 940);
    }

    public class Datum {
        private final Datum parent;
        private String foo;
        private int bar;

        public Datum(Datum parent, String foo, int bar) {
            this.parent = parent;
            this.foo = foo;
            this.bar = bar;
        }

        public Datum getParent() {
            return this.parent;
        }

        public String getFoo() {
            return this.foo;
        }

        public int getBar() {
            return this.bar;
        }

        public String toString() {
            return "[parent=" + this.parent + ", foo=" + this.foo + ", bar=" + this.bar + "]";
        }
    }

    private static class DatumExpansionModel
    implements TreeList.ExpansionModel<Datum> {
        private DatumExpansionModel() {
        }

        public boolean isExpanded(Datum element, List<Datum> path) {
            return true;
        }

        public void setExpanded(Datum element, List<Datum> path, boolean expanded) {
        }
    }

    private static class DatumTreeFormat
    implements TreeList.Format<Datum> {
        private final ISortModel sortModel;

        public DatumTreeFormat(ISortModel sortModel) {
            this.sortModel = sortModel;
        }

        public void getPath(List<Datum> path, Datum element) {
            path.add(element);
            Datum parent = element.getParent();
            while (parent != null) {
                path.add(parent);
                parent = parent.getParent();
            }
            Collections.reverse(path);
        }

        public boolean allowsChildren(Datum element) {
            return true;
        }

        public Comparator<Datum> getComparator(int depth) {
            final Comparator dComp = GlazedLists.beanPropertyComparator(Datum.class, (String)"foo", (String[])new String[0]);
            Comparator<Datum> test = new Comparator<Datum>(){

                @Override
                public int compare(Datum o1, Datum o2) {
                    int result = 0;
                    if (o1.getParent() != null && o2.getParent() != null) {
                        Integer o1Depth = this.depth(o1);
                        Integer o2Depth = this.depth(o2);
                        if (o1Depth > o2Depth) {
                            result = dComp.compare(o1.getParent(), o2);
                            if (result == 0) {
                                return 1;
                            }
                        } else {
                            result = dComp.compare(o1, o2.getParent());
                            if (result == 0) {
                                return -1;
                            }
                        }
                    } else if (!this.isRoot(o1) && this.isRoot(o2)) {
                        result = dComp.compare(this.getRoot(o1), o2);
                        if (result == 0) {
                            result = -1;
                        }
                    } else if (this.isRoot(o1) && !this.isRoot(o2)) {
                        result = dComp.compare(o1, this.getRoot(o2));
                        if (result == 0) {
                            result = 1;
                        }
                    } else if (this.isRoot(o1) && this.isRoot(o2)) {
                        return dComp.compare(o1, o2);
                    }
                    return result;
                }

                int depth(Datum datum) {
                    int d = 0;
                    while (datum.getParent() != null) {
                        ++d;
                        datum = datum.getParent();
                    }
                    return d;
                }

                boolean isRoot(Datum datum) {
                    return datum.getParent() == null;
                }

                Datum getRoot(Datum datum) {
                    Datum result = datum;
                    while (!this.isRoot(result)) {
                        result = result.getParent();
                    }
                    return result;
                }
            };
            return new SortableTreeComparator((Comparator)test, this.sortModel);
        }
    }
}

