/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.SelectionExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.ButtonCellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellLabelMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.DebugMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class Rendereing_a_cell_as_a_button
extends AbstractNatExample {
    public static final String CUSTOM_CELL_LABEL = "Cell_LABEL";
    private ButtonCellPainter buttonPainter;
    private SelectionExampleGridLayer gridLayer;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new Rendereing_a_cell_as_a_button());
    }

    @Override
    public String getDescription() {
        return "Demonstrates rendering the cell as a button. Custom actions can be triggered on button click.\n\nNote: The button is 'drawn' using a custom painter. This is more efficient than using a Button widget.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.gridLayer = new SelectionExampleGridLayer();
        NatTable natTable = new NatTable(parent, (ILayer)this.gridLayer, false);
        ConfigRegistry configRegistry = new ConfigRegistry();
        DataLayer bodyDataLayer = this.gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator cellLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        cellLabelAccumulator.registerColumnOverrides(2, new String[]{CUSTOM_CELL_LABEL});
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)cellLabelAccumulator);
        this.addButtonToColumn((IConfigRegistry)configRegistry, (Composite)natTable);
        natTable.addConfiguration(new ButtonClickConfiguration(this.buttonPainter));
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        parent.setLayout((Layout)new GridLayout(1, true));
        natTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTextArea(parent);
        return natTable;
    }

    private void addButtonToColumn(IConfigRegistry configRegistry, Composite parent) {
        this.buttonPainter = new ButtonCellPainter((ICellPainter)new CellPainterDecorator((ICellPainter)new TextPainter(), CellEdgeEnum.RIGHT, (ICellPainter)new ImagePainter(GUIHelper.getImage((String)"preferences"))));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.buttonPainter, "NORMAL", CUSTOM_CELL_LABEL);
        this.buttonPainter.addClickListener((IMouseAction)new MyMouseAction());
        Style style = new Style();
        style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", CUSTOM_CELL_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT", CUSTOM_CELL_LABEL);
    }

    class ButtonClickConfiguration<T>
    extends AbstractUiBindingConfiguration {
        private final ButtonCellPainter buttonCellPainter;

        public ButtonClickConfiguration(ButtonCellPainter buttonCellPainter) {
            this.buttonCellPainter = buttonCellPainter;
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            CellLabelMouseEventMatcher mouseEventMatcher = new CellLabelMouseEventMatcher("BODY", 1, Rendereing_a_cell_as_a_button.CUSTOM_CELL_LABEL);
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)mouseEventMatcher, (IMouseAction)this.buttonCellPainter);
        }
    }

    class MyMouseAction
    implements IMouseAction {
        MyMouseAction() {
        }

        public void run(NatTable natTable, MouseEvent event) {
            NatEventData eventData = NatEventData.createInstanceFromEvent((MouseEvent)event);
            int rowIndex = natTable.getRowIndexByPosition(eventData.getRowPosition());
            int columnIndex = natTable.getColumnIndexByPosition(eventData.getColumnPosition());
            ListDataProvider<RowDataFixture> dataProvider = Rendereing_a_cell_as_a_button.this.gridLayer.getBodyDataProvider();
            Object rowObject = dataProvider.getRowObject(rowIndex);
            Object cellData = dataProvider.getDataValue(columnIndex, rowIndex);
            Rendereing_a_cell_as_a_button.this.log("Clicked on cell: " + cellData);
            Rendereing_a_cell_as_a_button.this.log("Clicked on row: " + rowObject + "\n");
        }
    }
}

