/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class FullFeaturedColumnHeaderLayerStack<T>
extends AbstractLayerTransform {
    private final ColumnHeaderLayer columnHeaderLayer;
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    private final SortHeaderLayer<T> sortableColumnHeaderLayer;
    private final IDataProvider columnHeaderDataProvider;
    private final DefaultColumnHeaderDataLayer columnHeaderDataLayer;

    public FullFeaturedColumnHeaderLayerStack(SortedList<T> sortedList, FilterList<T> filterList, String[] propertyNames, Map<String, String> propertyToLabelMap, ILayer bodyLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel, IConfigRegistry configRegistry) {
        this.columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(this.columnHeaderDataProvider);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, bodyLayer, selectionLayer);
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        this.sortableColumnHeaderLayer = new SortHeaderLayer((ILayer)this.columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, configRegistry, (ILayer)this.columnHeaderDataLayer));
        this.columnGroupHeaderLayer = new ColumnGroupHeaderLayer(this.sortableColumnHeaderLayer, selectionLayer, columnGroupModel);
        FilterRowHeaderComposite composite = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(filterList, (IColumnAccessor)columnPropertyAccessor, configRegistry), (ILayer)this.columnGroupHeaderLayer, this.columnHeaderDataProvider, configRegistry);
        this.setUnderlyingLayer((ILayer)composite);
    }

    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
    }

    public ColumnGroupHeaderLayer getColumnGroupHeaderLayer() {
        return this.columnGroupHeaderLayer;
    }

    public ColumnHeaderLayer getColumnHeaderLayer() {
        return this.columnHeaderLayer;
    }

    public IDataProvider getColumnHeaderDataProvider() {
        return this.columnHeaderDataProvider;
    }

    public DefaultColumnHeaderDataLayer getColumnHeaderDataLayer() {
        return this.columnHeaderDataLayer;
    }
}

