/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.GlazedListsColumnHeaderLayerStack;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class GlazedListsGridLayer<T>
extends GridLayer {
    private ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private DataLayer bodyDataLayer;
    private DefaultBodyLayerStack bodyLayerStack;
    private ListDataProvider<T> bodyDataProvider;
    private GlazedListsColumnHeaderLayerStack<T> columnHeaderLayerStack;

    public GlazedListsGridLayer(EventList<T> eventList, String[] propertyNames, Map<String, String> propertyToLabelMap, IConfigRegistry configRegistry) {
        this(eventList, propertyNames, propertyToLabelMap, configRegistry, true);
    }

    public GlazedListsGridLayer(EventList<T> eventList, String[] propertyNames, Map<String, String> propertyToLabelMap, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(eventList, (IColumnPropertyAccessor<T>)new ReflectiveColumnPropertyAccessor(propertyNames), (IDataProvider)new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap), configRegistry, useDefaultConfiguration);
    }

    public GlazedListsGridLayer(EventList<T> eventList, IColumnPropertyAccessor<T> columnPropertyAccessor, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        SortedList sortedList = new SortedList(eventList, null);
        this.bodyDataProvider = new ListDataProvider((List)sortedList, columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, eventList);
        this.bodyLayerStack = new DefaultBodyLayerStack((IUniqueIndexLayer)glazedListsEventLayer);
        this.columnHeaderLayerStack = new GlazedListsColumnHeaderLayerStack<T>(columnHeaderDataProvider, sortedList, columnPropertyAccessor, configRegistry, this.bodyLayerStack);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(this.columnHeaderLayerStack.getDataProvider(), (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, this.columnHeaderLayerStack);
        this.setBodyLayer((ILayer)this.bodyLayerStack);
        this.setColumnHeaderLayer((ILayer)this.columnHeaderLayerStack);
        this.setRowHeaderLayer((ILayer)rowHeaderLayer);
        this.setCornerLayer((ILayer)cornerLayer);
    }

    public ColumnOverrideLabelAccumulator getColumnLabelAccumulator() {
        return this.columnLabelAccumulator;
    }

    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public ListDataProvider<T> getBodyDataProvider() {
        return this.bodyDataProvider;
    }

    public GlazedListsColumnHeaderLayerStack<T> getColumnHeaderLayerStack() {
        return this.columnHeaderLayerStack;
    }

    public DefaultBodyLayerStack getBodyLayerStack() {
        return this.bodyLayerStack;
    }
}

