/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class ScrollBarHandlerTemplate
implements Listener {
    public static final int DEFAULT_OFFSET = 1;
    protected final ViewportLayer viewportLayer;
    protected final IUniqueIndexLayer scrollableLayer;
    protected final IScroller<?> scroller;
    private boolean dragging = false;
    private boolean globalHandle = true;
    private NatTable table;

    public ScrollBarHandlerTemplate(ViewportLayer viewportLayer, IScroller<?> scroller) {
        this.viewportLayer = viewportLayer;
        this.scrollableLayer = viewportLayer.getScrollableLayer();
        this.scroller = scroller;
        this.scroller.addListener(13, this);
    }

    public void dispose() {
        if (this.scroller != null && !this.scroller.isDisposed()) {
            this.scroller.removeListener(13, this);
        }
    }

    public void handleEvent(Event event) {
        if (!this.dragging && this.table != null && !this.table.commitAndCloseActiveCellEditor()) {
            this.globalHandle = false;
        }
        boolean handle = this.globalHandle;
        if (event.detail == 1) {
            this.dragging = true;
        } else {
            this.dragging = false;
            this.globalHandle = true;
        }
        if (handle && event.widget == this.scroller.getUnderlying()) {
            this.setViewportOrigin(this.getViewportMinimumOrigin() + this.scroller.getSelection());
            this.setScrollIncrement();
            event.doit = false;
        } else {
            this.adjustScrollBar();
        }
    }

    void adjustScrollBar() {
        if (this.scroller.isDisposed()) {
            return;
        }
        int startPixel = this.getViewportOrigin() - this.getViewportMinimumOrigin();
        this.scroller.setSelection(startPixel);
    }

    void recalculateScrollBarSize() {
        int thumbSize;
        int viewportWindowSpan;
        if (this.scroller.isDisposed()) {
            return;
        }
        int max = this.getScrollableLayerSpan() - this.getViewportMinimumOrigin();
        if (!this.scroller.isDisposed()) {
            this.scroller.setMaximum(max);
        }
        if ((viewportWindowSpan = this.getViewportWindowSpan()) < max && viewportWindowSpan != 0) {
            thumbSize = viewportWindowSpan;
            this.scroller.setEnabled(true);
            this.scroller.setVisible(true);
            this.setScrollIncrement();
            this.scroller.setPageIncrement(viewportWindowSpan);
        } else {
            thumbSize = max;
            this.scroller.setEnabled(false);
            this.scroller.setVisible(false);
        }
        this.scroller.setThumb(thumbSize);
        this.adjustScrollBar();
    }

    void setScrollIncrement() {
        int scrollIncrement = Math.min(this.getScrollIncrement(), this.getViewportWindowSpan() / 4);
        this.scroller.setIncrement(scrollIncrement);
    }

    void setTable(NatTable table) {
        this.table = table;
    }

    abstract int getViewportWindowSpan();

    abstract int getScrollableLayerSpan();

    abstract boolean keepScrolling();

    abstract int getViewportOrigin();

    abstract int getViewportMinimumOrigin();

    abstract void setViewportOrigin(int var1);

    abstract SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int var1);

    abstract int getScrollIncrement();
}

