/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterNatCombo;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FilterRowComboBoxCellEditor
extends ComboBoxCellEditor {
    private static final Log log = LogFactory.getLog(FilterRowComboBoxCellEditor.class);
    private Object currentCanonicalValue = null;

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        super(dataProvider, maxVisibleItems);
        this.multiselect = true;
        this.useCheckbox = true;
    }

    @Override
    public NatCombo createEditorControl(Composite parent) {
        int style = 42;
        FilterNatCombo combo = this.iconImage == null ? new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.showDropdownFilter) : new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.iconImage, this.showDropdownFilter);
        combo.setCursor(new Cursor((Device)Display.getDefault(), 19));
        combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
        combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        this.addNatComboListener(combo);
        combo.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    FilterRowComboBoxCellEditor.this.setCanonicalValue("SELECT_ALL");
                }
                FilterRowComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, !FilterRowComboBoxCellEditor.this.multiselect && FilterRowComboBoxCellEditor.this.editMode == EditModeEnum.INLINE);
            }
        });
        return combo;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        this.currentCanonicalValue = canonicalValue;
        super.setCanonicalValue(canonicalValue);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        if (!this.isClosed()) {
            block7: {
                Object canonicalValue = this.getCanonicalValue();
                if (!(canonicalValue != null && this.currentCanonicalValue == null || canonicalValue == null && this.currentCanonicalValue != null) && (canonicalValue == null || this.currentCanonicalValue == null || canonicalValue.equals(this.currentCanonicalValue))) break block7;
                if (super.commit(direction, closeAfterCommit)) {
                    this.currentCanonicalValue = canonicalValue;
                    return true;
                }
            }
            try {
                if (closeAfterCommit) {
                    this.close();
                }
                return true;
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (Exception e) {
                log.error((Object)("Error on updating cell value: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }
}

