/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;

public class HierarchicalReflectiveColumnPropertyAccessor
extends ReflectiveColumnPropertyAccessor<HierarchicalWrapper> {
    private static final Log LOG = LogFactory.getLog(HierarchicalReflectiveColumnPropertyAccessor.class);

    public HierarchicalReflectiveColumnPropertyAccessor(String ... propertyNames) {
        super(propertyNames);
    }

    public HierarchicalReflectiveColumnPropertyAccessor(List<String> propertyNames) {
        super(propertyNames);
    }

    @Override
    public Object getDataValue(HierarchicalWrapper rowObj, int columnIndex) {
        String propertyName = this.getColumnProperty(columnIndex);
        String[] split = propertyName.split("\\.");
        Object levelObject = rowObj.getObject(split.length - 1);
        if (levelObject != null) {
            try {
                PropertyDescriptor propertyDesc = this.getPropertyDescriptor(levelObject, split[split.length - 1]);
                Method readMethod = propertyDesc.getReadMethod();
                return readMethod.invoke(levelObject, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn((Object)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void setDataValue(HierarchicalWrapper rowObj, int columnIndex, Object newValue) {
        String propertyName = this.getColumnProperty(columnIndex);
        String[] split = propertyName.split("\\.");
        Object levelObject = rowObj.getObject(split.length - 1);
        if (levelObject != null) {
            try {
                PropertyDescriptor propertyDesc = this.getPropertyDescriptor(levelObject, split[split.length - 1]);
                Method writeMethod = propertyDesc.getWriteMethod();
                if (writeMethod == null) {
                    throw new RuntimeException("Setter method not found in backing bean for value at column index: " + columnIndex);
                }
                writeMethod.invoke(levelObject, newValue);
            }
            catch (IllegalArgumentException ex) {
                LOG.error((Object)"Data type being set does not match the data type of the setter method in the backing bean", (Throwable)ex);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new RuntimeException("Error while setting data value");
            }
        }
    }
}

