/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemState;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemStateMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PopupMenuBuilder {
    public static final String HIDE_COLUMN_MENU_ITEM_ID = "hideColumnMenuItem";
    public static final String SHOW_ALL_COLUMNS_MENU_ITEM_ID = "showAllColumnsMenuItem";
    public static final String HIDE_ROW_MENU_ITEM_ID = "hideRowMenuItem";
    public static final String SHOW_ALL_ROWS_MENU_ITEM_ID = "showAllRowsMenuItem";
    public static final String AUTO_RESIZE_COLUMN_MENU_ITEM_ID = "autoResizeColumnMenuItem";
    public static final String AUTO_RESIZE_ROW_MENU_ITEM_ID = "autoResizeRowMenuItem";
    public static final String AUTO_RESIZE_ALL_SELECTED_COLUMN_MENU_ITEM_ID = "autoResizeAllSelectedColumnMenuItem";
    public static final String COLUMN_CHOOSER_MENU_ITEM_ID = "columnChooserMenuItem";
    public static final String COLUMN_STYLE_EDITOR_MENU_ITEM_ID = "columnStyleEditorMenuItem";
    public static final String COLUMN_RENAME_MENU_ITEM_ID = "columnRenameMenuItem";
    public static final String CREATE_COLUMN_GROUP_MENU_ITEM_ID = "createColumnGroupMenuItem";
    public static final String RENAME_COLUMN_GROUP_MENU_ITEM_ID = "renameColumnGroupMenuItem";
    public static final String REMOVE_COLUMN_GROUP_MENU_ITEM_ID = "removeColumnGroupMenuItem";
    public static final String UNGROUP_COLUMNS_MENU_ITEM_ID = "ungroupColumnsMenuItem";
    public static final String INSPECT_LABEL_MENU_ITEM_ID = "inspectLabelMenuItem";
    public static final String CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID = "categoriesBasedColumnChooserMenuItem";
    public static final String CLEAR_ALL_FILTERS_MENU_ITEM_ID = "clearAllFiltersMenuItem";
    public static final String TOGGLE_FILTER_ROW_MENU_ITEM_ID = "toggleFilterRowMenuItem";
    public static final String STATE_MANAGER_MENU_ITEM_ID = "stateManagerMenuItem";
    public static final String SEPARATOR_MENU_ITEM_ID = "separatorMenuItem";
    public static final String EXPORT_IMAGE_MENU_ITEM_ID = "exportImageMenuItem";
    public static final String CREATE_ROW_GROUP_MENU_ITEM_ID = "createRowGroupMenuItem";
    public static final String RENAME_ROW_GROUP_MENU_ITEM_ID = "renameRowGroupMenuItem";
    public static final String REMOVE_ROW_GROUP_MENU_ITEM_ID = "removeRowGroupMenuItem";
    public static final String UNGROUP_ROWS_MENU_ITEM_ID = "ungroupRowsMenuItem";
    public static final String FREEZE_COLUMN_MENU_ITEM_ID = "freezeColumnMenuItem";
    public static final String FREEZE_ROW_MENU_ITEM_ID = "freezeRowMenuItem";
    public static final String FREEZE_POSITION_MENU_ITEM_ID = "freezePositionMenuItem";
    public static final String UNFREEZE_MENU_ITEM_ID = "unfreezeMenuItem";
    protected NatTable natTable;
    protected Menu popupMenu;
    protected MenuManager menuManager;
    protected final MenuItemStateMap visibility = new MenuItemStateMap();
    protected final MenuItemStateMap enablement = new MenuItemStateMap();

    public PopupMenuBuilder(NatTable parent) {
        this(parent, new MenuManager());
    }

    public PopupMenuBuilder(MenuManager manager) {
        this(null, manager);
    }

    public PopupMenuBuilder(NatTable parent, MenuManager manager) {
        this.natTable = parent;
        this.menuManager = manager;
        if (this.natTable != null) {
            this.popupMenu = manager.createContextMenu((Control)this.natTable);
        }
    }

    public PopupMenuBuilder(NatTable natTable, Menu menu) {
        this.natTable = natTable;
        this.popupMenu = menu;
        Object mgr = menu.getData("org.eclipse.jface.action.MenuManager.managerKey");
        if (mgr != null && mgr instanceof MenuManager) {
            this.menuManager = (MenuManager)mgr;
        }
    }

    public PopupMenuBuilder withMenuItemProvider(IMenuItemProvider menuItemProvider) {
        if (this.menuManager == null) {
            menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        } else {
            this.menuManager.add((IContributionItem)new PopupContributionItem(menuItemProvider));
        }
        return this;
    }

    public PopupMenuBuilder withMenuItemProvider(String id, IMenuItemProvider menuItemProvider) {
        if (this.menuManager == null) {
            menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        } else {
            this.menuManager.add((IContributionItem)new PopupContributionItem(id, menuItemProvider));
        }
        return this;
    }

    public PopupMenuBuilder withContributionItem(ContributionItem contributionItem) {
        if (this.menuManager == null) {
            throw new IllegalStateException("This PopupMenuBuilder is not created using a MenuManager, therefore ContributionItems can not be added");
        }
        this.menuManager.add((IContributionItem)contributionItem);
        return this;
    }

    public PopupMenuBuilder withHideColumnMenuItem() {
        return this.withMenuItemProvider(HIDE_COLUMN_MENU_ITEM_ID, MenuItemProviders.hideColumnMenuItemProvider());
    }

    public PopupMenuBuilder withHideColumnMenuItem(String menuLabel) {
        return this.withMenuItemProvider(HIDE_COLUMN_MENU_ITEM_ID, MenuItemProviders.hideColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem() {
        return this.withMenuItemProvider(SHOW_ALL_COLUMNS_MENU_ITEM_ID, MenuItemProviders.showAllColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(SHOW_ALL_COLUMNS_MENU_ITEM_ID, MenuItemProviders.showAllColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withExportToImageMenuItem() {
        return this.withMenuItemProvider(EXPORT_IMAGE_MENU_ITEM_ID, MenuItemProviders.exportToImageMenuItemProvider());
    }

    public PopupMenuBuilder withExportToImageMenuItem(String menuLabel) {
        return this.withMenuItemProvider(EXPORT_IMAGE_MENU_ITEM_ID, MenuItemProviders.exportToImageMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withHideRowMenuItem() {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowMenuItemProvider());
    }

    public PopupMenuBuilder withHideRowMenuItem(String menuLabel) {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withHideRowPositionMenuItem() {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowPositionMenuItemProvider());
    }

    public PopupMenuBuilder withHideRowPositionMenuItem(String menuLabel) {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowPositionMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllRowsMenuItem() {
        return this.withMenuItemProvider(SHOW_ALL_ROWS_MENU_ITEM_ID, MenuItemProviders.showAllRowsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(SHOW_ALL_ROWS_MENU_ITEM_ID, MenuItemProviders.showAllRowsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem() {
        return this.withMenuItemProvider(AUTO_RESIZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.autoResizeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(AUTO_RESIZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.autoResizeColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem() {
        return this.withMenuItemProvider(AUTO_RESIZE_ROW_MENU_ITEM_ID, MenuItemProviders.autoResizeRowMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(AUTO_RESIZE_ROW_MENU_ITEM_ID, MenuItemProviders.autoResizeRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnChooserMenuItem() {
        return this.withMenuItemProvider(COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.columnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withColumnChooserMenuItem(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.columnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnStyleEditor() {
        return this.withMenuItemProvider(COLUMN_STYLE_EDITOR_MENU_ITEM_ID, MenuItemProviders.columnStyleEditorMenuItemProvider());
    }

    public PopupMenuBuilder withColumnStyleEditor(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_STYLE_EDITOR_MENU_ITEM_ID, MenuItemProviders.columnStyleEditorMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnRenameDialog() {
        return this.withMenuItemProvider(COLUMN_RENAME_MENU_ITEM_ID, MenuItemProviders.renameColumnMenuItemProvider());
    }

    public PopupMenuBuilder withColumnRenameDialog(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_RENAME_MENU_ITEM_ID, MenuItemProviders.renameColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem() {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateColumnGroupMenuItem() {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createPerformanceColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withCreateColumnGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createPerformanceColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem() {
        return this.withMenuItemProvider(UNGROUP_COLUMNS_MENU_ITEM_ID, MenuItemProviders.ungroupColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(UNGROUP_COLUMNS_MENU_ITEM_ID, MenuItemProviders.ungroupColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRenameColumnGroupMenuItem() {
        return this.withMenuItemProvider(RENAME_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.renameColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRenameColumnGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(RENAME_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.renameColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRemoveColumnGroupMenuItem() {
        return this.withMenuItemProvider(REMOVE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.removeColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRemoveColumnGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(REMOVE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.removeColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateRowGroupMenuItem() {
        return this.withMenuItemProvider(CREATE_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.createRowGroupMenuItemProvider());
    }

    public PopupMenuBuilder withCreateRowGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(CREATE_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.createRowGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withUngroupRowsMenuItem() {
        return this.withMenuItemProvider(UNGROUP_ROWS_MENU_ITEM_ID, MenuItemProviders.ungroupRowsMenuItemProvider());
    }

    public PopupMenuBuilder withUngroupRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(UNGROUP_ROWS_MENU_ITEM_ID, MenuItemProviders.ungroupRowsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRenameRowGroupMenuItem() {
        return this.withMenuItemProvider(RENAME_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.renameRowGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRenameRowGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(RENAME_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.renameRowGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRemoveRowGroupMenuItem() {
        return this.withMenuItemProvider(REMOVE_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.removeRowGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRemoveRowGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(REMOVE_ROW_GROUP_MENU_ITEM_ID, MenuItemProviders.removeRowGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withFreezeColumnMenuItem() {
        return this.withMenuItemProvider(FREEZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.freezeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withFreezeColumnMenuItem(String menuLabel) {
        return this.withMenuItemProvider(FREEZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.freezeColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withFreezeRowMenuItem() {
        return this.withMenuItemProvider(FREEZE_ROW_MENU_ITEM_ID, MenuItemProviders.freezeRowMenuItemProvider());
    }

    public PopupMenuBuilder withFreezeRowMenuItem(String menuLabel) {
        return this.withMenuItemProvider(FREEZE_ROW_MENU_ITEM_ID, MenuItemProviders.freezeRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withFreezePositionMenuItem(boolean include) {
        return this.withMenuItemProvider(FREEZE_POSITION_MENU_ITEM_ID, MenuItemProviders.freezePositionMenuItemProvider(include));
    }

    public PopupMenuBuilder withFreezePositionMenuItem(String menuLabel, boolean include) {
        return this.withMenuItemProvider(FREEZE_POSITION_MENU_ITEM_ID, MenuItemProviders.freezePositionMenuItemProvider(menuLabel, include));
    }

    public PopupMenuBuilder withUnfreezeMenuItem() {
        return this.withMenuItemProvider(UNFREEZE_MENU_ITEM_ID, MenuItemProviders.unfreezeMenuItemProvider());
    }

    public PopupMenuBuilder withUnfreezeMenuItem(String menuLabel) {
        return this.withMenuItemProvider(UNFREEZE_MENU_ITEM_ID, MenuItemProviders.unfreezeMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withInspectLabelsMenuItem() {
        return this.withMenuItemProvider(INSPECT_LABEL_MENU_ITEM_ID, MenuItemProviders.inspectLabelsMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser() {
        return this.withMenuItemProvider(CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser(String menuLabel) {
        return this.withMenuItemProvider(CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withClearAllFilters() {
        return this.withMenuItemProvider(CLEAR_ALL_FILTERS_MENU_ITEM_ID, MenuItemProviders.clearAllFiltersMenuItemProvider());
    }

    public PopupMenuBuilder withClearAllFilters(String menuLabel) {
        return this.withMenuItemProvider(CLEAR_ALL_FILTERS_MENU_ITEM_ID, MenuItemProviders.clearAllFiltersMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withToggleFilterRow() {
        return this.withMenuItemProvider(TOGGLE_FILTER_ROW_MENU_ITEM_ID, MenuItemProviders.clearToggleFilterRowMenuItemProvider());
    }

    public PopupMenuBuilder withToggleFilterRow(String menuLabel) {
        return this.withMenuItemProvider(TOGGLE_FILTER_ROW_MENU_ITEM_ID, MenuItemProviders.clearToggleFilterRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider() {
        return this.withMenuItemProvider(STATE_MANAGER_MENU_ITEM_ID, MenuItemProviders.stateManagerMenuItemProvider());
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider(String menuLabel) {
        return this.withMenuItemProvider(STATE_MANAGER_MENU_ITEM_ID, MenuItemProviders.stateManagerMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withSeparator() {
        int count = 0;
        if (this.menuManager != null) {
            IContributionItem[] iContributionItemArray = this.menuManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item.getId() != null && item.getId().startsWith(SEPARATOR_MENU_ITEM_ID)) {
                    ++count;
                }
                ++n2;
            }
        }
        return this.withSeparator("separatorMenuItem." + count);
    }

    public PopupMenuBuilder withSeparator(String id) {
        return this.withMenuItemProvider(id, MenuItemProviders.separatorMenuItemProvider());
    }

    public MenuManager build(NatTable natTable) {
        this.natTable = natTable;
        return this.menuManager;
    }

    public Menu build() {
        this.natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PopupMenuBuilder.this.popupMenu != null && !PopupMenuBuilder.this.popupMenu.isDisposed()) {
                    PopupMenuBuilder.this.popupMenu.dispose();
                }
            }
        });
        return this.popupMenu;
    }

    public PopupMenuBuilder withVisibleState(String id, IMenuItemState state) {
        this.visibility.addMenuItemState(id, state);
        return this;
    }

    public PopupMenuBuilder withEnabledState(String id, IMenuItemState state) {
        this.enablement.addMenuItemState(id, state);
        return this;
    }

    protected class PopupContributionItem
    extends ContributionItem {
        private IMenuItemProvider provider;

        public PopupContributionItem(IMenuItemProvider provider) {
            this(null, provider);
        }

        public PopupContributionItem(String id, IMenuItemProvider provider) {
            super(id);
            this.provider = provider;
        }

        public void fill(Menu menu, int index) {
            MenuItem[] afterItems;
            List<MenuItem> beforeItems = Arrays.asList(menu.getItems());
            this.provider.addMenuItem(PopupMenuBuilder.this.natTable, menu);
            MenuItem[] menuItemArray = afterItems = menu.getItems();
            int n = afterItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (!beforeItems.contains(item)) {
                    item.setEnabled(this.isEnabled());
                }
                ++n2;
            }
        }

        public boolean isDynamic() {
            return this.getId() != null;
        }

        public boolean isEnabled() {
            if (this.getId() != null) {
                Object eventData;
                Object object = eventData = PopupMenuBuilder.this.popupMenu != null && !PopupMenuBuilder.this.popupMenu.isDisposed() ? PopupMenuBuilder.this.popupMenu.getData("natEventData") : PopupMenuBuilder.this.menuManager.getMenu().getData("natEventData");
                if (eventData != null && eventData instanceof NatEventData) {
                    return PopupMenuBuilder.this.enablement.isActive(this.getId(), (NatEventData)eventData);
                }
            }
            return true;
        }

        public boolean isVisible() {
            if (this.getId() != null) {
                Object eventData;
                Object object = eventData = PopupMenuBuilder.this.popupMenu != null && !PopupMenuBuilder.this.popupMenu.isDisposed() ? PopupMenuBuilder.this.popupMenu.getData("natEventData") : PopupMenuBuilder.this.menuManager.getMenu().getData("natEventData");
                if (eventData != null && eventData instanceof NatEventData) {
                    return PopupMenuBuilder.this.visibility.isActive(this.getId(), (NatEventData)eventData);
                }
            }
            return true;
        }
    }
}

