/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.MoveSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;

public class MoveCellSelectionCommandHandler
extends MoveSelectionCommandHandler<MoveSelectionCommand> {
    protected PositionCoordinate lastSelectedCellPosition;
    protected int newSelectedColumnPosition;
    protected int newSelectedRowPosition;

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy traversalStrategy) {
        super(selectionLayer, traversalStrategy);
    }

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy horizontalTraversalStrategy, ITraversalStrategy verticalTraversalStrategy) {
        super(selectionLayer, horizontalTraversalStrategy, verticalTraversalStrategy);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedLeft(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block18: {
            block19: {
                block20: {
                    if (!this.selectionLayer.hasColumnSelection()) break block18;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block18;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() - stepSize : 0;
                    this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    newSelected = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition);
                    if (newSelected != null) {
                        this.newSelectedColumnPosition = newSelected.getOriginColumnPosition();
                    }
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedColumnPosition >= 0) break block19;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block20;
                    if (traversalStrategy.isCycle()) ** GOTO lbl19
                    this.newSelectedColumnPosition = 0;
                    stopTraversalOnInvalid = true;
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
lbl19:
                        // 2 sources

                        ** while (this.newSelectedColumnPosition < 0)
                    }
lbl20:
                    // 1 sources

                    break block19;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    rowMove = 0;
                    while (this.newSelectedColumnPosition < 0) {
                        this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
                        ++rowMove;
                    }
                    this.newSelectedRowPosition -= rowMove;
                    if (this.newSelectedRowPosition < 0) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedRowPosition += this.selectionLayer.getRowCount();
                        } else {
                            this.newSelectedColumnPosition = 0;
                            this.newSelectedRowPosition = 0;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (stepSize == -1) {
                        i = this.newSelectedColumnPosition;
                        while (i < this.selectionLayer.getColumnCount()) {
                            newPosition = this.selectionLayer.getCellByPosition(i, this.newSelectedRowPosition);
                            if (traversalStrategy.isValidTarget(lastSelectedCell, newPosition)) {
                                this.newSelectedColumnPosition = i;
                                if (!withShiftMask) {
                                    this.selectionLayer.clear(false);
                                }
                                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                                this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                                break;
                            }
                            ++i;
                        }
                    } else if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedLeft(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    if (stepSize == -1 && !withShiftMask) {
                        this.selectionLayer.clear(false);
                    }
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedRight(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block18: {
            block19: {
                block20: {
                    if (!this.selectionLayer.hasColumnSelection()) break block18;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block18;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() + lastSelectedCell.getColumnSpan() - 1 + stepSize : this.selectionLayer.getColumnCount() - 1;
                    this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    newSelected = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition);
                    if (newSelected != null) {
                        this.newSelectedColumnPosition = newSelected.getOriginColumnPosition() + newSelected.getColumnSpan() - 1;
                    }
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedColumnPosition < this.selectionLayer.getColumnCount()) break block19;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block20;
                    if (traversalStrategy.isCycle()) ** GOTO lbl19
                    this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                    stopTraversalOnInvalid = true;
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
lbl19:
                        // 2 sources

                        ** while (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount())
                    }
lbl20:
                    // 1 sources

                    break block19;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    rowMove = 0;
                    while (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                        this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
                        ++rowMove;
                    }
                    this.newSelectedRowPosition += rowMove;
                    if (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
                        } else {
                            this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                            this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (stepSize == -1) {
                        i = this.newSelectedColumnPosition;
                        while (i >= 0) {
                            newPosition = this.selectionLayer.getCellByPosition(i, this.newSelectedRowPosition);
                            if (traversalStrategy.isValidTarget(lastSelectedCell, newPosition)) {
                                this.newSelectedColumnPosition = i;
                                if (!withShiftMask) {
                                    this.selectionLayer.clear(false);
                                }
                                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                                this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                                break;
                            }
                            --i;
                        }
                    } else if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedRight(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    if (stepSize == -1 && !withShiftMask) {
                        this.selectionLayer.clear(false);
                    }
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedUp(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block18: {
            block19: {
                block20: {
                    if (!this.selectionLayer.hasRowSelection()) break block18;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block18;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                    this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() - stepSize : 0;
                    newSelected = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition);
                    if (newSelected != null) {
                        this.newSelectedRowPosition = newSelected.getOriginRowPosition();
                    }
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedRowPosition >= 0) break block19;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block20;
                    if (traversalStrategy.isCycle()) ** GOTO lbl19
                    this.newSelectedRowPosition = 0;
                    stopTraversalOnInvalid = true;
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedRowPosition += this.selectionLayer.getRowCount();
lbl19:
                        // 2 sources

                        ** while (this.newSelectedRowPosition < 0)
                    }
lbl20:
                    // 1 sources

                    break block19;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    columnMove = 0;
                    while (this.newSelectedRowPosition < 0) {
                        this.newSelectedRowPosition += this.selectionLayer.getRowCount();
                        ++columnMove;
                    }
                    this.newSelectedColumnPosition -= columnMove;
                    if (this.newSelectedColumnPosition < 0) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
                        } else {
                            this.newSelectedColumnPosition = 0;
                            this.newSelectedRowPosition = 0;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (stepSize == -1) {
                        i = this.newSelectedRowPosition;
                        while (i < this.selectionLayer.getRowCount()) {
                            newPosition = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, i);
                            if (traversalStrategy.isValidTarget(lastSelectedCell, newPosition)) {
                                this.newSelectedRowPosition = i;
                                if (!withShiftMask) {
                                    this.selectionLayer.clear(false);
                                }
                                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                                this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                                break;
                            }
                            ++i;
                        }
                    } else if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedUp(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    if (stepSize == -1 && !withShiftMask) {
                        this.selectionLayer.clear(false);
                    }
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedDown(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block18: {
            block19: {
                block20: {
                    if (!this.selectionLayer.hasRowSelection()) break block18;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block18;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                    this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() + lastSelectedCell.getRowSpan() - 1 + stepSize : this.selectionLayer.getRowCount() - 1;
                    newSelected = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition);
                    if (newSelected != null) {
                        this.newSelectedRowPosition = newSelected.getOriginRowPosition() + newSelected.getRowSpan() - 1;
                    }
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedRowPosition < this.selectionLayer.getRowCount()) break block19;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block20;
                    if (traversalStrategy.isCycle()) ** GOTO lbl19
                    this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                    stopTraversalOnInvalid = true;
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
lbl19:
                        // 2 sources

                        ** while (this.newSelectedRowPosition >= this.selectionLayer.getRowCount())
                    }
lbl20:
                    // 1 sources

                    break block19;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    columnMove = 0;
                    while (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                        this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
                        ++columnMove;
                    }
                    this.newSelectedColumnPosition += columnMove;
                    if (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
                        } else {
                            this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                            this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                targetColumnPosition = newSelected != null ? newSelected.getColumnPosition() : this.newSelectedColumnPosition;
                v0 = targetRowPosition = newSelected != null ? newSelected.getRowPosition() : this.newSelectedRowPosition;
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(targetColumnPosition, targetRowPosition))) {
                    if (stepSize == -1) {
                        i = this.newSelectedRowPosition;
                        while (i >= 0) {
                            newPosition = this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, i);
                            if (traversalStrategy.isValidTarget(lastSelectedCell, newPosition)) {
                                this.newSelectedRowPosition = i;
                                if (!withShiftMask) {
                                    this.selectionLayer.clear(false);
                                }
                                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                                this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                                break;
                            }
                            --i;
                        }
                    } else if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedDown(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    if (stepSize == -1 && !withShiftMask) {
                        this.selectionLayer.clear(false);
                    }
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.newSelectedColumnPosition, this.newSelectedRowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    protected ITraversalStrategy createIncrementalStrategy(final ITraversalStrategy baseStrategy) {
        return new ITraversalStrategy(){

            @Override
            public ITraversalStrategy.TraversalScope getTraversalScope() {
                return baseStrategy.getTraversalScope();
            }

            @Override
            public boolean isCycle() {
                return baseStrategy.isCycle();
            }

            @Override
            public int getStepCount() {
                return baseStrategy.getStepCount() + 1;
            }

            @Override
            public boolean isValidTarget(ILayerCell from, ILayerCell to) {
                return baseStrategy.isValidTarget(from, to);
            }
        };
    }

    protected boolean positionMoved() {
        return this.newSelectedColumnPosition != this.lastSelectedCellPosition.columnPosition || this.newSelectedRowPosition != this.lastSelectedCellPosition.rowPosition;
    }

    @Override
    public Class<MoveSelectionCommand> getCommandClass() {
        return MoveSelectionCommand.class;
    }
}

