/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.coordinate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class PositionUtil {
    private PositionUtil() {
    }

    public static List<List<Integer>> getGroupedByContiguous(Collection<Integer> numberCollection) {
        ArrayList<Integer> numbers = new ArrayList<Integer>(numberCollection);
        Collections.sort(numbers);
        ArrayList<Integer> contiguous = new ArrayList<Integer>();
        ArrayList<List<Integer>> grouped = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < numbers.size() - 1) {
            if ((Integer)numbers.get(i) + 1 != (Integer)numbers.get(i + 1)) {
                contiguous.add((Integer)numbers.get(i));
                grouped.add(contiguous);
                contiguous = new ArrayList();
            } else {
                contiguous.add((Integer)numbers.get(i));
            }
            ++i;
        }
        if (ObjectUtils.isNotEmpty(numbers)) {
            contiguous.add((Integer)numbers.get(numbers.size() - 1));
        }
        grouped.add(contiguous);
        return grouped;
    }

    public static int[][] getGroupedByContiguous(int ... numbers) {
        ArrayList ranges = Arrays.stream(numbers).sorted().collect(ArrayList::new, new RangeAccumulator(), (g1, g2) -> {
            boolean bl = g1.addAll(g2);
        });
        return (int[][])ranges.stream().map(Range::getMembersArray).toArray(size -> new int[size][]);
    }

    public static List<Range> getRanges(Collection<Integer> numbers) {
        return ObjectUtils.isNotEmpty(numbers) ? (List)numbers.stream().mapToInt(Integer::intValue).sorted().collect(ArrayList::new, new RangeAccumulator(), (g1, g2) -> {
            boolean bl = g1.addAll(g2);
        }) : new ArrayList<Range>();
    }

    public static List<Range> getRanges(int ... numbers) {
        return numbers != null && numbers.length > 0 ? (List)Arrays.stream(numbers).sorted().collect(ArrayList::new, new RangeAccumulator(), (g1, g2) -> {
            boolean bl = g1.addAll(g2);
        }) : new ArrayList<Range>();
    }

    public static int[] getPositions(Collection<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return new int[0];
        }
        return ranges.stream().flatMapToInt(r -> IntStream.range(r.start, r.end)).filter(in -> in >= 0).sorted().toArray();
    }

    public static int[] getPositions(Range ... ranges) {
        return PositionUtil.getPositions(Arrays.asList(ranges));
    }

    public static Range joinConsecutiveRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        ArrayList<Range> sortedRanges = new ArrayList<Range>(ranges);
        Collections.sort(sortedRanges, (o1, o2) -> {
            if (o1.start == o2.start) {
                return Integer.compare(o1.end, o2.end);
            }
            return Integer.compare(o1.start, o2.start);
        });
        int start = sortedRanges.get((int)0).start;
        int end = sortedRanges.get((int)0).end;
        int i = 1;
        while (i < sortedRanges.size()) {
            Range range = sortedRanges.get(i);
            if (range.start > end) {
                return null;
            }
            end = Math.max(end, range.end);
            ++i;
        }
        return new Range(start, end);
    }

    public static List<Range> mergeRanges(Collection<Range> ranges) {
        TreeSet<Integer> numbers = new TreeSet<Integer>();
        for (Range range : ranges) {
            int number = range.start;
            while (number < range.end) {
                numbers.add(number);
                ++number;
            }
        }
        return PositionUtil.getRanges(numbers);
    }

    public static SelectionLayer.MoveDirectionEnum getHorizontalMoveDirection(int fromPosition, int toPosition) {
        if (fromPosition > toPosition) {
            return SelectionLayer.MoveDirectionEnum.LEFT;
        }
        if (fromPosition < toPosition) {
            return SelectionLayer.MoveDirectionEnum.RIGHT;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }

    public static SelectionLayer.MoveDirectionEnum getVerticalMoveDirection(int fromRowPosition, int toRowPosition) {
        if (fromRowPosition > toRowPosition) {
            return SelectionLayer.MoveDirectionEnum.UP;
        }
        if (fromRowPosition < toRowPosition) {
            return SelectionLayer.MoveDirectionEnum.DOWN;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }

    private static class RangeAccumulator
    implements ObjIntConsumer<ArrayList<Range>> {
        private RangeAccumulator() {
        }

        @Override
        public void accept(ArrayList<Range> ranges, int i) {
            Range lastGroup;
            if (!ranges.isEmpty()) {
                lastGroup = ranges.get(ranges.size() - 1);
            } else {
                lastGroup = new Range(i, i + 1);
                ranges.add(lastGroup);
            }
            int last = lastGroup.end;
            if (i > last) {
                lastGroup = new Range(i, i + 1);
                ranges.add(lastGroup);
            } else {
                lastGroup.end = i + 1;
            }
        }
    }
}

