/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.e4.css;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.engine.AbstractCSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.extension.e4.css.NatTableWrapper;
import org.eclipse.nebula.widgets.nattable.extension.e4.css.NatTableWrapperElementAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NatTableElementAdapter
extends WidgetElement {
    private static final Logger LOG = LoggerFactory.getLogger(NatTableElementAdapter.class);
    private static AtomicBoolean listenerApplied = new AtomicBoolean(false);
    ArrayList<Node> virtualChildren = new ArrayList();

    public NatTableElementAdapter(NatTable natTable, CSSEngine engine) {
        super((Widget)natTable, engine);
        this.addStaticPseudoInstance("normal");
        this.addStaticPseudoInstance("select");
        this.addStaticPseudoInstance("edit");
        this.addStaticPseudoInstance("hover");
        this.addStaticPseudoInstance("select-hover");
        for (String label : natTable.getProvidedLabels()) {
            this.addVirtualChild(label);
        }
        natTable.addDisposeListener(e -> this.dispose());
        if (listenerApplied.compareAndSet(false, true)) {
            new NatTableSkinListener(natTable.getDisplay(), engine);
        }
    }

    public Node getParentNode() {
        NatTable control = this.getControl();
        Composite parent = control.getParent();
        if (parent != null) {
            return this.getElement(parent);
        }
        return null;
    }

    protected NatTable getControl() {
        return (NatTable)this.getNativeWidget();
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getLength() {
        return this.virtualChildren.size();
    }

    public Node item(int index) {
        return this.virtualChildren.get(index);
    }

    public void addVirtualChild(String label) {
        this.virtualChildren.add((Node)((Object)new NatTableWrapperElementAdapter(new NatTableWrapper(this.getControl(), label), this.engine, this)));
    }

    public void dispose() {
        super.dispose();
        for (Node node : this.virtualChildren) {
            if (!(node instanceof NatTableWrapperElementAdapter)) continue;
            ((NatTableWrapperElementAdapter)((Object)node)).dispose();
            if (!(this.engine instanceof AbstractCSSEngine)) continue;
            try {
                Method method = AbstractCSSEngine.class.getDeclaredMethod("handleWidgetDisposed", Object.class);
                if (method == null) continue;
                method.setAccessible(true);
                method.invoke((Object)this.engine, ((NatTableWrapperElementAdapter)((Object)node)).natTableWrapper);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error("Error on disposal", (Throwable)e);
            }
        }
    }

    private static class NatTableSkinListener {
        CSSEngine engine;

        public NatTableSkinListener(Display display, CSSEngine cssEngine) {
            this.engine = cssEngine;
            display.addListener(45, event -> {
                if (this.engine != null && event.widget instanceof NatTable) {
                    this.engine.applyStyles((Object)event.widget, true);
                }
            });
        }
    }
}

