/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.factory.bag;

import java.util.stream.Stream;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;

public interface MutableBagFactory {
    public <T> MutableBag<T> empty();

    default public <T> MutableBag<T> of() {
        return this.empty();
    }

    default public <T> MutableBag<T> with() {
        return this.empty();
    }

    default public <T> MutableBag<T> of(T ... elements) {
        return this.with(elements);
    }

    default public <T> MutableBag<T> ofOccurrences(T element, int occurrence) {
        return this.withOccurrences(element, occurrence);
    }

    default public <T> MutableBag<T> ofOccurrences(T element1, int occurrence1, T element2, int occurrence2) {
        return this.withOccurrences(element1, occurrence1, element2, occurrence2);
    }

    default public <T> MutableBag<T> ofOccurrences(T element1, int occurrence1, T element2, int occurrence2, T element3, int occurrence3) {
        return this.withOccurrences(element1, occurrence1, element2, occurrence2, element3, occurrence3);
    }

    default public <T> MutableBag<T> ofOccurrences(T element1, int occurrence1, T element2, int occurrence2, T element3, int occurrence3, T element4, int occurrence4) {
        return this.withOccurrences(element1, occurrence1, element2, occurrence2, element3, occurrence3, element4, occurrence4);
    }

    default public <T> MutableBag<T> ofOccurrences(ObjectIntPair<T> ... elementsWithOccurrences) {
        return this.withOccurrences(elementsWithOccurrences);
    }

    public <T> MutableBag<T> with(T ... var1);

    default public <T> MutableBag<T> withOccurrences(T element, int occurrence) {
        MutableBag<T> bag = this.empty();
        bag.addOccurrences(element, occurrence);
        return bag;
    }

    default public <T> MutableBag<T> withOccurrences(T element1, int occurrence1, T element2, int occurrence2) {
        MutableBag<T> bag = this.empty();
        bag.addOccurrences(element1, occurrence1);
        bag.addOccurrences(element2, occurrence2);
        return bag;
    }

    default public <T> MutableBag<T> withOccurrences(T element1, int occurrence1, T element2, int occurrence2, T element3, int occurrence3) {
        MutableBag<T> bag = this.empty();
        bag.addOccurrences(element1, occurrence1);
        bag.addOccurrences(element2, occurrence2);
        bag.addOccurrences(element3, occurrence3);
        return bag;
    }

    default public <T> MutableBag<T> withOccurrences(T element1, int occurrence1, T element2, int occurrence2, T element3, int occurrence3, T element4, int occurrence4) {
        MutableBag<T> bag = this.empty();
        bag.addOccurrences(element1, occurrence1);
        bag.addOccurrences(element2, occurrence2);
        bag.addOccurrences(element3, occurrence3);
        bag.addOccurrences(element4, occurrence4);
        return bag;
    }

    default public <T> MutableBag<T> withOccurrences(ObjectIntPair<T> ... elementsWithOccurrences) {
        MutableBag<T> bag = this.empty();
        for (ObjectIntPair<T> itemToAdd : elementsWithOccurrences) {
            bag.addOccurrences(itemToAdd.getOne(), itemToAdd.getTwo());
        }
        return bag;
    }

    default public <T> MutableBag<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> MutableBag<T> withAll(Iterable<? extends T> var1);

    public <T> MutableBag<T> fromStream(Stream<? extends T> var1);
}

