/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.HideRowByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class RowHideShowLayer
extends AbstractRowHideShowLayer
implements IRowHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_INDEXES = ".hiddenRowIndexes";
    private MutableIntSet hiddenRowIndexes = IntSets.mutable.empty();

    public RowHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiRowHideCommandHandler(this));
        this.registerCommandHandler(new RowHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllRowsCommandHandler(this));
        this.registerCommandHandler(new MultiRowShowCommandHandler(this));
        this.registerCommandHandler(new RowPositionHideCommandHandler(this));
        this.registerCommandHandler(new RowShowCommandHandler(this));
        this.registerCommandHandler(new HideRowByIndexCommandHandler(this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Collection<StructuralDiff> rowDiffs;
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged() && (rowDiffs = structuralChangeEvent.getRowDiffs()) != null && !rowDiffs.isEmpty() && !StructuralChangeEventHelper.isReorder(rowDiffs)) {
            StructuralChangeEventHelper.handleRowDelete(rowDiffs, this.underlyingLayer, (MutableIntCollection)this.hiddenRowIndexes, false);
            StructuralChangeEventHelper.handleRowInsert(rowDiffs, this.underlyingLayer, (MutableIntCollection)this.hiddenRowIndexes, false);
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenRowIndexes.size() > 0) {
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_INDEXES, this.hiddenRowIndexes.toSortedList().makeString(","));
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenRowIndexes = IntSets.mutable.empty();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenRowIndexes.add(Integer.parseInt(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int downRowIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        int upRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
        if (this.isRowIndexHidden(upRowIndex)) {
            configLabels.addLabel("ROW_TOP_HIDDEN");
        }
        if (this.isRowIndexHidden(downRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("ROW_BOTTOM_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return ArrayUtil.asIntegerList(this.hiddenRowIndexes.toSortedArray());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        return this.hiddenRowIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenRows() {
        return !this.hiddenRowIndexes.isEmpty();
    }

    @Override
    public void hideRowPositions(int ... rowPositions) {
        int[] rowIndexes = Arrays.stream(rowPositions).map(this::getRowIndexByPosition).sorted().toArray();
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, rowIndexes));
    }

    @Override
    public void hideRowPositions(Collection<Integer> rowPositions) {
        this.hideRowPositions(rowPositions.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void hideRowIndexes(int ... rowIndexes) {
        int[] filteredIndexes = Arrays.stream(rowIndexes).filter(index -> !this.hiddenRowIndexes.contains(index)).toArray();
        if (filteredIndexes.length > 0) {
            int[] rowPositions = Arrays.stream(filteredIndexes).map(this::getRowPositionByIndex).sorted().toArray();
            this.hiddenRowIndexes.addAll(filteredIndexes);
            this.invalidateCache();
            this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, filteredIndexes));
        }
    }

    @Override
    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        this.hideRowIndexes(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showRowIndexes(int ... rowIndexes) {
        MutableIntList toProcess = IntLists.mutable.of(rowIndexes);
        toProcess.retainAll((IntIterable)this.hiddenRowIndexes);
        this.hiddenRowIndexes.removeAll((IntIterable)toProcess);
        this.invalidateCache();
        int[] positions = this.getRowPositionsByIndexes(toProcess.toArray());
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, positions));
    }

    @Override
    public void showRowIndexes(Collection<Integer> rowIndexes) {
        this.showRowIndexes(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showRowPosition(int rowPosition, boolean showToTop, boolean showAll) {
        MutableIntSet rowIndexes = IntSets.mutable.empty();
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        if (showToTop) {
            int topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(topRowIndex)) {
                    rowIndexes.add(topRowIndex);
                    topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isRowIndexHidden(topRowIndex)) {
                rowIndexes.add(topRowIndex);
            }
        } else {
            int bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(bottomRowIndex)) {
                    rowIndexes.add(bottomRowIndex);
                    bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isRowIndexHidden(bottomRowIndex)) {
                rowIndexes.add(bottomRowIndex);
            }
        }
        if (!rowIndexes.isEmpty()) {
            this.showRowIndexes(rowIndexes.toArray());
        }
    }

    @Override
    public void showAllRows() {
        int[] hidden = this.hiddenRowIndexes.toSortedArray();
        this.hiddenRowIndexes = IntSets.mutable.empty();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, this.getRowPositionsByIndexes(hidden)));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("ROW_TOP_HIDDEN");
        result.add("ROW_BOTTOM_HIDDEN");
        return result;
    }
}

