/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;

public class CellVisualUpdateEvent
extends CellVisualChangeEvent {
    public CellVisualUpdateEvent(ILayer layer, int columnPosition, int rowPosition) {
        super(layer, columnPosition, rowPosition);
    }

    protected CellVisualUpdateEvent(CellVisualChangeEvent event) {
        super(event);
    }

    @Override
    public CellVisualUpdateEvent cloneEvent() {
        return new CellVisualUpdateEvent(this);
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        ILayerCell cell;
        int columnPos = this.columnPosition;
        int rowPos = this.rowPosition;
        if (!(localLayer instanceof DimensionallyDependentLayer)) {
            columnPos = localLayer.underlyingToLocalColumnPosition(this.getLayer(), this.columnPosition);
            rowPos = localLayer.underlyingToLocalRowPosition(this.getLayer(), this.rowPosition);
        } else {
            DimensionallyDependentLayer ddl = (DimensionallyDependentLayer)localLayer;
            if (ddl.getHorizontalLayerDependency() instanceof IUniqueIndexLayer) {
                int columnIndex = this.layer.getColumnIndexByPosition(this.columnPosition);
                columnPos = ((IUniqueIndexLayer)ddl.getHorizontalLayerDependency()).getColumnPositionByIndex(columnIndex);
            }
            if (ddl.getVerticalLayerDependency() instanceof IUniqueIndexLayer) {
                int rowIndex = this.layer.getRowIndexByPosition(this.rowPosition);
                rowPos = ((IUniqueIndexLayer)ddl.getVerticalLayerDependency()).getRowPositionByIndex(rowIndex);
            }
        }
        if ((columnPos < 0 || rowPos < 0) && (cell = this.getLayer().getCellByPosition(this.columnPosition, this.rowPosition)) != null && cell.isSpannedCell()) {
            int column = cell.getOriginColumnPosition();
            while (column < cell.getOriginColumnPosition() + cell.getColumnSpan()) {
                columnPos = localLayer.underlyingToLocalColumnPosition(this.getLayer(), column);
                if (columnPos >= 0) break;
                ++column;
            }
            int row = cell.getOriginRowPosition();
            while (row < cell.getOriginRowPosition() + cell.getRowSpan()) {
                rowPos = localLayer.underlyingToLocalRowPosition(this.getLayer(), row);
                if (rowPos >= 0) break;
                ++row;
            }
        }
        this.columnPosition = columnPos;
        this.rowPosition = rowPos;
        this.layer = localLayer;
        return this.columnPosition >= 0 && this.rowPosition >= 0 && this.columnPosition < this.layer.getColumnCount() && this.rowPosition < this.layer.getRowCount();
    }
}

