/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarHandlerTemplate;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.ScrollBar;

public class HorizontalScrollBarHandler
extends ScrollBarHandlerTemplate {
    public HorizontalScrollBarHandler(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        this(viewportLayer, new ScrollBarScroller(scrollBar));
    }

    public HorizontalScrollBarHandler(ViewportLayer viewportLayer, IScroller<?> scroller) {
        super(viewportLayer, scroller);
    }

    @Override
    int getViewportOrigin() {
        return this.viewportLayer.getOrigin().getX();
    }

    @Override
    int getViewportMinimumOrigin() {
        return this.viewportLayer.getMinimumOrigin().getX();
    }

    @Override
    void setViewportOrigin(int x) {
        this.viewportLayer.setOriginX(x);
    }

    @Override
    SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? SelectionLayer.MoveDirectionEnum.LEFT : SelectionLayer.MoveDirectionEnum.RIGHT;
    }

    @Override
    boolean keepScrolling() {
        return !this.viewportLayer.isLastColumnCompletelyDisplayed();
    }

    @Override
    int getViewportWindowSpan() {
        return this.viewportLayer.getClientAreaWidth();
    }

    @Override
    int getScrollableLayerSpan() {
        if (this.viewportLayer.getMaxWidth() >= 0 && this.viewportLayer.getMaxWidth() < this.scrollableLayer.getWidth()) {
            return this.viewportLayer.getMaxWidth();
        }
        return this.scrollableLayer.getWidth();
    }

    @Override
    int getScrollIncrement() {
        return this.viewportLayer.getColumnCount() > 0 ? this.viewportLayer.getColumnWidthByPosition(0) : 0;
    }
}

