/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractColumnCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class ColumnGroupExpandCollapseCommand
extends AbstractColumnCommand {
    private final RowPositionCoordinate rowPositionCoordinate;

    public ColumnGroupExpandCollapseCommand(ILayer layer, int columnPosition) {
        this(layer, columnPosition, 0);
    }

    public ColumnGroupExpandCollapseCommand(ILayer layer, int columnPosition, int rowPosition) {
        super(layer, columnPosition);
        this.rowPositionCoordinate = new RowPositionCoordinate(layer, rowPosition);
    }

    protected ColumnGroupExpandCollapseCommand(ColumnGroupExpandCollapseCommand command) {
        super(command);
        this.rowPositionCoordinate = command.rowPositionCoordinate;
    }

    @Override
    public ColumnGroupExpandCollapseCommand cloneCommand() {
        return new ColumnGroupExpandCollapseCommand(this);
    }

    public ILayer getRowPositionLayer() {
        return this.rowPositionCoordinate.getLayer();
    }

    public int getRowPosition() {
        return this.rowPositionCoordinate.getRowPosition();
    }

    public int getLocalRowPosition(ILayer targetLayer) {
        RowPositionCoordinate positionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.rowPositionCoordinate, targetLayer);
        if (positionCoordinate != null) {
            return positionCoordinate.getRowPosition();
        }
        return this.rowPositionCoordinate.getRowPosition();
    }
}

