/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTreeLayer;
import org.eclipse.nebula.widgets.nattable.hierarchical.command.HierarchicalTreeExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;

public class HierarchicalTreeExpandCollapseCommandHandler
extends AbstractLayerCommandHandler<TreeExpandCollapseCommand> {
    private final HierarchicalTreeLayer treeLayer;

    public HierarchicalTreeExpandCollapseCommandHandler(HierarchicalTreeLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public Class<TreeExpandCollapseCommand> getCommandClass() {
        return TreeExpandCollapseCommand.class;
    }

    @Override
    protected boolean doCommand(TreeExpandCollapseCommand command) {
        int rowIndex = command.getParentIndex();
        int columnIndex = command.getColumnIndex();
        if (rowIndex < 0) {
            int rowPos = this.treeLayer.getRowPositionByIndex(rowIndex * -1);
            int colPos = this.treeLayer.getColumnPositionByIndex(columnIndex);
            ILayerCell cell = this.treeLayer.getCellByPosition(colPos, rowPos);
            rowIndex = this.treeLayer.getRowIndexByPosition(cell.getOriginRowPosition());
        }
        if (command instanceof HierarchicalTreeExpandCollapseCommand) {
            this.treeLayer.expandOrCollapse(columnIndex, rowIndex, ((HierarchicalTreeExpandCollapseCommand)command).getToLevel());
        } else {
            this.treeLayer.expandOrCollapse(columnIndex, rowIndex);
        }
        return true;
    }
}

