/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;

public class OTSpecialAccessAttribute
extends AbstractAttribute {
    private static final int DECAPSULATION_METHOD_ACCESS = 1;
    private static final int CALLOUT_FIELD_ACCESS = 2;
    private static final int SUPER_METHOD_ACCESS = 3;
    private static final int DYN_DECAPSULATION_METHOD_ACCESS = 4;
    private static final int DYN_CALLOUT_FIELD_ACCESS = 5;
    private static final int DYN_SUPER_METHOD_ACCESS = 6;
    private static final int M_SIZE = CallinImplementorDyn.DYNAMIC_WEAVING ? 8 : 6;
    private static final int F_SIZE = CallinImplementorDyn.DYNAMIC_WEAVING ? 8 : 7;
    int nextAccessId = 0;
    private List<DecapsulatedMethodDesc> _decapsulatedMethods = new ArrayList<DecapsulatedMethodDesc>();
    private List<CalloutToFieldDesc> _calloutToFields = new ArrayList<CalloutToFieldDesc>();
    private List<SuperMethodDesc> _superMethods = new ArrayList<SuperMethodDesc>();
    private ReferenceBinding _site;
    private List<ReferenceBinding> _adaptedBaseclasses = new ArrayList<ReferenceBinding>();
    private List<char[]> _baseclassNames = null;
    private List<Boolean> _baseclassDecapsulation = new ArrayList<Boolean>();

    public OTSpecialAccessAttribute(ReferenceBinding site) {
        super(IOTConstants.OTSPECIAL_ACCESS);
        this._site = site;
    }

    public int addDecapsulatedMethodAccess(ReferenceBinding boundBaseclass, MethodBinding method) {
        int accessId = this.nextAccessId;
        this._decapsulatedMethods.add(new DecapsulatedMethodDesc(boundBaseclass, method));
        return accessId;
    }

    public void addCalloutFieldAccess(FieldBinding field, ReferenceBinding targetClass, int calloutModifier) {
        this._calloutToFields.add(new CalloutToFieldDesc(field, targetClass, calloutModifier));
    }

    public void addSuperMethodAccess(MethodBinding method) {
        this._superMethods.add(new SuperMethodDesc(method));
    }

    public void addBaseClassDecapsulation(ReferenceBinding baseclass) {
        int i = 0;
        while (i < this._adaptedBaseclasses.size()) {
            if (this._adaptedBaseclasses.get(i).equals(baseclass)) {
                if (!this._baseclassDecapsulation.get(i).booleanValue()) {
                    this._baseclassDecapsulation.set(i, Boolean.TRUE);
                }
                return;
            }
            ++i;
        }
        this._adaptedBaseclasses.add(baseclass);
        this._baseclassDecapsulation.add(Boolean.TRUE);
    }

    public void addAdaptedBaseClass(ReferenceBinding baseclass) {
        int i = 0;
        while (i < this._adaptedBaseclasses.size()) {
            if (this._adaptedBaseclasses.get(i).equals(baseclass)) {
                return;
            }
            ++i;
        }
        this._adaptedBaseclasses.add(baseclass.getRealType());
        this._baseclassDecapsulation.add(Boolean.FALSE);
    }

    public void write(ClassFile classFile) {
        super.write(classFile);
        int attributeSize = 4;
        attributeSize += this._decapsulatedMethods.size() * (1 + M_SIZE);
        attributeSize += this._calloutToFields.size() * (1 + F_SIZE);
        attributeSize += this._superMethods.size() * 9;
        if (this._contentsOffset + 6 + (attributeSize += this._adaptedBaseclasses.size() * 3) >= this._contents.length) {
            this._contents = classFile.getResizedContents(6 + attributeSize);
        }
        this.writeName(this._name);
        this.writeInt(attributeSize);
        this.writeUnsignedShort(this._decapsulatedMethods.size() + this._calloutToFields.size() + this._superMethods.size());
        for (DecapsulatedMethodDesc decapsulatedMethodDesc : this._decapsulatedMethods) {
            decapsulatedMethodDesc.write();
        }
        for (CalloutToFieldDesc calloutToFieldDesc : this._calloutToFields) {
            calloutToFieldDesc.write();
        }
        for (SuperMethodDesc superMethodDesc : this._superMethods) {
            superMethodDesc.write();
        }
        int n = this._adaptedBaseclasses.size();
        this.writeUnsignedShort(n);
        int i = 0;
        while (i < n) {
            this.writeName(this._adaptedBaseclasses.get(i).attributeName());
            this.writeByte((byte)(this._baseclassDecapsulation.get(i) != false ? 1 : 0));
            ++i;
        }
        this.writeBack(classFile);
    }

    public OTSpecialAccessAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.OTSPECIAL_ACCESS);
        this._reader = reader;
        this._readOffset = readOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        int count = this.consumeShort();
        int i = 0;
        while (i < count) {
            this.readElement();
            ++i;
        }
        count = this.consumeShort();
        this._baseclassNames = new ArrayList<char[]>(count);
        i = 0;
        while (i < count) {
            this._baseclassNames.add(this.consumeName());
            this._baseclassDecapsulation.add(this.consumeByte() == 1 ? Boolean.TRUE : Boolean.FALSE);
            ++i;
        }
    }

    private void readElement() {
        int kind = this.consumeByte();
        switch (kind) {
            case 4: {
                this._readOffset += 2;
            }
            case 1: {
                this._readOffset += 6;
                break;
            }
            case 2: {
                this._readOffset += 7;
                break;
            }
            case 3: {
                this._readOffset += 8;
            }
        }
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 0);
        this._site = (ReferenceBinding)binding;
        if (((ReferenceBinding)binding).isRole()) {
            ((ReferenceBinding)binding).roleModel.setSpecialAccess(this);
        }
        if (this._baseclassNames != null) {
            int i = 0;
            while (i < this._baseclassNames.size()) {
                char[] name = this._baseclassNames.get(i);
                if (name != null && name.length > 0 && this._baseclassDecapsulation.get(i).booleanValue()) {
                    this._adaptedBaseclasses.add(environment.getTypeFromConstantPoolName(name, 0, -1, false, missingTypeNames));
                }
                ++i;
            }
        }
    }

    @Deprecated
    public void addFieldAccessesTo(TeamModel subTeam) {
        if (this._calloutToFields != null) {
            for (CalloutToFieldDesc fieldDesc : this._calloutToFields) {
                ReferenceBinding oldBase = fieldDesc.field.declaringClass;
                RoleModel[] roleModelArray = subTeam.getRoles(false);
                int n = roleModelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RoleModel role = roleModelArray[n2];
                    ReferenceBinding newBase = role.getBaseTypeBinding();
                    if (newBase != null && CharOperation.equals(newBase.sourceName(), oldBase.sourceName()) && RoleTypeBinding.isRoleType(newBase)) {
                        if (newBase instanceof WeakenedTypeBinding) {
                            newBase = ((WeakenedTypeBinding)newBase).getStrongType();
                        }
                        if (((RoleTypeBinding)newBase)._teamAnchor.isBaseAnchor()) {
                            FieldBinding newField = newBase.getRealClass().getField(fieldDesc.field.name, false);
                            role.addAccessedBaseField(newField, fieldDesc.calloutModifier());
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this._site.readableName());
        result.append(" requires special access to these elements:");
        for (DecapsulatedMethodDesc decapsulatedMethodDesc : this._decapsulatedMethods) {
            result.append("\n\tmethod ");
            result.append(decapsulatedMethodDesc.toString());
        }
        for (CalloutToFieldDesc calloutToFieldDesc : this._calloutToFields) {
            result.append("\n\tfield ");
            result.append(calloutToFieldDesc.toString());
        }
        for (SuperMethodDesc superMethodDesc : this._superMethods) {
            result.append("\n\t");
            result.append(superMethodDesc.toString());
        }
        for (ReferenceBinding referenceBinding : this._adaptedBaseclasses) {
            result.append("\n\tbase class ");
            result.append(referenceBinding.readableName());
        }
        return result.toString();
    }

    private class CalloutToFieldDesc {
        private static final int CALLOUT_GET_FIELD = 0;
        private static final int CALLOUT_SET_FIELD = 1;
        private static final int CALLOUT_STATIC_FIELD = 2;
        FieldBinding field;
        ReferenceBinding targetClass;
        int flags;
        private int accessId;

        CalloutToFieldDesc(FieldBinding field, ReferenceBinding targetClass, int calloutModifier) {
            this.field = field;
            this.targetClass = targetClass;
            int n = this.flags = calloutModifier == 122 ? 0 : 1;
            if (field.isStatic()) {
                this.flags |= 2;
            }
            if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                this.accessId = OTSpecialAccessAttribute.this.nextAccessId++;
            }
        }

        public int calloutModifier() {
            return (this.flags & 1) != 0 ? 123 : 122;
        }

        void write() {
            if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                OTSpecialAccessAttribute.this.writeByte((byte)5);
                OTSpecialAccessAttribute.this.writeByte((byte)this.accessId);
            } else {
                OTSpecialAccessAttribute.this.writeByte((byte)2);
            }
            OTSpecialAccessAttribute.this.writeByte((byte)this.flags);
            OTSpecialAccessAttribute.this.writeName(this.targetClass.attributeName());
            OTSpecialAccessAttribute.this.writeName(this.field.name);
            OTSpecialAccessAttribute.this.writeName(this.field.type.signature());
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.field.readableName());
            if (false) {
                result.append(" get");
            } else {
                result.append(" set");
            }
            if ((this.flags & 2) != 0) {
                result.append(" (static)");
            }
            return result.toString();
        }
    }

    private class DecapsulatedMethodDesc {
        ReferenceBinding boundBaseclass;
        MethodBinding method;
        private int accessId;

        DecapsulatedMethodDesc(ReferenceBinding boundBaseclass, MethodBinding method) {
            this.boundBaseclass = boundBaseclass;
            this.method = method;
            if (CopyInheritance.isCreator(method)) {
                this.boundBaseclass = this.boundBaseclass.enclosingType();
            }
            if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                this.accessId = OTSpecialAccessAttribute.this.nextAccessId++;
            }
        }

        void write() {
            if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                OTSpecialAccessAttribute.this.writeByte((byte)4);
            } else {
                OTSpecialAccessAttribute.this.writeByte((byte)1);
            }
            if (this.method.isConstructor()) {
                OTSpecialAccessAttribute.this.writeName(this.method.declaringClass.attributeName());
                OTSpecialAccessAttribute.this.writeName(this.method.selector);
                OTSpecialAccessAttribute.this.writeName(this.method.signature());
            } else {
                char sep = this.method.isStatic() ? (char)'!' : '?';
                char[] encodedName = CharOperation.concatWith(new char[][]{this.method.declaringClass.attributeName(), this.method.selector}, sep);
                OTSpecialAccessAttribute.this.writeName(this.boundBaseclass.attributeName());
                OTSpecialAccessAttribute.this.writeName(encodedName);
                OTSpecialAccessAttribute.this.writeName(this.method.signature());
                if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                    OTSpecialAccessAttribute.this.writeUnsignedShort(this.accessId);
                }
            }
        }

        public String toString() {
            return new String(this.method.readableName());
        }
    }

    public class SuperMethodDesc {
        MethodBinding method;

        public SuperMethodDesc(MethodBinding method) {
            this.method = method;
        }

        void write() {
            OTSpecialAccessAttribute.this.writeByte((byte)3);
            OTSpecialAccessAttribute.this.writeName(this.method.declaringClass.attributeName());
            OTSpecialAccessAttribute.this.writeName(this.method.declaringClass.superclass().attributeName());
            OTSpecialAccessAttribute.this.writeName(this.method.selector);
            OTSpecialAccessAttribute.this.writeName(this.method.signature());
        }

        public String toString() {
            return "superaccess for " + new String(this.method.readableName());
        }
    }
}

