/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MagicLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.LiftingTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.QualifiedBaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ResultReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TSuperMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TsuperReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeArrayQualifiedTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeArrayTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeParameterizedQualifiedTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeParameterizedSingleTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeQualifiedTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AlienScopeSingleTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstFactory;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.IAlienScopeTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class AstGenerator
extends AstFactory {
    static final int AccIfcMethod = 0x1000400;
    public long sourceLevel = 0x310000L;
    public ITeamAnchor replaceableBaseAnchor = null;
    public ReferenceBinding replaceableEnclosingClass;

    public AstGenerator(int start, int end) {
        super(start, end);
    }

    public AstGenerator(long sourceLevel, int start, int end) {
        super(start, end);
        this.sourceLevel = sourceLevel;
    }

    public AstGenerator(long pos) {
        super((int)(pos >>> 32), (int)pos);
    }

    public AstGenerator(ASTNode node) {
        super(0, 0);
        this.retargetFrom(node);
    }

    public void setPositions(Expression expression) {
        expression.sourceStart = this.sourceStart;
        expression.sourceEnd = this.sourceEnd;
    }

    public LocalDeclaration localVariable(char[] name, char[] type, Expression init) {
        return this.localVariable(name, new SingleTypeReference(type, this.pos), init);
    }

    public LocalDeclaration localVariable(char[] name, TypeBinding type, Expression init) {
        TypeReference typeReference = this.typeReference(type);
        typeReference.sourceStart = this.sourceStart;
        typeReference.sourceEnd = this.sourceEnd;
        return this.localVariable(name, typeReference, init);
    }

    public LocalDeclaration localBaseVariable(char[] name, TypeBinding type, Expression init) {
        TypeReference typeReference = this.baseclassReference(type);
        typeReference.sourceStart = this.sourceStart;
        typeReference.sourceEnd = this.sourceEnd;
        return this.localVariable(name, typeReference, init);
    }

    public LocalDeclaration localVariable(char[] name, TypeReference typeReference, Expression init) {
        LocalDeclaration variable = new LocalDeclaration(name, this.sourceStart, this.sourceEnd);
        variable.initialization = init;
        variable.declarationSourceStart = this.sourceStart;
        variable.declarationSourceEnd = this.sourceEnd;
        variable.type = typeReference;
        variable.isGenerated = true;
        return variable;
    }

    public LocalDeclaration localVariable(char[] name, TypeReference typeReference, int modifiers, Expression init) {
        LocalDeclaration variable = new LocalDeclaration(name, this.sourceStart, this.sourceEnd);
        variable.initialization = init;
        variable.declarationSourceStart = this.sourceStart;
        variable.declarationSourceEnd = this.sourceEnd;
        variable.type = typeReference;
        variable.modifiers = modifiers;
        variable.isGenerated = true;
        return variable;
    }

    public SingleNameReference singleNameReference(char[] name) {
        SingleNameReference ref = new SingleNameReference(name, this.pos);
        ref.isGenerated = true;
        return ref;
    }

    public QualifiedNameReference qualifiedNameReference(char[][] tokens) {
        long[] poss = new long[tokens.length];
        Arrays.fill(poss, this.pos);
        return new QualifiedNameReference(tokens, poss, this.sourceStart, this.sourceEnd);
    }

    public QualifiedNameReference qualifiedBaseNameReference(char[][] tokens) {
        QualifiedNameReference ref = this.qualifiedNameReference(tokens);
        ref.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
        return ref;
    }

    public QualifiedNameReference qualifiedNameReference(ReferenceBinding type) {
        char[][] tokens = CharOperation.splitOn('.', type.readableName());
        return this.qualifiedNameReference(tokens);
    }

    public QualifiedNameReference qualifiedNameReference(FieldBinding field) {
        char[][] className = TypeAnalyzer.compoundNameOfReferenceType(field.declaringClass, true, false);
        int len = className.length;
        char[][] qualifiedName = new char[len + 1][];
        System.arraycopy(className, 0, qualifiedName, 0, len);
        qualifiedName[len] = field.name;
        QualifiedNameReference qualifiedNameReference = this.qualifiedNameReference(qualifiedName);
        qualifiedNameReference.binding = field;
        qualifiedNameReference.actualReceiverType = field.declaringClass;
        qualifiedNameReference.resolvedType = field.type;
        qualifiedNameReference.bits &= 0xFFFFFFF8;
        qualifiedNameReference.bits |= 1;
        qualifiedNameReference.constant = Constant.NotAConstant;
        return qualifiedNameReference;
    }

    public NameReference nameReference(ReferenceBinding type) {
        char[] sname;
        char[] typeName = "void".toCharArray();
        char[][] qname = TypeAnalyzer.compoundNameOfReferenceType(type, true, true);
        if (qname != null && qname.length == 1) {
            sname = qname[0];
            qname = null;
        } else {
            sname = typeName;
        }
        NameReference nr = null;
        if (qname == null) {
            nr = this.singleNameReference(sname);
        } else {
            long[] poss = new long[qname.length];
            Arrays.fill(poss, 0L);
            nr = this.qualifiedNameReference(qname);
        }
        return nr;
    }

    public SingleNameReference baseNameReference(char[] name) {
        SingleNameReference result = this.singleNameReference(name);
        result.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
        return result;
    }

    public NameReference baseNameReference(ReferenceBinding type) {
        NameReference result = this.nameReference(type);
        result.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
        return result;
    }

    public TypeReference baseTypeReference(char[] name) {
        SingleTypeReference result = this.singleTypeReference(name);
        result.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        return result;
    }

    public TypeReference baseTypeReference(ReferenceBinding type) {
        TypeReference result = this.typeReference(type);
        result.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        return result;
    }

    public Expression thislikeNameReference(char[] name) {
        SingleNameReference result = this.singleNameReference(name);
        result.isThisLike = true;
        return result;
    }

    public ResultReference resultReference(SingleNameReference ref, AbstractMethodMappingDeclaration mapping) {
        return new ResultReference(ref, mapping);
    }

    public FieldReference fieldReference(Expression receiver, char[] name) {
        return this.fieldReference(receiver, name, Expression.DecapsulationState.NONE);
    }

    public FieldReference fieldReference(Expression receiver, char[] name, Expression.DecapsulationState baseDecapsulation) {
        FieldReference field = new FieldReference(name, this.pos);
        field.receiver = receiver;
        if (baseDecapsulation != Expression.DecapsulationState.NONE) {
            field.setBaseclassDecapsulation(baseDecapsulation);
        }
        return field;
    }

    public FieldReference resolvedFieldReference(Expression receiver, FieldBinding field) {
        FieldReference fieldRef = new FieldReference(field.name, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        fieldRef.receiver = receiver;
        fieldRef.actualReceiverType = receiver.resolvedType;
        fieldRef.resolvedType = field.type;
        fieldRef.binding = field;
        fieldRef.constant = Constant.NotAConstant;
        return fieldRef;
    }

    public SingleTypeReference singleTypeReference(TypeBinding type) {
        return new SingleTypeReference(type.sourceName(), this.pos);
    }

    public SingleTypeReference singleTypeReference(char[] name) {
        return new SingleTypeReference(name, this.pos);
    }

    public ArrayTypeReference arrayTypeReference(char[] name, int dims) {
        return new ArrayTypeReference(name, dims, this.pos);
    }

    public NullLiteral nullLiteral() {
        NullLiteral result = new NullLiteral(this.sourceStart, this.sourceEnd);
        result.constant = Constant.NotAConstant;
        return result;
    }

    public Expression nullCheck(Expression value) {
        return this.internalNullCheck(value, 18);
    }

    public Expression nonNullCheck(Expression value) {
        return this.internalNullCheck(value, 29);
    }

    Expression internalNullCheck(Expression value, int operator) {
        EqualExpression result = new EqualExpression(value, this.nullLiteral(), operator){

            @Override
            protected void checkVariableComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse, LocalVariableBinding local, int nullStatus, Expression reference) {
                switch (nullStatus) {
                    case 2: {
                        if ((this.bits & 0xFC0) >> 6 == 18) {
                            initsWhenTrue.markAsComparedEqualToNull(local);
                            initsWhenFalse.markAsComparedEqualToNonNull(local);
                            break;
                        }
                        initsWhenTrue.markAsComparedEqualToNonNull(local);
                        initsWhenFalse.markAsComparedEqualToNull(local);
                        break;
                    }
                    case 4: {
                        if ((this.bits & 0xFC0) >> 6 != 18) break;
                        initsWhenTrue.markAsComparedEqualToNonNull(local);
                    }
                }
            }
        };
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.constant = Constant.NotAConstant;
        result.isGenerated = true;
        return result;
    }

    public IntLiteral intLiteral(int val) {
        IntLiteral result = IntLiteral.buildIntLiteral(String.valueOf(val).toCharArray(), this.sourceStart, this.sourceEnd);
        return result;
    }

    public TeamModel.UpdatableIntLiteral updatableIntLiteral(int val) {
        return new TeamModel.UpdatableIntLiteral(val, this.sourceStart, this.sourceEnd);
    }

    public Literal booleanLiteral(boolean val) {
        MagicLiteral result = val ? new TrueLiteral(this.sourceStart, this.sourceEnd) : new FalseLiteral(this.sourceStart, this.sourceEnd);
        result.isGenerated = true;
        return result;
    }

    public StringLiteral stringLiteral(char[] cs) {
        return new StringLiteral(cs, this.sourceStart, this.sourceEnd, 0);
    }

    public Expression classLiteralAccess(TypeReference reference) {
        return new ClassLiteralAccess(this.sourceEnd, reference, true);
    }

    public QualifiedTypeReference qualifiedTypeReference(char[][] compoundName) {
        long[] poss = new long[compoundName.length];
        Arrays.fill(poss, this.pos);
        QualifiedTypeReference reference = new QualifiedTypeReference(compoundName, poss);
        reference.bits |= 0x40000000;
        reference.isGenerated = true;
        return reference;
    }

    public QualifiedTypeReference qualifiedArrayTypeReference(char[][] compoundName, int dims) {
        long[] poss = new long[compoundName.length];
        Arrays.fill(poss, this.pos);
        ArrayQualifiedTypeReference reference = new ArrayQualifiedTypeReference(compoundName, dims, poss);
        reference.bits |= 0x40000000;
        reference.isGenerated = true;
        return reference;
    }

    public SingleTypeReference parameterizedSingleTypeReference(char[] name, TypeReference[] typeParameters, int dimensions) {
        if (this.sourceLevel < 0x310000L) {
            return this.singleTypeReference(name);
        }
        return new ParameterizedSingleTypeReference(name, typeParameters, 0, this.pos);
    }

    public QualifiedTypeReference parameterizedQualifiedTypeReference(char[][] compoundName, TypeReference[] lastTypeParameters) {
        TypeReference[][] typeParameters = new TypeReference[compoundName.length][];
        typeParameters[compoundName.length - 1] = lastTypeParameters;
        return this.parameterizedQualifiedTypeReference(compoundName, typeParameters, 0);
    }

    public QualifiedTypeReference parameterizedQualifiedTypeReference(char[][] compoundName, TypeReference[][] typeParameters, int dims) {
        if (this.sourceLevel < 0x310000L) {
            return this.qualifiedTypeReference(compoundName);
        }
        long[] poss = new long[compoundName.length];
        Arrays.fill(poss, this.pos);
        return new ParameterizedQualifiedTypeReference(compoundName, typeParameters, dims, poss);
    }

    public QualifiedTypeReference parameterizedQualifiedTypeReference(char[][] compoundName, TypeBinding[] lastTypeParameters) {
        TypeReference[] parameterRefs = new TypeReference[lastTypeParameters.length];
        int i = 0;
        while (i < lastTypeParameters.length) {
            parameterRefs[i] = this.typeReference(lastTypeParameters[i], true);
            ++i;
        }
        return this.parameterizedQualifiedTypeReference(compoundName, parameterRefs);
    }

    public TypeReference typeReference(TypeBinding type) {
        return this.typeReference(type, true);
    }

    public TypeReference typeReference(TypeBinding type, boolean makeGeneric) {
        int dims = 0;
        TypeBinding elementType = type;
        if (type instanceof ArrayBinding) {
            ArrayBinding ab = (ArrayBinding)type;
            dims = ab.dimensions;
            elementType = ab.leafComponentType;
        }
        TypeReference typeReference = this.createArrayTypeReference(elementType, dims, makeGeneric);
        typeReference.bits |= 0x40000000;
        typeReference.isGenerated = true;
        typeReference.deprecationProblemId = 0;
        if (!type.isValidBinding()) {
            typeReference.bits |= 0x200000;
        }
        return typeReference;
    }

    public TypeReference baseclassReference(TypeBinding type) {
        return this.baseclassReference(type, false);
    }

    public TypeReference baseclassReference(TypeBinding type, boolean erase) {
        TypeReference[][] allParams;
        if (erase &= type.isParameterizedType()) {
            type = type.erasure();
        }
        TypeReference result = this.typeReference(type);
        result.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        TypeReference[] parameters = null;
        if (result instanceof ParameterizedSingleTypeReference) {
            parameters = ((ParameterizedSingleTypeReference)result).typeArguments;
        } else if (result instanceof ParameterizedQualifiedTypeReference && (allParams = ((ParameterizedQualifiedTypeReference)result).typeArguments) != null) {
            parameters = allParams[allParams.length - 1];
        }
        if (parameters != null) {
            TypeReference[] typeReferenceArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference parameter = typeReferenceArray[n2];
                parameter.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
                ++n2;
            }
        }
        if (erase) {
            result.bits |= 0x40000000;
        }
        return result;
    }

    public ParameterizedSingleTypeReference roleTypeReference(ITeamAnchor baseSideAnchor, ReferenceBinding roleType, int dims) {
        TypeReference[] typeParameters;
        TypeBinding[] typeArguments;
        TypeAnchorReference anchorRef = this.typeAnchorReference(baseSideAnchor);
        TypeBinding[] typeBindingArray = typeArguments = roleType.isParameterizedType() ? ((ParameterizedTypeBinding)roleType).arguments : null;
        if (typeArguments != null) {
            typeParameters = new TypeReference[typeArguments.length + 1];
            typeParameters[0] = anchorRef;
            int i = 0;
            while (i < typeArguments.length) {
                typeParameters[i + 1] = this.typeReference(typeArguments[i]);
                ++i;
            }
        } else {
            typeParameters = new TypeReference[]{anchorRef};
        }
        ParameterizedSingleTypeReference result = new ParameterizedSingleTypeReference(roleType.internalName(), typeParameters, dims, this.pos);
        return result;
    }

    public TypeReference createArrayTypeReference(TypeBinding elementType, int dims) {
        TypeReference typeReference = this.createArrayTypeReference(elementType, dims, true);
        typeReference.deprecationProblemId = 0;
        typeReference.bits |= 0x40000000;
        typeReference.isGenerated = true;
        return typeReference;
    }

    private TypeReference createArrayTypeReference(TypeBinding elementType, int dims, boolean makeGeneric) {
        char[] sname;
        if (elementType.isTypeVariable()) {
            TypeVariableBinding typeVariable = (TypeVariableBinding)elementType;
            char[] variableName = typeVariable.sourceName();
            if (dims == 0) {
                return new SingleTypeReference(variableName, this.pos);
            }
            return new ArrayTypeReference(variableName, dims, this.pos);
        }
        if (makeGeneric && elementType.isParameterizedType()) {
            ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)elementType;
            TypeBinding[] argumentTypes = paramType.arguments;
            if (argumentTypes != null) {
                char[][] compoundName = paramType.compoundName;
                char[] tokenString = CharOperation.concatWith(compoundName, '$');
                compoundName = CharOperation.splitOn('$', tokenString);
                TypeReference[][] arguments = new TypeReference[compoundName.length][];
                TypeReference[] lastArgs = new TypeReference[argumentTypes.length];
                arguments[compoundName.length - 1] = lastArgs;
                int i = 0;
                while (i < argumentTypes.length) {
                    lastArgs[i] = this.typeReference(argumentTypes[i]);
                    ++i;
                }
                long[] poss = new long[argumentTypes.length];
                Arrays.fill(poss, this.pos);
                return new ParameterizedQualifiedTypeReference(compoundName, arguments, dims, poss);
            }
        } else if (elementType.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)elementType;
            Wildcard result = new Wildcard(wildcard.boundKind);
            result.sourceStart = this.sourceStart;
            result.sourceEnd = this.sourceEnd;
            if (wildcard.bound != null) {
                result.bound = this.typeReference(wildcard.bound);
            }
            return result;
        }
        char[] typeName = "void".toCharArray();
        char[][] qname = null;
        TypeAnchorReference anchorRef = null;
        if (elementType instanceof BaseTypeBinding) {
            typeName = ((BaseTypeBinding)elementType).simpleName;
        } else if (elementType instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)elementType;
            qname = TypeAnalyzer.compoundNameOfReferenceType(referenceBinding, true, false);
            if (referenceBinding instanceof DependentTypeBinding && ((DependentTypeBinding)referenceBinding).hasExplicitAnchor()) {
                DependentTypeBinding depBind = (DependentTypeBinding)referenceBinding;
                anchorRef = this.typeAnchorReference(depBind.getAnchor());
                typeName = referenceBinding.internalName();
                qname = null;
            }
        }
        if (qname != null && qname.length == 1) {
            sname = qname[0];
            qname = null;
        } else {
            sname = typeName;
        }
        long[] poss = null;
        if (qname != null) {
            poss = new long[qname.length];
            Arrays.fill(poss, this.pos);
        }
        if (anchorRef == null) {
            if (dims == 0) {
                if (qname == null) {
                    return new SingleTypeReference(sname, this.pos);
                }
                return new QualifiedTypeReference(qname, poss);
            }
            if (qname == null) {
                return new ArrayTypeReference(sname, dims, this.pos);
            }
            return new ArrayQualifiedTypeReference(qname, dims, poss);
        }
        TypeReference[] typeReferences = new TypeReference[]{anchorRef};
        assert (qname == null);
        return new ParameterizedSingleTypeReference(sname, typeReferences, dims, this.pos);
    }

    public TypeAnchorReference typeAnchorReference(ITeamAnchor anchor) {
        ReferenceBinding firstClass = null;
        if (anchor instanceof FieldBinding && CharOperation.equals(((FieldBinding)anchor).name, IOTConstants._OT_BASE)) {
            Reference anchorRef;
            if (this.replaceableBaseAnchor == anchor) {
                anchorRef = this.singleNameReference(BASE);
            } else {
                firstClass = ((FieldBinding)anchor).declaringClass;
                if (this.replaceableEnclosingClass != null) {
                    firstClass = this.strengthenEnclosing(firstClass, this.replaceableEnclosingClass);
                }
                anchorRef = new QualifiedBaseReference(this.typeReference(firstClass), this.sourceStart, this.sourceEnd);
            }
            return new TypeAnchorReference(anchorRef, this.sourceStart);
        }
        firstClass = anchor.getFirstDeclaringClass();
        Reference nameRef = null;
        ITeamAnchor[] path = anchor.getBestNamePath();
        if (firstClass != null) {
            if (this.replaceableEnclosingClass != null) {
                firstClass = this.strengthenEnclosing(firstClass, this.replaceableEnclosingClass);
            }
            nameRef = this.qualifiedThisReference(firstClass);
            int i = 0;
            while (i < path.length) {
                if (!(path[i] instanceof TThisBinding)) {
                    nameRef = this.fieldReference(nameRef, path[i].internalName());
                }
                ++i;
            }
        } else {
            nameRef = anchor instanceof TThisBinding ? this.qualifiedThisReference(anchor.getFirstDeclaringClass()) : this.qualifiedNameReference(anchor.tokens());
        }
        TypeAnchorReference anchorRef = new TypeAnchorReference(nameRef, this.sourceStart);
        return anchorRef;
    }

    private ReferenceBinding strengthenEnclosing(ReferenceBinding currentType, ReferenceBinding strongEnclosing) {
        while (strongEnclosing != null) {
            ReferenceBinding strongOuter;
            if (TypeBinding.equalsEquals(strongEnclosing, currentType) || TypeBinding.equalsEquals(strongEnclosing.superclass(), currentType)) {
                return strongEnclosing;
            }
            ReferenceBinding currentOuter = currentType.enclosingType();
            if (currentOuter != null && (strongOuter = this.strengthenEnclosing(currentOuter, strongEnclosing)) != null) {
                return strongOuter.getMemberType(currentType.internalName());
            }
            strongEnclosing = strongEnclosing.enclosingType();
        }
        return null;
    }

    public TypeParameter typeParameter(TypeVariableBinding typeVarBinding) {
        TypeParameter result = this.unboundedTypeParameter(typeVarBinding.sourceName);
        result.type = this.typeReference(typeVarBinding.superclass);
        ReferenceBinding[] superInterfaces = typeVarBinding.superInterfaces;
        if (superInterfaces != Binding.NO_SUPERINTERFACES && superInterfaces.length > 0) {
            result.type = this.typeReference(superInterfaces[0]);
            if (superInterfaces.length > 1) {
                result.bounds = new TypeReference[superInterfaces.length - 1];
                int i = 0;
                while (i < superInterfaces.length - 1) {
                    result.bounds[i] = this.typeReference(superInterfaces[i - 1]);
                    result.bounds[i].bits |= 0x10;
                    ++i;
                }
            }
        }
        return result;
    }

    public TypeParameter baseBoundedTypeParameter(char[] name, ReferenceBinding roleType) {
        TypeParameter result = this.unboundedTypeParameter(name);
        result.type = this.typeReference(roleType);
        result.type.bits |= 0x2000;
        return result;
    }

    public TypeParameter unboundedTypeParameter(char[] name) {
        TypeParameter result = new TypeParameter();
        result.name = name;
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.declarationSourceStart = this.sourceStart;
        result.declarationSourceEnd = this.sourceEnd;
        return result;
    }

    public Wildcard wildcard(int kind) {
        Wildcard result = new Wildcard(kind);
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        return result;
    }

    public LiftingTypeReference liftingTypeReference(TypeReference baseReference, TypeReference roleReference, char[] roleToken, char[][] baseTokens) {
        LiftingTypeReference result = new LiftingTypeReference();
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.baseReference = baseReference;
        result.roleReference = roleReference;
        int len = baseTokens.length;
        result.baseTokens = new char[len][];
        System.arraycopy(baseTokens, 0, result.baseTokens, 0, len);
        result.roleToken = roleToken;
        return result;
    }

    public FieldDeclaration field(int modifiers, TypeReference typeRef, char[] name, Expression init) {
        FieldDeclaration field = new FieldDeclaration(name, this.sourceStart, this.sourceEnd);
        field.declarationSourceStart = this.sourceStart;
        field.declarationSourceEnd = this.sourceEnd;
        field.declarationEnd = this.sourceEnd;
        field.initialization = init;
        field.type = typeRef;
        field.modifiers = modifiers;
        field.isGenerated = true;
        return field;
    }

    public ConstructorDeclaration constructor(CompilationResult compilationResult, int modifiers, char[] selector, Argument[] arguments) {
        ConstructorDeclaration newMethod = new ConstructorDeclaration(compilationResult);
        this.setMethodPositions(newMethod);
        newMethod.isGenerated = true;
        newMethod.modifiers = modifiers;
        newMethod.selector = selector;
        newMethod.arguments = arguments;
        return newMethod;
    }

    public MethodDeclaration method(CompilationResult compilationResult, int modifiers, TypeBinding returnType, char[] selector, Argument[] arguments) {
        TypeReference returnTypeRef = null;
        if (returnType != null) {
            returnTypeRef = this.typeReference(returnType);
        }
        return this.method(compilationResult, modifiers, returnTypeRef, selector, arguments);
    }

    public MethodDeclaration method(CompilationResult compilationResult, int modifiers, TypeReference returnTypeRef, char[] selector, Argument[] arguments) {
        MethodDeclaration newMethod = new MethodDeclaration(compilationResult);
        this.setMethodPositions(newMethod);
        newMethod.isGenerated = true;
        newMethod.modifiers = modifiers;
        newMethod.returnType = returnTypeRef;
        newMethod.selector = selector;
        newMethod.arguments = arguments;
        return newMethod;
    }

    public MethodDeclaration method(CompilationResult compilationResult, int modifiers, TypeReference returnType, char[] selector, Argument[] arguments, Statement[] statements) {
        MethodDeclaration newMethod = this.method(compilationResult, modifiers, returnType, selector, arguments);
        newMethod.statements = statements;
        newMethod.hasParsedStatements = true;
        return newMethod;
    }

    public void maybeAddTypeParametersToMethod(ReferenceBinding typeBinding, MethodDeclaration methodDecl) {
        if (typeBinding.isParameterizedType()) {
            TypeBinding[] arguments = ((ParameterizedTypeBinding)typeBinding).arguments;
            TypeParameter[] methodTypeParams = new TypeParameter[arguments.length];
            int i = 0;
            while (i < methodTypeParams.length) {
                methodTypeParams[i] = this.typeParameter((TypeVariableBinding)arguments[i]);
                ++i;
            }
            methodDecl.typeParameters = methodTypeParams;
        }
    }

    public Argument argument(char[] name, TypeReference type) {
        Argument result = new Argument(name, this.pos, type, 0);
        result.declarationSourceStart = this.sourceStart;
        return result;
    }

    public Argument argument(char[] name, TypeReference type, int modifiers) {
        Argument result = new Argument(name, this.pos, type, modifiers);
        result.declarationSourceStart = this.sourceStart;
        return result;
    }

    public MessageSend messageSend(Expression receiver, char[] selector, Expression[] parameters) {
        MessageSend messageSend = new MessageSend();
        messageSend.isGenerated = true;
        messageSend.sourceStart = this.sourceStart;
        messageSend.sourceEnd = this.sourceEnd;
        messageSend.statementEnd = this.sourceEnd;
        messageSend.nameSourcePosition = this.pos;
        messageSend.receiver = receiver;
        messageSend.selector = selector;
        messageSend.arguments = parameters;
        return messageSend;
    }

    public MessageSend tsuperMessageSend(Expression receiver, char[] selector, Expression[] parameters) {
        TSuperMessageSend messageSend = new TSuperMessageSend();
        messageSend.isGenerated = true;
        messageSend.sourceStart = this.sourceStart;
        messageSend.sourceEnd = this.sourceEnd;
        messageSend.statementEnd = this.sourceEnd;
        messageSend.nameSourcePosition = this.pos;
        messageSend.receiver = receiver;
        messageSend.tsuperReference = new TsuperReference(this.sourceStart, this.sourceEnd);
        messageSend.selector = selector;
        messageSend.arguments = parameters;
        return messageSend;
    }

    public MessageSend messageSendWithResolveHook(Expression receiver, final MethodBinding method, Expression[] parameters, final IRunInScope hook) {
        MessageSend messageSend = new MessageSend(){

            @Override
            public TypeBinding resolveType(BlockScope scope) {
                this.constant = Constant.NotAConstant;
                if (this.arguments != null) {
                    int length = this.arguments.length;
                    int i = 0;
                    while (i < length) {
                        Expression argument = this.arguments[i];
                        if (argument.resolvedType == null) {
                            argument.resolveType(scope);
                        }
                        ++i;
                    }
                }
                if (this.receiver.getClass() == this.getClass()) {
                    this.receiver.resolveType(scope);
                }
                this.binding = method;
                this.resolvedType = method.returnType;
                hook.run(scope);
                this.actualReceiverType = this.binding.declaringClass;
                return this.resolvedType;
            }
        };
        messageSend.isGenerated = true;
        messageSend.sourceStart = this.sourceStart;
        messageSend.sourceEnd = this.sourceEnd;
        messageSend.statementEnd = this.sourceEnd;
        messageSend.nameSourcePosition = this.pos;
        messageSend.receiver = receiver;
        messageSend.selector = method.selector;
        messageSend.arguments = parameters;
        return messageSend;
    }

    public MessageSend messageSend(Expression receiver, char[] selector, Expression[] parameters, final TypeBinding resolvedReturn) {
        MessageSend messageSend = new MessageSend(){

            @Override
            public TypeBinding resolveType(BlockScope scope) {
                super.resolveType(scope);
                this.resolvedType = resolvedReturn;
                return this.resolvedType;
            }
        };
        messageSend.isGenerated = true;
        messageSend.sourceStart = this.sourceStart;
        messageSend.sourceEnd = this.sourceEnd;
        messageSend.statementEnd = this.sourceEnd;
        messageSend.nameSourcePosition = this.pos;
        messageSend.receiver = receiver;
        messageSend.selector = selector;
        messageSend.arguments = parameters;
        return messageSend;
    }

    public MessageSend fakeMessageSend(Expression receiver, char[] selector, Expression[] parameters, final ReferenceBinding receiverType, final TypeBinding resolvedReturn) {
        MessageSend messageSend = new MessageSend(){

            @Override
            public TypeBinding resolveType(BlockScope scope) {
                ReferenceContext referenceContext = scope.referenceContext();
                CompilationResult.CheckPoint cp = referenceContext.compilationResult().getCheckPoint(referenceContext);
                super.resolveType(scope);
                referenceContext.compilationResult().rollBack(cp);
                this.binding = new MethodBinding(9, this.selector, resolvedReturn, this.binding.parameters, Binding.NO_EXCEPTIONS, receiverType);
                this.resolvedType = resolvedReturn;
                return this.resolvedType;
            }
        };
        messageSend.isGenerated = true;
        messageSend.sourceStart = this.sourceStart;
        messageSend.sourceEnd = this.sourceEnd;
        messageSend.statementEnd = this.sourceEnd;
        messageSend.nameSourcePosition = this.pos;
        messageSend.receiver = receiver;
        messageSend.selector = selector;
        messageSend.arguments = parameters;
        return messageSend;
    }

    public AllocationExpression allocation(TypeReference typeRef, Expression[] arguments) {
        AllocationExpression result = new AllocationExpression();
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.statementEnd = this.sourceEnd;
        result.type = typeRef;
        result.arguments = arguments;
        result.isGenerated = true;
        return result;
    }

    public ArrayAllocationExpression arrayAllocation(TypeReference typeRef, int dims, Expression[] arguments) {
        ArrayAllocationExpression allocation = new ArrayAllocationExpression();
        allocation.type = typeRef;
        if (arguments == null) {
            allocation.dimensions = new Expression[]{this.intLiteral(dims)};
        } else {
            allocation.dimensions = new Expression[dims];
            allocation.initializer = new ArrayInitializer();
            allocation.initializer.expressions = arguments;
        }
        return this.setPos(allocation);
    }

    public QualifiedAllocationExpression qualifiedAllocation(Expression enclosingInstance, SingleTypeReference typeRef, Expression[] arguments) {
        QualifiedAllocationExpression result = new QualifiedAllocationExpression();
        result.enclosingInstance = enclosingInstance;
        result.type = typeRef;
        result.arguments = arguments;
        return this.setPos(result);
    }

    public QualifiedAllocationExpression anonymousAllocation(TypeReference superType, Expression[] arguments, TypeDeclaration anonymousType) {
        QualifiedAllocationExpression result = new QualifiedAllocationExpression();
        result.enclosingInstance = null;
        result.type = superType;
        result.arguments = arguments;
        result.anonymousType = anonymousType;
        anonymousType.allocation = result;
        return this.setPos(result);
    }

    public TypeDeclaration anonymousType(CompilationResult compilationResult) {
        TypeDeclaration anonymousType = new TypeDeclaration(compilationResult);
        anonymousType.sourceStart = this.sourceStart;
        anonymousType.sourceEnd = this.sourceEnd;
        anonymousType.declarationSourceStart = this.sourceStart;
        anonymousType.declarationSourceEnd = this.sourceEnd;
        anonymousType.bodyStart = this.sourceStart;
        anonymousType.bodyEnd = this.sourceEnd;
        anonymousType.name = CharOperation.NO_CHAR;
        anonymousType.bits |= 0x300;
        anonymousType.isGenerated = true;
        return anonymousType;
    }

    public ExplicitConstructorCall explicitConstructorCall(int accessMode) {
        ExplicitConstructorCall call = new ExplicitConstructorCall(accessMode);
        call.sourceStart = this.sourceStart;
        call.sourceEnd = this.sourceEnd;
        return call;
    }

    public CastExpression castExpression(Expression expression, TypeReference type, int kind) {
        CastExpression cast = new CastExpression(expression, type, kind);
        cast.constant = Constant.NotAConstant;
        return this.setPos(cast);
    }

    public CastExpression resolvedCastExpression(Expression expr, TypeBinding type, int kind) {
        if (expr instanceof ThisReference) {
            return null;
        }
        TypeReference typeRef = this.typeReference(type);
        typeRef.sourceStart = this.sourceStart;
        typeRef.sourceEnd = this.sourceEnd;
        typeRef.resolvedType = type;
        CastExpression cast = new CastExpression(expr, typeRef, kind);
        typeRef.resolvedType = cast.resolvedType = type;
        cast.constant = Constant.NotAConstant;
        cast.tagAsNeedCheckCast();
        return this.setPos(cast);
    }

    public InstanceOfExpression instanceOfExpression(Expression expression, TypeReference type) {
        InstanceOfExpression result = new InstanceOfExpression(expression, type);
        return result;
    }

    public ReturnStatement returnStatement(Expression expression) {
        return new ReturnStatement(expression, this.sourceStart, this.sourceEnd);
    }

    public ReturnStatement returnStatement(Expression expression, boolean synthetic) {
        ReturnStatement returnStatement = new ReturnStatement(expression, this.sourceStart, this.sourceEnd);
        if (synthetic) {
            returnStatement.isGenerated = true;
        }
        return returnStatement;
    }

    public IfStatement ifStatement(Expression condition, Statement thenStatement) {
        return new IfStatement(condition, thenStatement, this.sourceStart, this.sourceEnd);
    }

    public IfStatement ifStatement(Expression condition, Statement thenStatement, Statement elseStatement) {
        IfStatement result = new IfStatement(condition, thenStatement, this.sourceStart, this.sourceEnd);
        result.elseStatement = elseStatement;
        return result;
    }

    public IfStatement ifStatement(Expression condition, Block thenBlock, Block elseBlock) {
        IfStatement result = new IfStatement(condition, thenBlock, this.sourceStart, this.sourceEnd);
        result.elseStatement = elseBlock;
        return result;
    }

    public IfStatement stealthIfNotStatement(final Expression condition, Statement thenStatement) {
        Expression recordingCondition = new Expression(){

            @Override
            public StringBuffer printExpression(int indent, StringBuffer output) {
                return condition.print(indent, output);
            }

            @Override
            public TypeBinding resolveType(BlockScope scope) {
                return condition.resolveType(scope);
            }

            @Override
            public void computeConversion(Scope scope, TypeBinding runtimeType, TypeBinding compileTimeType) {
                condition.computeConversion(scope, runtimeType, compileTimeType);
                this.constant = condition.constant;
                this.bits = condition.bits;
            }

            @Override
            public Constant optimizedBooleanConstant() {
                this.constant = condition.optimizedBooleanConstant();
                this.bits = condition.bits;
                return this.constant;
            }

            @Override
            public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
                return condition.analyseCode(currentScope, flowContext, flowInfo, valueRequired);
            }

            @Override
            public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
                return condition.analyseCode(currentScope, flowContext, flowInfo);
            }

            @Override
            public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
                condition.generateCode(currentScope, codeStream, valueRequired);
                codeStream.pcToSourceMap[codeStream.pcToSourceMapSize++] = codeStream.position;
                codeStream.pcToSourceMap[codeStream.pcToSourceMapSize++] = 65534;
            }
        };
        return new IfStatement(new UnaryExpression(recordingCondition, 11), thenStatement, this.sourceStart, this.sourceEnd);
    }

    public ThrowStatement throwStatement(Expression exception) {
        return new ThrowStatement(exception, this.sourceStart, this.sourceEnd);
    }

    public CaseStatement caseStatement(Expression constExpr) {
        return new CaseStatement(constExpr, this.sourceStart, this.sourceEnd);
    }

    public BreakStatement breakStatement() {
        return new BreakStatement(null, this.sourceStart, this.sourceEnd);
    }

    public Assignment assignment(Reference lhs, Expression rhs) {
        Assignment ass = new Assignment(lhs, rhs, this.sourceEnd);
        ass.statementEnd = this.sourceEnd;
        return ass;
    }

    public Block block2(Statement stmt1, Statement stmt2) {
        int explicitDeclarations = 0;
        if (stmt1 instanceof LocalDeclaration) {
            ++explicitDeclarations;
        }
        if (stmt2 instanceof LocalDeclaration) {
            ++explicitDeclarations;
        }
        Block result = new Block(explicitDeclarations);
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.statements = new Statement[]{stmt1, stmt2};
        return result;
    }

    public Block block(Statement[] stmts) {
        int explicitDeclarations = 0;
        if (stmts != null) {
            Statement[] statementArray = stmts;
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                if (statement instanceof LocalDeclaration) {
                    ++explicitDeclarations;
                }
                ++n2;
            }
        }
        Block result = new Block(explicitDeclarations);
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        result.statements = stmts;
        return result;
    }

    public SynchronizedStatement synchronizedStatement(Expression expr, Statement[] stmts) {
        return new SynchronizedStatement(expr, this.block(stmts), this.sourceStart, this.sourceEnd);
    }

    public Statement statement(List<Statement> stmtList) {
        if (stmtList.isEmpty()) {
            return this.emptyStatement();
        }
        if (stmtList.size() == 1) {
            return stmtList.get(0);
        }
        Statement[] stmtArray = new Statement[stmtList.size()];
        stmtList.toArray(stmtArray);
        return this.block(stmtArray);
    }

    public ForeachStatement foreach(LocalDeclaration variable, Expression collection, Statement body) {
        ForeachStatement foreach = new ForeachStatement(variable, this.sourceStart);
        foreach.collection = collection;
        foreach.action = body;
        if (this.sourceLevel < 0x310000L) {
            foreach.markRaw();
        }
        return foreach;
    }

    public TryStatement tryFinally(Statement[] tryStatements, Statement[] finallyStatements) {
        int len;
        TryStatement stat = new TryStatement();
        stat.sourceStart = this.sourceStart;
        stat.sourceEnd = this.sourceEnd;
        stat.tryBlock = this.block(tryStatements);
        stat.finallyBlock = this.block(finallyStatements);
        if (finallyStatements != null && (len = finallyStatements.length) > 0) {
            stat.finallyBlock.sourceStart = finallyStatements[0].sourceStart;
            stat.finallyBlock.sourceEnd = finallyStatements[len - 1].sourceEnd;
        }
        return stat;
    }

    public TryStatement tryCatch(Statement[] tryStatements, Argument exceptionArgument, Statement[] catchStatements) {
        TryStatement stat = new TryStatement();
        stat.sourceStart = this.sourceStart;
        stat.sourceEnd = this.sourceEnd;
        stat.tryBlock = this.block(tryStatements);
        stat.catchArguments = new Argument[]{exceptionArgument};
        stat.catchBlocks = new Block[]{this.block(catchStatements)};
        return stat;
    }

    public TryStatement tryCatch(Statement[] tryStatements, Argument[] exceptionArguments, Statement[][] catchStatementss) {
        TryStatement stat = new TryStatement();
        stat.sourceStart = this.sourceStart;
        stat.sourceEnd = this.sourceEnd;
        stat.tryBlock = this.block(tryStatements);
        stat.catchArguments = exceptionArguments;
        stat.catchBlocks = new Block[catchStatementss.length];
        int i = 0;
        while (i < catchStatementss.length) {
            stat.catchBlocks[i] = this.block(catchStatementss[i]);
            ++i;
        }
        return stat;
    }

    public TryStatement tryStatement(Statement[] tryStatements, Argument[] exceptionArguments, Statement[][] catchStatementss, Statement[] finallyStatements) {
        int len;
        TryStatement stat = new TryStatement();
        stat.sourceStart = this.sourceStart;
        stat.sourceEnd = this.sourceEnd;
        stat.tryBlock = this.block(tryStatements);
        stat.catchArguments = exceptionArguments;
        stat.catchBlocks = new Block[catchStatementss.length];
        int i = 0;
        while (i < catchStatementss.length) {
            stat.catchBlocks[i] = this.block(catchStatementss[i]);
            ++i;
        }
        stat.finallyBlock = this.block(finallyStatements);
        if (finallyStatements != null && (len = finallyStatements.length) > 0) {
            stat.finallyBlock.sourceStart = finallyStatements[0].sourceStart;
            stat.finallyBlock.sourceEnd = finallyStatements[len - 1].sourceEnd;
        }
        return stat;
    }

    public Expression potentialLift(Expression receiver, Expression expression, TypeBinding expectedType, boolean reversible) {
        if (expectedType.leafComponentType().isBaseType()) {
            return expression;
        }
        ReferenceBinding expectedRef = (ReferenceBinding)expectedType.leafComponentType();
        ReferenceBinding teamBinding = expectedRef.enclosingType();
        if (teamBinding == null || !teamBinding.isTeam()) {
            return expression;
        }
        if (receiver == null) {
            receiver = new QualifiedThisReference(this.typeReference(teamBinding), this.sourceStart, this.sourceEnd);
        }
        PotentialLiftExpression lifter = new PotentialLiftExpression(receiver, expression, expectedType);
        lifter.requireReverseOperation = reversible;
        return lifter;
    }

    public ThisReference thisReference() {
        return new ThisReference(this.sourceStart, this.sourceEnd);
    }

    public SuperReference superReference() {
        return new SuperReference(this.sourceStart, this.sourceEnd);
    }

    public ThisReference tsuperReference() {
        return new TsuperReference(this.sourceStart, this.sourceEnd);
    }

    public Reference qualifiedThisReference(ReferenceBinding binding) {
        return new QualifiedThisReference(this.typeReference(binding), this.sourceStart, this.sourceEnd);
    }

    public Expression qualifiedThisReference(TypeReference reference) {
        return new QualifiedThisReference(reference, this.sourceStart, this.sourceEnd);
    }

    public Statement emptyStatement() {
        return new EmptyStatement(this.sourceStart, this.sourceEnd){

            @Override
            public void resolve(BlockScope scope) {
            }
        };
    }

    public MessageSend println(String msg) {
        return this.messageSend(new QualifiedNameReference(new char[][]{"System".toCharArray(), "out".toCharArray()}, new long[]{this.pos, this.pos}, this.sourceStart, this.sourceEnd), "println".toCharArray(), new Expression[]{this.stringLiteral(msg.toCharArray())});
    }

    public MessageSend println(String msg, Expression expr) {
        return this.messageSend(new QualifiedNameReference(new char[][]{"System".toCharArray(), "out".toCharArray()}, new long[]{this.pos, this.pos}, this.sourceStart, this.sourceEnd), "println".toCharArray(), new Expression[]{new BinaryExpression(this.stringLiteral(msg.toCharArray()), expr, 14)});
    }

    public QualifiedTypeReference getCacheTypeReference(Scope scope, RoleModel boundRootRole) {
        if (scope.compilerOptions().sourceLevel >= 0x310000L) {
            ReferenceBinding baseTypeBinding = boundRootRole.getBaseTypeBinding();
            if (baseTypeBinding == null) {
                baseTypeBinding = scope.getJavaLangObject();
            }
            ReferenceBinding rootRoleBinding = boundRootRole.getInterfacePartBinding();
            TypeReference[] typeArguments = new TypeReference[]{this.baseclassReference(baseTypeBinding, true), this.singleTypeReference(rootRoleBinding.sourceName())};
            ParameterizedQualifiedTypeReference fieldTypeRef = (ParameterizedQualifiedTypeReference)this.parameterizedQualifiedTypeReference(WEAK_HASH_MAP, typeArguments);
            return fieldTypeRef;
        }
        return new QualifiedTypeReference(WEAK_HASH_MAP, new long[]{this.pos, this.pos, this.pos});
    }

    public MessageSend createBoxing(Expression resultExpr, BaseTypeBinding type) {
        char[][] boxedType = AstGenerator.boxTypeName(type);
        return this.messageSend(this.qualifiedTypeReference(boxedType), TypeConstants.VALUEOF, new Expression[]{resultExpr});
    }

    public static char[][] boxTypeName(BaseTypeBinding type) {
        switch (type.id) {
            case 3: {
                return TypeConstants.JAVA_LANG_BYTE;
            }
            case 5: {
                return TypeConstants.JAVA_LANG_BOOLEAN;
            }
            case 10: {
                return TypeConstants.JAVA_LANG_INTEGER;
            }
            case 4: {
                return TypeConstants.JAVA_LANG_SHORT;
            }
            case 7: {
                return TypeConstants.JAVA_LANG_LONG;
            }
            case 8: {
                return TypeConstants.JAVA_LANG_DOUBLE;
            }
            case 9: {
                return TypeConstants.JAVA_LANG_FLOAT;
            }
            case 2: {
                return TypeConstants.JAVA_LANG_CHARACTER;
            }
        }
        throw new InternalCompilerError("trying to box non-primitive type");
    }

    public Expression createUnboxing(Expression expression, BaseTypeBinding basicType) {
        char[][] boxedTypeName = AstGenerator.boxTypeName(basicType);
        char[] selector = CharOperation.concat(basicType.sourceName(), "Value".toCharArray());
        return this.messageSend(this.castExpression(expression, this.qualifiedTypeReference(boxedTypeName), 2), selector, null);
    }

    public Expression createCastOrUnboxing(Expression expression, TypeBinding expectedType, boolean baseAccess) {
        if (expectedType.isBaseType()) {
            return this.createUnboxing(expression, (BaseTypeBinding)expectedType);
        }
        if (baseAccess) {
            return this.castExpression(expression, this.baseclassReference(expectedType), 2);
        }
        return this.castExpression(expression, this.typeReference(expectedType), 2);
    }

    public Expression createCastOrUnboxing(Expression expression, TypeBinding expectedType, Scope originalScope) {
        if (expectedType.isBaseType()) {
            return this.createUnboxing(expression, (BaseTypeBinding)expectedType);
        }
        return this.castExpression(expression, this.alienScopeTypeReference(this.typeReference(expectedType), originalScope), 2);
    }

    public CalloutMappingDeclaration calloutMappingDeclaration(CompilationResult compilationResult) {
        CalloutMappingDeclaration result = new CalloutMappingDeclaration(compilationResult);
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        return result;
    }

    public MethodSpec methodSpec(char[] selector) {
        return new MethodSpec(selector, this.sourceStart, this.sourceEnd);
    }

    public FieldAccessSpec fieldAccessSpec(char[] fieldName, TypeBinding type, boolean isSetter) {
        return new FieldAccessSpec(fieldName, this.typeReference(type), this.pos, isSetter ? 138 : 137);
    }

    public ArrayReference arrayReference(Expression expression, int index) {
        return this.setPos(new ArrayReference(expression, this.intLiteral(index)));
    }

    public ArrayReference arrayReference(Expression expression, Expression indexExpression) {
        return this.setPos(new ArrayReference(expression, indexExpression));
    }

    public EqualExpression equalExpression(Expression left, Expression right, int operator) {
        return this.setPos(new EqualExpression(left, right, operator));
    }

    public <E extends Expression> E setPos(E e) {
        e.sourceStart = this.sourceStart;
        e.sourceEnd = this.sourceEnd;
        e.statementEnd = this.sourceEnd;
        return e;
    }

    public SingleMemberAnnotation singleMemberAnnotation(char[][] compoundName, Expression memberValue) {
        SingleMemberAnnotation result = new SingleMemberAnnotation(this.qualifiedTypeReference(compoundName), this.sourceStart);
        result.sourceEnd = this.sourceEnd;
        result.declarationSourceEnd = this.sourceEnd;
        result.memberValue = memberValue;
        return result;
    }

    public SingleMemberAnnotation singleStringsMemberAnnotation(char[][] compoundName, char[][] memberValues) {
        SingleMemberAnnotation result = new SingleMemberAnnotation(this.qualifiedTypeReference(compoundName), this.sourceStart);
        result.sourceEnd = this.sourceEnd;
        result.declarationSourceEnd = this.sourceEnd;
        ArrayInitializer arrayInitializer = new ArrayInitializer();
        arrayInitializer.expressions = new Expression[memberValues.length];
        int i = 0;
        while (i < memberValues.length) {
            arrayInitializer.expressions[i] = this.stringLiteral(memberValues[i]);
            ++i;
        }
        result.memberValue = arrayInitializer;
        return result;
    }

    public NormalAnnotation normalAnnotation(char[][] compoundName, char[][] names, Expression[] values) {
        assert (names.length == values.length) : "names and values must have same length";
        NormalAnnotation result = new NormalAnnotation(this.qualifiedTypeReference(compoundName), this.sourceStart);
        result.sourceEnd = this.sourceEnd;
        result.declarationSourceEnd = this.sourceEnd;
        MemberValuePair[] pairs = new MemberValuePair[names.length];
        int i = 0;
        while (i < names.length) {
            pairs[i] = new MemberValuePair(names[i], this.sourceStart, this.sourceEnd, values[i]);
            ++i;
        }
        result.memberValuePairs = pairs;
        return result;
    }

    public MarkerAnnotation markerAnnotation(char[][] compoundName) {
        return new MarkerAnnotation(this.qualifiedTypeReference(compoundName), this.sourceStart);
    }

    public void addNonNullAnnotation(Argument argument, LookupEnvironment environment) {
        this.addNullAnnotation(argument, environment, true);
    }

    public void addNullAnnotation(Argument argument, LookupEnvironment environment, boolean nonNull) {
        CompilerOptions compilerOptions = environment.globalOptions;
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            char[][] annotationName;
            char[][] cArray = annotationName = nonNull ? environment.getNonNullAnnotationName() : environment.getNullableAnnotationName();
            if (compilerOptions.sourceLevel < 0x340000L) {
                argument.annotations = new Annotation[]{this.markerAnnotation(annotationName)};
            } else {
                int levels = argument.type.getAnnotatableLevels();
                argument.type.annotations = new Annotation[levels][];
                argument.type.annotations[levels - 1] = new Annotation[]{this.markerAnnotation(annotationName)};
            }
        }
    }

    public TypeReference alienScopeTypeReference(TypeReference original, Scope origScope) {
        TypeReference result;
        if (original instanceof IAlienScopeTypeReference) {
            origScope = ((IAlienScopeTypeReference)((Object)original)).getAlienScope();
        }
        if (original instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference pstRef = (ParameterizedSingleTypeReference)original;
            TypeReference[] typeArguments = AstClone.copyTypeArguments(original, this.pos, pstRef.typeArguments);
            result = new AlienScopeParameterizedSingleTypeReference(pstRef.token, typeArguments, pstRef.dimensions, this.pos, origScope);
        } else if (original instanceof SingleTypeReference) {
            if (original instanceof ArrayTypeReference && original.dimensions() > 0) {
                ArrayTypeReference singleTypeRef = (ArrayTypeReference)original;
                result = new AlienScopeArrayTypeReference(singleTypeRef.token, this.pos, singleTypeRef.dimensions, origScope);
            } else {
                SingleTypeReference singleTypeRef = (SingleTypeReference)original;
                result = new AlienScopeSingleTypeReference(singleTypeRef.token, this.pos, origScope);
            }
        } else if (original instanceof QualifiedTypeReference) {
            if (original instanceof ArrayQualifiedTypeReference && original.dimensions() > 0) {
                ArrayQualifiedTypeReference qTypeRef = (ArrayQualifiedTypeReference)original;
                result = new AlienScopeArrayQualifiedTypeReference(qTypeRef.tokens, qTypeRef.sourcePositions, qTypeRef.dimensions(), origScope);
            } else if (original instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference qTypeRef = (ParameterizedQualifiedTypeReference)original;
                result = new AlienScopeParameterizedQualifiedTypeReference(qTypeRef, origScope);
            } else {
                QualifiedTypeReference qTypeRef = (QualifiedTypeReference)original;
                result = new AlienScopeQualifiedTypeReference(qTypeRef.tokens, qTypeRef.sourcePositions, origScope);
            }
        } else {
            throw new InternalCompilerError("Unexpected type reference: " + original);
        }
        result.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        result.bits |= 0x40000000;
        return result;
    }

    public static interface IRunInScope {
        public void run(BlockScope var1);
    }
}

