/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.PrecedenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class PrecedenceDeclaration
extends ASTNode {
    public boolean isAfter;
    public NameReference[] bindingNames;
    public int declarationSourceStart;
    public PrecedenceBinding binding;

    public PrecedenceDeclaration(int start, int end, boolean isAfter, NameReference[] bindingNames) {
        this.isAfter = isAfter;
        this.bindingNames = bindingNames;
        this.sourceStart = bindingNames[0].sourceStart;
        this.sourceEnd = end;
        this.declarationSourceStart = start;
    }

    public PrecedenceBinding resolve(TypeDeclaration type) {
        int i = 0;
        while (i < this.bindingNames.length) {
            block11: {
                char[] token;
                NameReference name = this.bindingNames[i];
                ReferenceBinding enclosing = type.binding;
                if (name instanceof SingleNameReference) {
                    SingleNameReference sref = (SingleNameReference)name;
                    token = sref.token;
                    sref.binding = this.findCallinInType(type.scope, type.binding, sref.token, true);
                } else {
                    assert (name instanceof QualifiedNameReference);
                    QualifiedNameReference qref = (QualifiedNameReference)name;
                    int j = 0;
                    while (j < qref.tokens.length - 1) {
                        char[] roleName = qref.tokens[j];
                        if (!(enclosing = type.scope.getMemberType(roleName, enclosing)).isValidBinding()) {
                            type.scope.problemReporter().invalidType(name, enclosing);
                            break block11;
                        }
                        ++j;
                    }
                    token = qref.tokens[qref.tokens.length - 1];
                    qref.binding = this.findCallinInType(type.scope, enclosing, token, false);
                }
                if (name.binding == null) {
                    type.scope.problemReporter().callinBindingNotFound(name, token, enclosing);
                    char[] missingName = CharOperation.concat("missingCallin:".toCharArray(), token);
                    name.binding = new CallinCalloutBinding((ReferenceBinding)type.binding, missingName);
                } else if (name.binding instanceof CallinCalloutBinding) {
                    boolean bindingIsAfter;
                    CallinCalloutBinding callinBinding = (CallinCalloutBinding)name.binding;
                    boolean bl = bindingIsAfter = callinBinding.callinModifier == 135;
                    if (bindingIsAfter != this.isAfter) {
                        type.scope.problemReporter().mismatchingAfterInPrecedence(name, this.isAfter);
                    }
                }
            }
            ++i;
        }
        PrecedenceDeclaration.checkOverriding(this.bindingNames, type.scope);
        this.binding = new PrecedenceBinding((ReferenceBinding)type.binding, this.bindingNames);
        if (type.enclosingType != null && type.enclosingType.isTeam()) {
            type.enclosingType.addResolvedPrecedence(type.binding.sourceName(), this.binding);
        }
        return this.binding;
    }

    private static void checkOverriding(NameReference[] bindingNames, Scope scope) {
        int i = 1;
        while (i < bindingNames.length) {
            NameReference ref_i = bindingNames[i];
            if (ref_i.binding != null && ref_i.binding.kind() == 32768) {
                int j = 0;
                while (j < i) {
                    NameReference ref_j = bindingNames[j];
                    if (ref_j.binding != null && ref_j.binding.kind() == 32768) {
                        CallinCalloutBinding callin_i = (CallinCalloutBinding)ref_i.binding;
                        CallinCalloutBinding callin_j = (CallinCalloutBinding)ref_j.binding;
                        if (CharOperation.equals(callin_i.name, callin_j.name)) {
                            ReferenceBinding role_i = callin_i._declaringRoleClass;
                            ReferenceBinding role_j = callin_j._declaringRoleClass;
                            if (role_i.isCompatibleWith(role_j)) {
                                scope.problemReporter().precedenceForOverriding(ref_i, ref_j);
                            }
                            if (role_j.isCompatibleWith(role_i)) {
                                scope.problemReporter().precedenceForOverriding(ref_j, ref_i);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private Binding findCallinInType(Scope scope, ReferenceBinding type, char[] name, boolean typeAllowed) {
        CallinCalloutBinding found;
        if (type.isRole() && (found = PrecedenceDeclaration.findCallinInRole(type, name)) != null) {
            return found;
        }
        if ((type = type.getRealClass()).isTeam()) {
            ReferenceBinding roleBinding = type.getMemberType(name);
            if (roleBinding != null) {
                if (!typeAllowed) {
                    scope.problemReporter().illegalDeepRoleReferenceInPrecedence(this, type, roleBinding);
                    return new ProblemReferenceBinding(name, 2, roleBinding);
                }
                return roleBinding;
            }
            return null;
        }
        if (type.isRole()) {
            return null;
        }
        scope.problemReporter().illegalEnclosingForCallinName(this, type, name);
        return null;
    }

    private static CallinCalloutBinding findCallinInRole(ReferenceBinding type, char[] name) {
        assert (type.isRole());
        RoleModel roleModel = type.roleModel;
        ReferenceBinding current = type = roleModel.getClassPartBinding();
        while (current != null && current.isRole()) {
            if (current.callinCallouts != null) {
                int i = 0;
                while (i < current.callinCallouts.length) {
                    CallinCalloutBinding mapping = current.callinCallouts[i];
                    if (mapping.type == 1 && CharOperation.equals(name, mapping.name)) {
                        return mapping;
                    }
                    ++i;
                }
            }
            current = current.superclass();
        }
        ReferenceBinding[] tsupers = roleModel.getTSuperRoleBindings();
        int i = tsupers.length - 1;
        while (i >= 0) {
            CallinCalloutBinding callinBinding = PrecedenceDeclaration.findCallinInRole(tsupers[i], name);
            if (callinBinding != null) {
                CallinCalloutBinding result = new CallinCalloutBinding(type, name);
                type.addCallinCallouts(new CallinCalloutBinding[]{result});
                return result;
            }
            --i;
        }
        return null;
    }

    public static PrecedenceBinding[] mergePrecedences(TypeDeclaration type) {
        int j;
        int lenSuper;
        int len = type.binding.precedences != null ? type.binding.precedences.length : 0;
        ReferenceBinding superTeam = type.binding.superclass();
        int n = lenSuper = superTeam != null ? superTeam.precedences.length : 0;
        if (len + lenSuper == 0) {
            return PrecedenceBinding.NoPrecedences;
        }
        PrecedenceBinding[] precedences = new PrecedenceBinding[len + lenSuper];
        int i = 0;
        while (i < len) {
            precedences[i] = type.binding.precedences[i];
            ++i;
        }
        if (superTeam != null) {
            i = 0;
            while (i < lenSuper) {
                precedences[len + i] = PrecedenceDeclaration.strengthenPrecendence(type, superTeam.precedences[i]);
                ++i;
            }
        }
        int count = precedences.length;
        int i2 = 0;
        while (i2 < precedences.length - 1) {
            if (precedences[i2] != null) {
                j = i2 + 1;
                while (j < precedences.length) {
                    if (precedences[j] != null && precedences[i2].hasCommonBaseMethod(precedences[j])) {
                        CallinCalloutBinding[] p2;
                        LinkedList<CallinCalloutBinding> merged = new LinkedList<CallinCalloutBinding>();
                        CallinCalloutBinding[] p1 = precedences[i2].callins(false);
                        if (PrecedenceDeclaration.c3Merge(p1, p1.length - 1, p2 = precedences[j].callins(false), p2.length - 1, merged)) {
                            precedences[i2] = new PrecedenceBinding(merged);
                            precedences[j] = null;
                            --count;
                        } else if (i2 < len) {
                            type.scope.problemReporter().incompatiblePrecedenceLists(PrecedenceDeclaration.findPrecedenceSource(precedences[i2], precedences[j], type), type, precedences[i2], precedences[j]);
                        } else {
                            throw new InternalCompilerError("Incompatible inherited precedence lists");
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (count < precedences.length) {
            PrecedenceBinding[] newPrecs = new PrecedenceBinding[count];
            j = 0;
            int i3 = 0;
            while (i3 < precedences.length) {
                if (precedences[i3] != null) {
                    newPrecs[j++] = precedences[i3];
                }
                ++i3;
            }
            precedences = newPrecs;
        }
        return precedences;
    }

    private static ASTNode findPrecedenceSource(PrecedenceBinding prec1, PrecedenceBinding prec2, TypeDeclaration type) {
        if (type.precedences != null) {
            int i = 0;
            while (i < type.precedences.length) {
                if (type.precedences[i].binding == prec1 || type.precedences[i].binding == prec2) {
                    return type.precedences[i];
                }
                ++i;
            }
        }
        return type;
    }

    private static PrecedenceBinding strengthenPrecendence(TypeDeclaration site, PrecedenceBinding precedenceBinding) {
        CallinCalloutBinding[] superCallins = precedenceBinding.callins(false);
        CallinCalloutBinding[] callins = new CallinCalloutBinding[superCallins.length];
        int i = 0;
        while (i < callins.length) {
            ReferenceBinding roleType = (ReferenceBinding)TeamModel.strengthenRoleType(site.binding, superCallins[i]._declaringRoleClass);
            callins[i] = PrecedenceDeclaration.findCallinInRole(roleType, superCallins[i].name);
            ++i;
        }
        return new PrecedenceBinding((ReferenceBinding)site.binding, callins);
    }

    private static boolean c3Merge(CallinCalloutBinding[] p1, int i1, CallinCalloutBinding[] p2, int i2, LinkedList<CallinCalloutBinding> result) {
        if (i1 < 0 && i2 < 0) {
            return true;
        }
        if (i2 >= 0 && !PrecedenceDeclaration.containsCallinBinding(p2[i2], p1, i1)) {
            result.addFirst(p2[i2]);
            return PrecedenceDeclaration.c3Merge(p1, i1, p2, i2 - 1, result);
        }
        if (i1 >= 0 && !PrecedenceDeclaration.containsCallinBinding(p1[i1], p2, i2)) {
            result.addFirst(p1[i1]);
            return PrecedenceDeclaration.c3Merge(p1, i1 - 1, p2, i2, result);
        }
        if (p1[i1] == p2[i2]) {
            result.addFirst(p1[i1]);
            return PrecedenceDeclaration.c3Merge(p1, i1 - 1, p2, i2 - 1, result);
        }
        return false;
    }

    private static boolean containsCallinBinding(Binding binding, CallinCalloutBinding[] callins, int last) {
        int i = last;
        while (i >= 0) {
            if (callins[i] == binding) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        PrecedenceDeclaration.printIndent(indent, output);
        output.append("precedence ");
        if (this.isAfter) {
            output.append("after ");
        }
        int i = 0;
        while (i < this.bindingNames.length) {
            this.bindingNames[i].print(indent, output);
            output.append(i == this.bindingNames.length - 1 ? (char)';' : ',');
            ++i;
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.bindingNames != null) {
            int len = this.bindingNames.length;
            int i = 0;
            while (i < len) {
                this.bindingNames[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

