/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class MethodBindingOperator
extends ASTNode {
    public static final int KIND_CALLOUT = 1;
    public static final int KIND_CALLOUT_OVERRIDE = 2;
    public static final int KIND_CALLIN = 3;
    public static final SimplePropertyDescriptor BINDING_KIND_PROPERTY = new SimplePropertyDescriptor(MethodBindingOperator.class, "bindingKind", Integer.TYPE, true);
    public static final ChildPropertyDescriptor BINDING_MODIFIER_PROPERTY = new ChildPropertyDescriptor(MethodBindingOperator.class, "bindingModifier", Modifier.class, false, false);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private int bindingKind = 0;
    private int bindingModifierFlag = 0;
    private Modifier bindingModifier;

    static {
        ArrayList propertyList = new ArrayList(1);
        MethodBindingOperator.createPropertyList(MethodBindingOperator.class, propertyList);
        MethodBindingOperator.addProperty(BINDING_KIND_PROPERTY, propertyList);
        MethodBindingOperator.addProperty(BINDING_MODIFIER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = MethodBindingOperator.reapPropertyList(propertyList);
        propertyList = new ArrayList(1);
        MethodBindingOperator.createPropertyList(MethodBindingOperator.class, propertyList);
        MethodBindingOperator.addProperty(BINDING_KIND_PROPERTY, propertyList);
        MethodBindingOperator.addProperty(BINDING_MODIFIER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = MethodBindingOperator.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 3) {
            return PROPERTY_DESCRIPTORS_3_0;
        }
        return PROPERTY_DESCRIPTORS_2_0;
    }

    public MethodBindingOperator(AST ast) {
        super(ast);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BINDING_MODIFIER_PROPERTY) {
            if (get) {
                return this.bindingModifier();
            }
            this.setBindingModifier((Modifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == BINDING_KIND_PROPERTY) {
            if (get) {
                return this.getBindingKind();
            }
            this.setBindingKind(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public int getBindingKind() {
        return this.bindingKind;
    }

    public void setBindingKind(int bindingKind) {
        if (bindingKind < 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(BINDING_KIND_PROPERTY);
        this.bindingKind = bindingKind;
        this.postValueChange(BINDING_KIND_PROPERTY);
    }

    public int getBindingModifier() {
        if (this.bindingModifierFlag == 0 && this.bindingModifier != null) {
            this.bindingModifierFlag = this.bindingModifier.getKeyword().toFlagValue();
        }
        return this.bindingModifierFlag;
    }

    public void setBindingModifier(int modifiers) {
        this.setBindingModifier(this.ast.newModifier(Modifier.ModifierKeyword.fromFlagValue(modifiers)));
    }

    public void setBindingModifier(Modifier modifier) {
        ChildPropertyDescriptor propertyDescriptor = BINDING_MODIFIER_PROPERTY;
        Modifier oldModifier = this.bindingModifier;
        this.preReplaceChild(oldModifier, modifier, propertyDescriptor);
        this.bindingModifierFlag = 0;
        this.bindingModifier = modifier;
        this.postReplaceChild(oldModifier, modifier, propertyDescriptor);
    }

    public Modifier bindingModifier() {
        return this.bindingModifier;
    }

    public boolean isCalloutToField() {
        int modifier = this.getBindingModifier();
        return Modifier.isGet(modifier) || Modifier.isSet(modifier);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.bindingModifier);
        }
        visitor.endVisit(this);
    }

    @Override
    ASTNode clone0(AST target) {
        MethodBindingOperator result = new MethodBindingOperator(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setBindingModifier(this.bindingModifier);
        result.setBindingKind(this.bindingKind);
        return result;
    }

    @Override
    int getNodeType0() {
        return 108;
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return MethodBindingOperator.propertyDescriptors(apiLevel);
    }

    @Override
    int memSize() {
        return 0;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        if (!(other instanceof MethodBindingOperator)) {
            return false;
        }
        MethodBindingOperator otherOp = (MethodBindingOperator)other;
        return otherOp.bindingKind == this.bindingKind && otherOp.getBindingModifier() == this.getBindingModifier();
    }

    @Override
    int treeSize() {
        return 0;
    }
}

