/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.otre.jplis.ObjectTeamsTransformer;
import org.eclipse.objectteams.otredyn.bytecode.IRedefineStrategy;
import org.eclipse.objectteams.otredyn.bytecode.RedefineStrategyFactory;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public abstract class DelegatingTransformer {
    @NonNull
    static DelegatingTransformer newTransformer(boolean useDynamicWeaver, OTWeavingHook hook, BundleWiring wiring) {
        if (useDynamicWeaver) {
            return new OTDRETransformer(DelegatingTransformer.getWeavingContext(hook, wiring));
        }
        return new OTRETransformer();
    }

    static ClassLoader getBundleLoader(final Bundle bundle) {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return bundle.loadClass(name);
            }

            @Override
            public URL getResource(String name) {
                return bundle.getResource(name);
            }
        };
    }

    static IWeavingContext getWeavingContext(final OTWeavingHook hook, final BundleWiring bundleWiring) {
        return new IWeavingContext(){

            public boolean isWeavable(String className) {
                String filePattern;
                int lastDot = className.lastIndexOf(46);
                String path = className.substring(0, lastDot).replace('.', '/');
                List entry = bundleWiring.findEntries(path, filePattern = String.valueOf(className.substring(lastDot + 1)) + ".class", 0);
                if (entry == null || entry.isEmpty()) {
                    return false;
                }
                return hook.requiresWeaving(bundleWiring, className, null) != OTWeavingHook.WeavingReason.None;
            }
        };
    }

    public abstract void readOTAttributes(String var1, InputStream var2, String var3, Bundle var4) throws ClassFormatError, IOException;

    public abstract byte[] transform(Bundle var1, String var2, Class<?> var3, ProtectionDomain var4, byte[] var5) throws IllegalClassFormatException;

    public abstract Collection<String> fetchAdaptedBases();

    private static class OTDRETransformer
    extends DelegatingTransformer {
        org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer transformer;

        public OTDRETransformer(IWeavingContext weavingContext) {
            RedefineStrategyFactory.setRedefineStrategy((IRedefineStrategy)new OTEquinoxRedefineStrategy());
            this.transformer = new org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer(weavingContext);
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(className, className.replace('.', '/'), inputStream, OTDRETransformer.getBundleLoader(bundle));
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) {
            return this.transformer.transform(OTDRETransformer.getBundleLoader(bundle), className, className.replace('.', '/'), classBeingRedefined, bytes);
        }
    }

    private static class OTEquinoxRedefineStrategy
    implements IRedefineStrategy {
        private static final String OT_EQUINOX_DEBUG_AGENT = "org.eclipse.objectteams.otdt.internal.debug.adaptor.launching.OTEquinoxDebugAgent";

        private OTEquinoxRedefineStrategy() {
        }

        public void redefine(Class<?> clazz, byte[] bytecode) throws ClassNotFoundException, UnmodifiableClassException {
            ClassDefinition[] arr_cd = new ClassDefinition[]{new ClassDefinition(clazz, bytecode)};
            try {
                OTEquinoxRedefineStrategy.reflectivelyInvoke(arr_cd);
            }
            catch (ClassFormatError | UnmodifiableClassException e) {
                System.err.println("Error redefining " + clazz.getName());
                e.printStackTrace();
                throw e;
            }
        }

        static void reflectivelyInvoke(ClassDefinition[] definitions) throws ClassFormatError, UnmodifiableClassException {
            try {
                Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass(OT_EQUINOX_DEBUG_AGENT);
                Method redefine = agentClass.getMethod("redefine", ClassDefinition[].class);
                redefine.invoke(null, new Object[]{definitions});
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ClassFormatError) {
                    throw (ClassFormatError)cause;
                }
                if (cause instanceof UnmodifiableClassException) {
                    throw (UnmodifiableClassException)cause;
                }
                throw new UnmodifiableClassException(cause.getMessage());
            }
            catch (Throwable t) {
                throw new UnmodifiableClassException(t.getMessage());
            }
        }
    }

    private static class OTRETransformer
    extends DelegatingTransformer {
        ObjectTeamsTransformer transformer = new ObjectTeamsTransformer();

        private OTRETransformer() {
        }

        @Override
        public void readOTAttributes(String className, InputStream inputStream, String fileName, Bundle bundle) throws ClassFormatError, IOException {
            this.transformer.readOTAttributes(inputStream, fileName, (Object)bundle);
        }

        @Override
        public Collection<String> fetchAdaptedBases() {
            return this.transformer.fetchAdaptedBases();
        }

        @Override
        public byte[] transform(Bundle bundle, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transform((Object)bundle, className, classBeingRedefined, protectionDomain, bytes);
        }
    }
}

