/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.search.matching.ReferenceToTeamPackagePattern;

public class OTType
extends OTJavaElement
implements IOTType {
    int flags;

    public OTType(int type, IType correspondingJavaType, IJavaElement parent, int flags) {
        super(type, correspondingJavaType, parent);
        this.flags = flags;
    }

    public OTType(int type, IType correspondingJavaType, IJavaElement parent, int flags, boolean addToParent) {
        super(type, correspondingJavaType, parent, addToParent);
        this.flags = flags;
    }

    @Override
    public boolean isRole() {
        return TypeHelper.isRole(this.flags);
    }

    @Override
    public boolean isTeam() {
        return TypeHelper.isTeam(this.flags);
    }

    @Override
    public IResource getCorrespondingResource() throws JavaModelException {
        IJavaElement javaParent = this.getCorrespondingJavaElement().getParent();
        if (javaParent instanceof ICompilationUnit) {
            return ((ICompilationUnit)javaParent).getCorrespondingResource();
        }
        return null;
    }

    @Override
    public IType[] getInnerTypes() {
        LinkedList<IType> result = new LinkedList<IType>();
        IJavaElement[] children = this.getChildren();
        int idx = 0;
        while (idx < children.length) {
            if (children[idx] instanceof IOTType) {
                result.add((IType)children[idx]);
            }
            ++idx;
        }
        return result.toArray(new IType[result.size()]);
    }

    @Override
    public IType[] getRoleTypes(int which) throws JavaModelException {
        return this.getRoleTypes(which, null);
    }

    @Override
    public IType[] getRoleTypes(int which, String roleName) throws JavaModelException {
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] typesToConsider = null;
        if ((which & 0xC) != 0) {
            ITypeHierarchy hierarchy = ((IType)this.getCorrespondingJavaElement()).newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            typesToConsider = this.getTypesToSearchForRoles(hierarchy, which & 0xC);
        }
        if ((which & 0x10) == 0) {
            int newLen = typesToConsider != null ? typesToConsider.length + 1 : 1;
            IType[] ttc = new IType[newLen];
            ttc[0] = this;
            if (typesToConsider != null) {
                System.arraycopy(typesToConsider, 0, ttc, 1, typesToConsider.length);
            }
            typesToConsider = ttc;
        } else if (typesToConsider == null) {
            throw new IllegalArgumentException("EXCLUDE_SELF without a hierarchy requested");
        }
        typesToConsider = OTType.fixTypesToConsider(typesToConsider);
        if ((which & 2) != 0) {
            result.addAll(this.searchEngineGetRoleFiles(typesToConsider, roleName));
        }
        if ((which & 1) != 0) {
            int i = 0;
            while (i < typesToConsider.length) {
                IType[] roleTypes = typesToConsider[i].getTypes();
                int j = 0;
                while (j < roleTypes.length) {
                    IType currentType = roleTypes[j];
                    if (roleName == null || roleName.equals(currentType.getElementName())) {
                        result.add(currentType);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new IType[result.size()]);
    }

    private IType[] getTypesToSearchForRoles(ITypeHierarchy hierarchy, int which) throws JavaModelException {
        return hierarchy.getAllSuperclasses(this);
    }

    private static IType[] fixTypesToConsider(IType[] typesToConsider) {
        ArrayList<IOTType> result = new ArrayList<IOTType>(typesToConsider.length);
        int i = 0;
        while (i < typesToConsider.length) {
            IOTType role;
            IType type = typesToConsider[i];
            if (!TypeHelper.isOrgObjectTeamsTeam(type) && (role = OTModelManager.getOTElement(type)) != null) {
                result.add(role);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private List<IType> searchEngineGetRoleFiles(IType[] teamsToConsider, String roleName) throws JavaModelException {
        final ArrayList<IType> searchResult = new ArrayList<IType>();
        char[] role = roleName == null ? null : roleName.toCharArray();
        try {
            OTSearchEngine searchEngine = new OTSearchEngine();
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{this.getAncestor(2)});
            SearchRequestor requestor = new SearchRequestor(){

                @Override
                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    searchResult.add((IType)match.getElement());
                }
            };
            int i = 0;
            while (i < teamsToConsider.length) {
                IType currentType = teamsToConsider[i];
                IOTType ottype = OTModelManager.getOTElement(currentType);
                if (ottype != null && ottype.isTeam()) {
                    ReferenceToTeamPackagePattern pattern = new ReferenceToTeamPackagePattern(currentType.getFullyQualifiedName().toCharArray(), role, 8);
                    searchEngine.search(pattern, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
        }
        catch (CoreException exc) {
            throw new JavaModelException(exc);
        }
        return searchResult;
    }

    @Override
    public IType[] getRoleTypes() throws JavaModelException {
        return this.getRoleTypes(3);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public IType getRoleType(String simpleName) {
        if (this.isTeam() && this.exists()) {
            IType roleType = this.getType(simpleName);
            try {
                Object info = ((JavaElement)((Object)roleType)).getElementInfo();
                if (info instanceof SourceTypeElementInfo) {
                    return ((SourceTypeElementInfo)info).getHandle();
                }
                return roleType;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public IType searchRoleType(String simpleName) {
        try {
            List<IType> roleFiles = this.searchEngineGetRoleFiles(new IType[]{this}, simpleName);
            if (roleFiles.size() > 0) {
                return roleFiles.get(0);
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this.getCorrespondingJavaElement()) {
            return true;
        }
        if (!(obj instanceof OTType)) {
            return false;
        }
        OTType other = (OTType)obj;
        return super.equals(other) && this.getFlags() == other.getFlags();
    }

    @Override
    public String toString() {
        return "OTType " + this.getElementName() + " for type: " + this.getCorrespondingJavaElement().toString();
    }

    private IType getIType() {
        return (IType)super.getCorrespondingJavaElement();
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, owner);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, monitor);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, owner, monitor);
    }

    @Override
    public IField createField(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().createField(contents, sibling, force, monitor);
    }

    @Override
    public IInitializer createInitializer(String contents, IJavaElement sibling, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().createInitializer(contents, sibling, monitor);
    }

    @Override
    public IMethod createMethod(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().createMethod(contents, sibling, force, monitor);
    }

    @Override
    public IType createType(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().createType(contents, sibling, force, monitor);
    }

    @Override
    public IMethod[] findMethods(IMethod method) {
        return this.getIType().findMethods(method);
    }

    @Override
    public IField getField(String name) {
        return this.getIType().getField(name);
    }

    @Override
    public IField[] getFields() throws JavaModelException {
        return this.getIType().getFields();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getIType().getFullyQualifiedName();
    }

    @Override
    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        return this.getIType().getFullyQualifiedName(enclosingTypeSeparator);
    }

    @Override
    public IInitializer getInitializer(int occurrenceCount) {
        return this.getIType().getInitializer(occurrenceCount);
    }

    @Override
    public IInitializer[] getInitializers() throws JavaModelException {
        return this.getIType().getInitializers();
    }

    @Override
    public IMethod getMethod(String name, String[] parameterTypeSignatures) {
        return this.getIType().getMethod(name, parameterTypeSignatures);
    }

    @Override
    public IMethod[] getMethods() throws JavaModelException {
        return this.getIType().getMethods();
    }

    @Override
    public IAnnotation getAnnotation(String name) {
        return this.getIType().getAnnotation(name);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        return this.getIType().getAnnotations();
    }

    @Override
    public IPackageFragment getPackageFragment() {
        return this.getIType().getPackageFragment();
    }

    @Override
    public String getSuperclassName() throws JavaModelException {
        return this.getIType().getSuperclassName();
    }

    @Override
    public String getSuperclassTypeSignature() throws JavaModelException {
        return this.getIType().getSuperclassTypeSignature();
    }

    @Override
    public String[] getSuperInterfaceTypeSignatures() throws JavaModelException {
        return this.getIType().getSuperInterfaceTypeSignatures();
    }

    @Override
    public String[] getSuperInterfaceNames() throws JavaModelException {
        return this.getIType().getSuperInterfaceNames();
    }

    @Override
    public String[] getTypeParameterSignatures() throws JavaModelException {
        return this.getIType().getTypeParameterSignatures();
    }

    @Override
    public IType getType(String name) {
        return this.getIType().getType(name);
    }

    @Override
    public String getTypeQualifiedName() {
        return this.getIType().getTypeQualifiedName();
    }

    @Override
    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        return this.getIType().getTypeQualifiedName(enclosingTypeSeparator);
    }

    @Override
    public IType[] getTypes() throws JavaModelException {
        return this.getIType().getTypes();
    }

    @Override
    public boolean isAnonymous() throws JavaModelException {
        return this.getIType().isAnonymous();
    }

    @Override
    public boolean isClass() throws JavaModelException {
        return this.getIType().isClass();
    }

    @Override
    public boolean isEnum() throws JavaModelException {
        return this.getIType().isEnum();
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        return this.getIType().isInterface();
    }

    @Override
    public boolean isAnnotation() throws JavaModelException {
        return this.getIType().isAnnotation();
    }

    @Override
    public boolean isLocal() throws JavaModelException {
        return this.getIType().isLocal();
    }

    @Override
    public boolean isMember() throws JavaModelException {
        return this.getIType().isMember();
    }

    @Override
    public boolean isLambda() {
        return false;
    }

    @Override
    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().loadTypeHierachy(input, monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newSupertypeHierarchy(monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(ICompilationUnit[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newSupertypeHierarchy(workingCopies, monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newSupertypeHierarchy(workingCopies, monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newSupertypeHierarchy(owner, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(project, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IJavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(project, owner, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(ICompilationUnit[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(workingCopies, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(workingCopies, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().newTypeHierarchy(owner, monitor);
    }

    @Override
    public String[][] resolveType(String typeName) throws JavaModelException {
        return this.getIType().resolveType(typeName);
    }

    @Override
    public String[][] resolveType(String typeName, WorkingCopyOwner owner) throws JavaModelException {
        return this.getIType().resolveType(typeName, owner);
    }

    @Override
    public IClassFile getClassFile() {
        return this.getIType().getClassFile();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.getIType().getCompilationUnit();
    }

    @Override
    public ITypeRoot getTypeRoot() {
        return this.getIType().getTypeRoot();
    }

    @Override
    public IType getDeclaringType() {
        return this.getIType().getDeclaringType();
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        return this.getIType().getNameRange();
    }

    @Override
    public IType getType(String name, int occurrenceCount) {
        return this.getIType().getType(name, occurrenceCount);
    }

    @Override
    public boolean isBinary() {
        return this.getIType().isBinary();
    }

    @Override
    public String getSource() throws JavaModelException {
        return this.getIType().getSource();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        return this.getIType().getSourceRange();
    }

    @Override
    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().copy(container, sibling, rename, replace, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().delete(force, monitor);
    }

    @Override
    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().move(container, sibling, rename, replace, monitor);
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIType().rename(name, replace, monitor);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        this.getIType().codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, owner);
    }

    @Override
    public IJavaElement[] getChildrenForCategory(String category) throws JavaModelException {
        return this.getIType().getChildrenForCategory(category);
    }

    @Override
    public String getFullyQualifiedParameterizedName() throws JavaModelException {
        return this.getIType().getFullyQualifiedParameterizedName();
    }

    @Override
    public String getKey() {
        return this.getIType().getKey();
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        return this.getIType().getTypeParameters();
    }

    @Override
    public ITypeParameter getTypeParameter(String name) {
        return this.getIType().getTypeParameter(name);
    }

    @Override
    public boolean isResolved() {
        return this.getIType().isResolved();
    }

    @Override
    public String[] getCategories() throws JavaModelException {
        return this.getIType().getCategories();
    }

    @Override
    public ISourceRange getJavadocRange() throws JavaModelException {
        return this.getIType().getJavadocRange();
    }

    @Override
    public int getOccurrenceCount() {
        return this.getIType().getOccurrenceCount();
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        return this.getIType().getAttachedJavadoc(monitor);
    }

    @Override
    public void close() throws JavaModelException {
        super.close();
        OTModelManager.removeOTElement(this);
    }

    @Override
    protected Object createElementInfo() {
        throw new UnsupportedOperationException("Not yet implemented for OTType");
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        return ((JavaElement)this.getCorrespondingJavaElement()).getHandleFromMemento(token, memento, owner);
    }
}

