/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.Pair;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ClassScanner {
    public static final boolean REPOSITORY_USE_RESOURCE_LOADER = !"off".equals(System.getProperty("otequinox.repository.hook"));
    HashMap<String, ArrayList<String>> baseClassNamesByTeam = new HashMap();
    ArrayList<String> allBaseClassNames = new ArrayList();
    ArrayList<String> roleClassNames = new ArrayList();

    public String readOTAttributes(Bundle bundle, String className, DelegatingTransformer transformer) throws ClassFormatError, IOException, ClassNotFoundException {
        Bundle loader = REPOSITORY_USE_RESOURCE_LOADER ? bundle : null;
        Pair<URL, String> result = TeamLoader.findTeamClassResource(className, bundle);
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        URL classFile = (URL)result.first;
        className = (String)result.second;
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream inputStream = classFile.openStream();){
            transformer.readOTAttributes(className, inputStream, classFile.getFile(), loader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collection<String> currentBaseNames = transformer.fetchAdaptedBases();
        if (currentBaseNames != null) {
            ArrayList<String> basesPerTeam = this.baseClassNamesByTeam.get(className);
            if (basesPerTeam == null) {
                basesPerTeam = new ArrayList();
                this.baseClassNamesByTeam.put(className, basesPerTeam);
            }
            basesPerTeam.addAll(currentBaseNames);
            this.allBaseClassNames.addAll(currentBaseNames);
        }
        this.readMemberTypeAttributes(bundle, className, transformer);
        return className;
    }

    @Nullable
    public Collection<String> getCollectedBaseClassNames(String teamName) {
        return this.baseClassNamesByTeam.remove(teamName);
    }

    public Collection<String> getCollectedBaseClassNames() {
        try {
            ArrayList<String> arrayList = this.allBaseClassNames;
            return arrayList;
        }
        finally {
            this.allBaseClassNames = new ArrayList();
        }
    }

    public Collection<String> getCollectedRoleClassNames() {
        return this.roleClassNames;
    }

    void readMemberTypeAttributes(Bundle bundle, String className, DelegatingTransformer transformer) {
        List roles = CallinBindingManager.getRolePerTeam((String)className);
        if (roles != null) {
            for (String roleName : roles) {
                TransformerPlugin.log(0, "scanning role " + roleName);
                try {
                    this.roleClassNames.add(roleName);
                    this.readOTAttributes(bundle, roleName, transformer);
                }
                catch (Throwable t) {
                    TransformerPlugin.log(t, "Failed to read OT-Attributes of role " + roleName);
                }
                this.readMemberTypeAttributes(bundle, roleName, transformer);
            }
        }
    }
}

