/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Technical University Berlin - extended API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int 
		TokenNameNotAToken = 0,
	    TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	int
      TokenNameIdentifier = 17,
      TokenNameabstract = 54,
      TokenNameassert = 81,
      TokenNameboolean = 108,
      TokenNamebreak = 82,
      TokenNamebyte = 109,
      TokenNamecase = 110,
      TokenNamecatch = 111,
      TokenNamechar = 112,
      TokenNameclass = 70,
      TokenNamecontinue = 83,
      TokenNameconst = 144,
      TokenNamedefault = 78,
      TokenNamedo = 84,
      TokenNamedouble = 113,
      TokenNameelse = 125,
      TokenNameenum = 74,
      TokenNameextends = 93,
      TokenNamefalse = 39,
      TokenNamefinal = 55,
      TokenNamefinally = 121,
      TokenNamefloat = 114,
      TokenNamefor = 85,
      TokenNamegoto = 145,
      TokenNameif = 86,
      TokenNameimplements = 140,
      TokenNameimport = 115,
      TokenNameinstanceof = 18,
      TokenNameint = 116,
      TokenNameinterface = 73,
      TokenNamelong = 117,
      TokenNamenative = 56,
      TokenNamenew = 37,
      TokenNamenull = 40,
      TokenNamepackage = 94,
      TokenNameprivate = 57,
      TokenNameprotected = 58,
      TokenNamepublic = 59,
      TokenNamereturn = 87,
      TokenNameshort = 118,
      TokenNamestatic = 50,
      TokenNamestrictfp = 60,
      TokenNamesuper = 35,
      TokenNameswitch = 88,
      TokenNamesynchronized = 51,
      TokenNamethis = 36,
      TokenNamethrow = 89,
      TokenNamethrows = 126,
      TokenNametransient = 61,
      TokenNametrue = 41,
      TokenNametry = 90,
      TokenNamevoid = 119,
      TokenNamevolatile = 62,
      TokenNamewhile = 80,
      TokenNamemodule = 122,
      TokenNameopen = 123,
      TokenNamerequires = 127,
      TokenNametransitive = 133,
      TokenNameexports = 128,
      TokenNameopens = 129,
      TokenNameto = 141,
      TokenNameuses = 130,
      TokenNameprovides = 131,
      TokenNamewith = 95,
      TokenNameas = 134,
      TokenNamebase = 33,
      TokenNamecallin = 63,
      TokenNameplayedBy = 142,
      TokenNameprecedence = 124,
      TokenNameteam = 53,
      TokenNametsuper = 38,
      TokenNamewhen = 96,
      TokenNamewithin = 91,
      TokenNamereplace = 135,
      TokenNameafter = 132,
      TokenNamebefore = 136,
      TokenNameget = 137,
      TokenNameset = 138,
      TokenNameIntegerLiteral = 42,
      TokenNameLongLiteral = 43,
      TokenNameFloatingPointLiteral = 44,
      TokenNameDoubleLiteral = 45,
      TokenNameCharacterLiteral = 46,
      TokenNameStringLiteral = 47,
      TokenNamePLUS_PLUS = 2,
      TokenNameMINUS_MINUS = 3,
      TokenNameEQUAL_EQUAL = 20,
      TokenNameLESS_EQUAL = 14,
      TokenNameGREATER_EQUAL = 15,
      TokenNameNOT_EQUAL = 21,
      TokenNameLEFT_SHIFT = 19,
      TokenNameRIGHT_SHIFT = 13,
      TokenNameUNSIGNED_RIGHT_SHIFT = 16,
      TokenNamePLUS_EQUAL = 97,
      TokenNameMINUS_EQUAL = 98,
      TokenNameMULTIPLY_EQUAL = 99,
      TokenNameDIVIDE_EQUAL = 100,
      TokenNameAND_EQUAL = 101,
      TokenNameOR_EQUAL = 102,
      TokenNameXOR_EQUAL = 103,
      TokenNameREMAINDER_EQUAL = 104,
      TokenNameLEFT_SHIFT_EQUAL = 105,
      TokenNameRIGHT_SHIFT_EQUAL = 106,
      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 107,
      TokenNameOR_OR = 31,
      TokenNameAND_AND = 30,
      TokenNamePLUS = 4,
      TokenNameMINUS = 5,
      TokenNameNOT = 66,
      TokenNameREMAINDER = 10,
      TokenNameXOR = 26,
      TokenNameAND = 23,
      TokenNameMULTIPLY = 9,
      TokenNameOR = 28,
      TokenNameTWIDDLE = 67,
      TokenNameDIVIDE = 11,
      TokenNameGREATER = 12,
      TokenNameLESS = 8,
      TokenNameLPAREN = 22,
      TokenNameRPAREN = 24,
      TokenNameLBRACE = 52,
      TokenNameRBRACE = 34,
      TokenNameLBRACKET = 6,
      TokenNameRBRACKET = 69,
      TokenNameSEMICOLON = 25,
      TokenNameQUESTION = 29,
      TokenNameCOLON = 65,
      TokenNameCOMMA = 32,
      TokenNameDOT = 1,
      TokenNameEQUAL = 77,
      TokenNameAT = 48,
      TokenNameELLIPSIS = 139,
      TokenNameARROW = 75,
      TokenNameCOLON_COLON = 7,
      TokenNameBeginLambda = 49,
      TokenNameBeginIntersectionCast = 68,
      TokenNameBeginTypeArguments = 79,
      TokenNameElidedSemicolonAndRightBrace = 71,
      TokenNameAT308 = 27,
      TokenNameAT308DOTDOTDOT = 143,
      TokenNameATOT = 120,
      TokenNameBINDIN = 76,
      TokenNameCALLOUT_OVERRIDE = 92,
      TokenNameSYNTHBINDOUT = 72,
      TokenNameEOF = 64,
      TokenNameERROR = 146;


	// This alias is statically inserted by generateOTParser.sh:
	int TokenNameBINDOUT = TokenNameARROW;
}

