/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class BreakStatement
extends Statement {
    public static final ChildPropertyDescriptor LABEL_PROPERTY = new ChildPropertyDescriptor(BreakStatement.class, "label", SimpleName.class, false, false);
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(BreakStatement.class, "expression", Expression.class, false, false);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_12;
    private boolean isImplicit = false;
    private SimpleName optionalLabel = null;
    private Expression optionalExpression = null;

    static {
        ArrayList properyList = new ArrayList(2);
        BreakStatement.createPropertyList(BreakStatement.class, properyList);
        BreakStatement.addProperty(LABEL_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = BreakStatement.reapPropertyList(properyList);
        ArrayList properyList_12 = new ArrayList(2);
        BreakStatement.createPropertyList(BreakStatement.class, properyList_12);
        BreakStatement.addProperty(LABEL_PROPERTY, properyList_12);
        BreakStatement.addProperty(EXPRESSION_PROPERTY, properyList_12);
        PROPERTY_DESCRIPTORS_12 = BreakStatement.reapPropertyList(properyList_12);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public static List propertyDescriptors(int apiLevel, boolean previewEnabled) {
        if (apiLevel == 12 && previewEnabled) {
            return PROPERTY_DESCRIPTORS_12;
        }
        return PROPERTY_DESCRIPTORS;
    }

    BreakStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return BreakStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean isPreviewEnabled) {
        return BreakStatement.propertyDescriptors(apiLevel, isPreviewEnabled);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LABEL_PROPERTY) {
            if (get) {
                return this.getLabel();
            }
            this.setLabel((SimpleName)child);
            return null;
        }
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 10;
    }

    @Override
    ASTNode clone0(AST target) {
        BreakStatement result = new BreakStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setLabel((SimpleName)ASTNode.copySubtree(target, this.getLabel()));
        if (this.isPreviewEnabled()) {
            result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.isPreviewEnabled()) {
                this.acceptChild(visitor, this.getExpression());
            }
            this.acceptChild(visitor, this.getLabel());
        }
        visitor.endVisit(this);
    }

    public SimpleName getLabel() {
        return this.optionalLabel;
    }

    public void setLabel(SimpleName label) {
        SimpleName oldChild = this.optionalLabel;
        this.preReplaceChild(oldChild, label, LABEL_PROPERTY);
        this.optionalLabel = label;
        this.postReplaceChild(oldChild, label, LABEL_PROPERTY);
    }

    public Expression getExpression() {
        this.unsupportedBelow12();
        this.unsupportedWithoutPreviewError();
        return this.optionalExpression;
    }

    public void setExpression(Expression expression) {
        this.unsupportedBelow12();
        this.unsupportedWithoutPreviewError();
        Expression oldChild = this.optionalExpression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.optionalExpression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public boolean isImplicit() {
        this.unsupportedBelow12();
        this.unsupportedWithoutPreviewError();
        return this.isImplicit;
    }

    void setImplicit(boolean isImplicit) {
        this.unsupportedBelow12();
        this.unsupportedWithoutPreviewError();
        this.isImplicit = isImplicit;
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalLabel == null ? 0 : this.getLabel().treeSize()) + (this.optionalExpression == null ? 0 : this.getExpression().treeSize());
    }
}

