/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;

public abstract class OTJavaElement
extends Member
implements IOTJavaElement {
    public static final char OTEM_METHODMAPPING = '\u00a7';
    public static final String METHODMAPPING = Character.toString('\u00a7');
    private int type;
    private List<IJavaElement> children;
    private IJavaElement correspondingJavaElem;

    public OTJavaElement(int type, IJavaElement correspondingJavaElem, IJavaElement parent) {
        this(type, correspondingJavaElem, parent, true);
    }

    public OTJavaElement(int type, IJavaElement correspondingJavaElem, IJavaElement parent, boolean addAsChild) {
        super((JavaElement)parent);
        this.type = type;
        this.correspondingJavaElem = correspondingJavaElem;
        this.children = new ArrayList<IJavaElement>();
        if (addAsChild && parent instanceof OTJavaElement) {
            ((OTJavaElement)parent).addChild(this);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJavaElement[] getChildren() {
        List<IJavaElement> list = this.children;
        synchronized (list) {
            if (this.children.isEmpty() && this.correspondingJavaElem instanceof IType) {
                try {
                    IJavaElement[] iJavaElementArray = ((IType)this.correspondingJavaElem).getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        this.children.add(child);
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return this.children.toArray(new IJavaElement[this.children.size()]);
        }
    }

    public void addChild(IOTJavaElement child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public IJavaElement getParent() {
        IJavaElement result = this.parent;
        if (result == null) {
            result = this.getCorrespondingJavaElement().getParent();
        }
        return result;
    }

    @Override
    public String getElementName() {
        return this.getCorrespondingJavaElement().getElementName();
    }

    @Override
    public int getElementType() {
        return this.type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        OTJavaElement other = (OTJavaElement)obj;
        return this.getParent().equals(other.getParent()) && this.type == other.type && this.getCorrespondingJavaElement().equals(other.getCorrespondingJavaElement());
    }

    @Override
    public int hashCode() {
        IJavaElement myParent = this.getParent();
        if (myParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), myParent.hashCode());
    }

    @Override
    public String toString() {
        return "OTJavaElement " + this.getElementName();
    }

    @Override
    public IJavaElement getCorrespondingJavaElement() {
        return this.correspondingJavaElem;
    }

    @Override
    public OTJavaElement resolved(Binding binding) {
        return this;
    }

    public void setCorrespondingJavaElement(IJavaElement javaElem) {
        this.correspondingJavaElem = javaElem;
    }

    @Override
    public boolean exists() {
        return this.correspondingJavaElem.exists();
    }

    @Override
    public void close() throws JavaModelException {
        super.close();
        ((JavaElement)this.correspondingJavaElem).close();
    }

    @Override
    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return this.correspondingJavaElem.getAncestor(ancestorType);
    }

    @Override
    public IResource getCorrespondingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    @Override
    public String getHandleIdentifier() {
        return this.correspondingJavaElem.getHandleIdentifier();
    }

    @Override
    public IJavaModel getJavaModel() {
        return this.correspondingJavaElem.getJavaModel();
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.correspondingJavaElem.getJavaProject();
    }

    @Override
    public IOpenable getOpenable() {
        return this.correspondingJavaElem.getOpenable();
    }

    @Override
    public IPath getPath() {
        return this.correspondingJavaElem.getPath();
    }

    @Override
    public IJavaElement getPrimaryElement() {
        return this.correspondingJavaElem.getPrimaryElement();
    }

    @Override
    public IResource getResource() {
        return this.correspondingJavaElem.getResource();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.correspondingJavaElem.getSchedulingRule();
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        return this.correspondingJavaElem.getUnderlyingResource();
    }

    @Override
    public boolean isReadOnly() {
        return this.correspondingJavaElem.isReadOnly();
    }

    @Override
    public boolean isStructureKnown() throws JavaModelException {
        return this.correspondingJavaElem.isStructureKnown();
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = super.getAdapter(adapter);
        if (result == null) {
            result = this.correspondingJavaElem.getAdapter(adapter);
        }
        return (T)result;
    }

    @Override
    public void toString(int tab, StringBuffer buffer) {
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        buffer.append(this.toString());
    }
}

