/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.WeakHashSet;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.core.OTTypeMapping;

public class OTModel {
    private static OTModel _singleton;
    private OTTypeMapping data = new OTTypeMapping();
    private WeakHashSet unopenedTypes = new WeakHashSet();

    protected OTModel() {
    }

    public static OTModel getSharedInstance() {
        if (_singleton == null) {
            _singleton = new OTModel();
        }
        return _singleton;
    }

    public static void dispose() {
        _singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnopenedType(IType type) {
        WeakHashSet weakHashSet = this.unopenedTypes;
        synchronized (weakHashSet) {
            this.unopenedTypes.add(type);
        }
    }

    public void addOTElement(IOTType otType) {
        if (otType != null) {
            this.data.put((IType)otType.getCorrespondingJavaElement(), otType);
        }
    }

    public boolean hasOTElementFor(IType type) {
        return this.data.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOTType getOTElement(IType type) {
        IOTType result = this.data.get(type);
        if (result != null) {
            return result;
        }
        if (type != null && type.isBinary()) {
            boolean found = false;
            WeakHashSet weakHashSet = this.unopenedTypes;
            synchronized (weakHashSet) {
                found = this.unopenedTypes.remove(type) != null;
            }
            if (found) {
                try {
                    return OTModelManager.getSharedInstance().addType(type, type.getFlags(), null, null, false);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void removeOTElement(IType type, boolean hasChanged) {
        if (type != null && this.data.contains(type)) {
            if (hasChanged) {
                this.data.removeChangedElement(type);
            } else {
                this.data.remove(type);
            }
        }
    }
}

