/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.select;

import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SelectionOnExplicitConstructorCall
extends ExplicitConstructorCall {
    static final int Base = 5;

    public SelectionOnExplicitConstructorCall(int accessMode) {
        super(accessMode);
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        SelectionOnExplicitConstructorCall.printIndent(tab, output);
        output.append("<SelectOnExplicitConstructorCall:");
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else if (this.accessMode == 4) {
            output.append("tsuper(");
        } else if (this.accessMode == 5) {
            output.append("base(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(")>;");
    }

    @Override
    public void resolve(BlockScope scope) {
        super.resolve(scope);
        if (this.binding == null || !this.binding.isValidBinding() && this.binding.problemId() != 2) {
            throw new SelectionNodeFound();
        }
        if (this.accessMode == 5) {
            ReferenceBinding declaringRole = this.binding.declaringClass;
            if (declaringRole == null || declaringRole.baseclass() == null) {
                throw new SelectionNodeFound();
            }
            MethodBinding baseBinding = declaringRole.baseclass().getExactConstructor(this.binding.parameters);
            throw new SelectionNodeFound(baseBinding);
        }
        throw new SelectionNodeFound(this.binding);
    }
}

