/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialRoleReceiverExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PrivateRoleMethodCall;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTDynCallinBindingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.MethodMappingImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.PredicateGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReplaceResultReferenceVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.TeamMethodGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class CallinImplementorDyn
extends MethodMappingImplementor {
    static final char[] ROLE_VAR_NAME = CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, IOTConstants.ROLE);
    public static final char[] OT_CALL_BEFORE = "_OT$callBefore".toCharArray();
    public static final char[] OT_CALL_AFTER = "_OT$callAfter".toCharArray();
    public static final char[] OT_CALL_REPLACE = "_OT$callReplace".toCharArray();
    public static final char[] OT_CALL_NEXT = "_OT$callNext".toCharArray();
    public static final char[] OT_CALL_ORIG_STATIC = "_OT$callOrigStatic".toCharArray();
    private static final char[] OT_TERMINAL_CALL_NEXT = "_OT$terminalCallNext".toCharArray();
    static final char[] TEAMS = "teams".toCharArray();
    static final char[] INDEX = "index".toCharArray();
    static final char[] CALLIN_ID = "callinID".toCharArray();
    static final char[] BOUND_METHOD_ID = "boundMethodID".toCharArray();
    static final char[] ARGUMENTS = "arguments".toCharArray();
    static final char[] _OT_RESULT = "_OT$result".toCharArray();
    static final char[] RESULT = "result".toCharArray();
    static final String LOCAL_ROLE = "local$role$";
    static final char[] _BASE$ = "_base$".toCharArray();
    private static final char[] BASE_CALL_ARGS = "baseCallArguments".toCharArray();
    private static final char[] BASE_CALL_FLAGS = "baseCallFlags".toCharArray();
    static final char[][] REPLACE_ARG_NAMES = new char[][]{_BASE$, TEAMS, INDEX, CALLIN_ID, BOUND_METHOD_ID, ARGUMENTS};
    static final char[][] BEFORE_ARG_NAMES = new char[][]{_BASE$, CALLIN_ID, BOUND_METHOD_ID, ARGUMENTS};
    static final char[][] AFTER_ARG_NAMES = new char[][]{_BASE$, CALLIN_ID, BOUND_METHOD_ID, ARGUMENTS, _OT_RESULT};
    protected static final String OT_LOCAL = "_OT$local$";
    static final char[] CATCH_ARG = "_OT$caughtException".toCharArray();
    private ClassScope _roleScope;

    public void transformRole(RoleModel role) {
        this._role = role;
        this._roleScope = role.getAst().scope;
        this.bindingDirection = 79;
        AbstractMethodMappingDeclaration[] methodMappings = this._role.getAst().callinCallouts;
        if (methodMappings == null || methodMappings.length == 0) {
            return;
        }
        if (this._role._hasBindingAmbiguity) {
            int i = 0;
            while (i < methodMappings.length) {
                this._roleScope.problemReporter().callinDespiteLiftingProblem(this._role.getBinding(), 141003, methodMappings[i]);
                ++i;
            }
        }
        CallinMappingDeclaration[] callinMappings = new CallinMappingDeclaration[methodMappings.length];
        int num = 0;
        int idx = 0;
        while (idx < methodMappings.length) {
            AbstractMethodMappingDeclaration methodMapping = methodMappings[idx];
            if (!methodMapping.ignoreFurtherInvestigation && methodMapping.isCallin()) {
                callinMappings[num++] = (CallinMappingDeclaration)methodMapping;
            }
            ++idx;
        }
        CallinMappingDeclaration[] callinMappingDeclarationArray = callinMappings;
        callinMappings = new CallinMappingDeclaration[num];
        System.arraycopy(callinMappingDeclarationArray, 0, callinMappings, 0, num);
        OTDynCallinBindingsAttribute.createOrMerge(this._role.getTeamModel(), this._role.getBaseTypeBinding().getRealClass().constantPoolName(), callinMappings);
    }

    Expression getArgument(CallinMappingDeclaration methodMapping, MethodDeclaration wrapperDeclaration, TypeBinding[] implParameters, int idx, final MethodSpec sourceMethodSpec, char[] roleVar) {
        final MethodSpec implementationMethodSpec = methodMapping.getImplementationMethodSpec();
        Expression mappedArgExpr = null;
        int pos = -1;
        char[] targetArgName = null;
        int generatedArgsLen = methodMapping.isReplaceCallin() ? MethodSignatureEnhancer.getEnhancingArgLen(CompilerOptions.WeavingScheme.OTDRE) : 0;
        final int srcIdx = idx - generatedArgsLen;
        targetArgName = implementationMethodSpec.arguments[srcIdx].name;
        Pair mapper = methodMapping.mappingExpressions[srcIdx];
        mappedArgExpr = (Expression)mapper.first;
        if (mapper.second != null) {
            pos = (Integer)mapper.second;
        }
        if (mappedArgExpr != null) {
            if (methodMapping.baseMethodSpecs.length > 1) {
                mappedArgExpr = this.copyExpression(mappedArgExpr, methodMapping.scope, methodMapping.compilationResult.getCompilationUnit());
            }
            SourceTypeBinding roleType = methodMapping.scope.enclosingSourceType();
            if (idx >= implParameters.length) {
                return mappedArgExpr;
            }
            TypeBinding expectedType = implParameters[idx];
            if (expectedType.isRole() && TypeBinding.notEquals(expectedType.enclosingType(), roleType.enclosingType())) {
                expectedType = TeamModel.strengthenRoleType(roleType, expectedType);
            }
            AstGenerator gen = new AstGenerator(mappedArgExpr.sourceStart, mappedArgExpr.sourceEnd);
            SingleNameReference receiver = null;
            if (RoleTypeBinding.isRoleWithoutExplicitAnchor(expectedType) && TypeBinding.equalsEquals(roleType.getRealClass(), ((ReferenceBinding)expectedType).enclosingType())) {
                receiver = gen.singleNameReference(roleVar);
            }
            if (sourceMethodSpec.hasSignature) {
                if (sourceMethodSpec.argNeedsTranslation(srcIdx)) {
                    mappedArgExpr.tagReportedBaseclassDecapsulation();
                    return Lifting.liftCall(methodMapping.scope, receiver != null ? receiver : ThisReference.implicitThis(), mappedArgExpr, sourceMethodSpec.resolvedParameters()[srcIdx], expectedType, methodMapping.isReplaceCallin());
                }
                if (methodMapping.mappings == null) {
                    return mappedArgExpr;
                }
            }
            Expression liftExpr = gen.potentialLift(receiver, mappedArgExpr, expectedType, methodMapping.isReplaceCallin());
            if (methodMapping.mappings != null && pos != -1 && liftExpr instanceof PotentialLiftExpression) {
                final int srcPos = pos;
                ((PotentialLiftExpression)liftExpr).onLiftingRequired(new Runnable(){

                    @Override
                    public void run() {
                        sourceMethodSpec.argNeedsTranslation[srcPos] = true;
                        implementationMethodSpec.argNeedsTranslation[srcIdx] = true;
                    }
                });
            }
            return liftExpr;
        }
        wrapperDeclaration.scope.problemReporter().unmappedParameter(targetArgName, implementationMethodSpec, methodMapping.isCallout());
        return null;
    }

    Expression copyExpression(Expression expression, Scope scope, ICompilationUnit cu) {
        if (cu == null) {
            return expression;
        }
        Parser parser = new Parser(scope.problemReporter(), false);
        char[] source = cu.getContents();
        return parser.parseExpression(source, expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1, scope.referenceCompilationUnit(), false);
    }

    public void transformTeam(TeamModel aTeam) {
        ArrayList<CallinMappingDeclaration> beforeMappings = new ArrayList<CallinMappingDeclaration>();
        ArrayList<CallinMappingDeclaration> replaceMappings = new ArrayList<CallinMappingDeclaration>();
        ArrayList<CallinMappingDeclaration> afterMappings = new ArrayList<CallinMappingDeclaration>();
        ArrayList<CallinMappingDeclaration> mappingsWithStaticBase = new ArrayList<CallinMappingDeclaration>();
        RoleModel[] roleModelArray = aTeam.getRoles(false);
        int n = roleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleModel role = roleModelArray[n2];
            TypeDeclaration roleDecl = role.getAst();
            if (roleDecl != null && roleDecl.callinCallouts != null) {
                AbstractMethodMappingDeclaration[] abstractMethodMappingDeclarationArray = roleDecl.callinCallouts;
                int n3 = roleDecl.callinCallouts.length;
                int n4 = 0;
                while (n4 < n3) {
                    AbstractMethodMappingDeclaration mappingDecl = abstractMethodMappingDeclarationArray[n4];
                    if (mappingDecl.isCallin()) {
                        CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)mappingDecl;
                        if (!callinDecl.isOverriddenInTeam) {
                            switch (callinDecl.callinModifier) {
                                case 139: {
                                    beforeMappings.add(callinDecl);
                                    break;
                                }
                                case 135: {
                                    afterMappings.add(callinDecl);
                                    break;
                                }
                                case 138: {
                                    replaceMappings.add(callinDecl);
                                }
                            }
                            if (callinDecl.hasStaticBaseMethod()) {
                                mappingsWithStaticBase.add(callinDecl);
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (beforeMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_BEFORE, false, false, beforeMappings, aTeam);
        }
        if (afterMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_AFTER, false, true, afterMappings, aTeam);
        }
        if (replaceMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_REPLACE, true, false, replaceMappings, aTeam);
            this.generateCallNext(replaceMappings, aTeam);
        }
        if (!mappingsWithStaticBase.isEmpty()) {
            this.generateCallOrigStatic(mappingsWithStaticBase, aTeam);
        }
    }

    private void generateDispatchMethod(char[] methodName, final boolean isReplace, final boolean isAfter, final List<CallinMappingDeclaration> callinDecls, final TeamModel aTeam) {
        final TypeDeclaration teamDecl = aTeam.getAst();
        if (teamDecl == null) {
            return;
        }
        final AstGenerator gen = new AstGenerator(teamDecl);
        gen.replaceableEnclosingClass = teamDecl.binding;
        int length = 4;
        if (isReplace) {
            length = 6;
        } else if (isAfter) {
            length = 5;
        }
        Argument[] arguments = new Argument[length];
        int a = 0;
        arguments[a++] = gen.argument(_BASE$, gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2));
        if (isReplace) {
            arguments[a++] = gen.argument(TEAMS, gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1));
        }
        if (isReplace) {
            arguments[a++] = gen.argument(INDEX, gen.typeReference(TypeBinding.INT));
        }
        arguments[a++] = isReplace ? gen.argument(CALLIN_ID, gen.createArrayTypeReference(TypeBinding.INT, 1)) : gen.argument(CALLIN_ID, gen.typeReference(TypeBinding.INT));
        arguments[a++] = gen.argument(BOUND_METHOD_ID, gen.typeReference(TypeBinding.INT));
        arguments[a++] = gen.argument(ARGUMENTS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1));
        if (isAfter) {
            arguments[a++] = gen.argument(_OT_RESULT, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT));
        }
        TypeReference returnTypeRef = isReplace ? gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT) : gen.typeReference(TypeBinding.VOID);
        final MethodDeclaration callMethod = gen.method(teamDecl.compilationResult, 1, returnTypeRef, methodName, arguments);
        callMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLIN;
        AstEdit.addMethod(teamDecl, callMethod);
        MethodModel.addCallinFlag(callMethod, 2);
        callMethod.model._declaringMappings = callinDecls;
        MethodModel.getModel(callMethod).setStatementsGenerator(new AbstractStatementsGenerator(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            protected boolean generateStatements(AbstractMethodDeclaration methodDecl) {
                teamDecl.getTeamModel().getLineNumberProvider().addLineInfo(teamDecl.binding, 65534, -1);
                teamDecl.getTeamModel().getLineNumberProvider().addLineInfo(teamDecl.binding, 65533, -1);
                stepOverGen = new AstGenerator(0x7FFFFFFD, 0);
                stepIntoGen = new AstGenerator(0x7FFFFFFC, 0);
                stepOverGen.replaceableEnclosingClass = teamDecl.binding;
                stepIntoGen.replaceableEnclosingClass = teamDecl.binding;
                tryStats = new ArrayList<SwitchStatement>();
                switchStat = new SwitchStatement();
                switchStat.expression = isReplace != false ? gen.arrayReference((Expression)gen.singleNameReference(CallinImplementorDyn.CALLIN_ID), gen.singleNameReference(CallinImplementorDyn.INDEX)) : gen.singleNameReference(CallinImplementorDyn.CALLIN_ID);
                statements = new ArrayList<Statement>();
                for (CallinMappingDeclaration callinDecl : callinDecls) {
                    var12_18 = callinDecl.baseMethodSpecs;
                    var11_16 = callinDecl.baseMethodSpecs.length;
                    var10_12 = 0;
                    while (var10_12 < var11_16) {
                        baseSpec = var12_18[var10_12];
                        baseSpec.getCallinId(aTeam, callinDecl.explicitName());
                        ++var10_12;
                    }
                }
                callinIdCount = teamDecl.getTeamModel().getCallinIdCount();
                handledCallinIds = new boolean[callinIdCount];
                canLiftingFail = false;
                for (CallinMappingDeclaration callinDecl : callinDecls) {
                    if (callinDecl.ignoreFurtherInvestigation) continue;
                    roleDecl = callinDecl.scope.referenceType();
                    if (roleDecl.ignoreFurtherInvestigation || RoleModel.isRoleWithBaseProblem(roleDecl) || !callinDecl.hasParsedParamMappings) continue;
                    callinGen = new AstGenerator(callinDecl);
                    callinGen.replaceableEnclosingClass = teamDecl.binding;
                    var17_31 = callinDecl.baseMethodSpecs;
                    var16_29 = callinDecl.baseMethodSpecs.length;
                    var15_24 = 0;
                    while (var15_24 < var16_29) {
                        baseSpec = var17_31[var15_24];
                        callinID = baseSpec.getCallinId(aTeam, callinDecl.name);
                        statements.add(callinGen.caseStatement(callinGen.intLiteral(callinID)));
                        handledCallinIds[callinID] = true;
                        predGen = new PredicateGenerator(callinDecl.binding._declaringRoleClass, callinDecl.isReplaceCallin());
                        baseReturn = baseSpec.resolvedType();
                        isStaticRoleMethod = callinDecl.getRoleMethod().isStatic();
                        roleType = callinDecl.scope.enclosingSourceType();
                        if (roleType.isGenericType()) {
                            roleType = (ReferenceBinding)callinDecl.scope.environment().convertToRawType(roleType, false);
                        }
                        roleMethodBinding = callinDecl.getRoleMethod();
                        needLiftedRoleVar = isStaticRoleMethod == false && roleType.isCompatibleWith(roleMethodBinding.declaringClass) != false;
                        blockStatements = new ArrayList<Statement>();
                        resultName = null;
                        if (callinDecl.callinModifier == 135 && (callinDecl.mappings != null || callinDecl.predicate != null) && baseReturn != TypeBinding.VOID) {
                            resultName = CallinImplementorDyn.RESULT;
                            callinDecl.resultVar = callinGen.localBaseVariable(CallinImplementorDyn.RESULT, baseReturn, callinGen.createCastOrUnboxing((Expression)callinGen.singleNameReference(CallinImplementorDyn._OT_RESULT), baseReturn, true));
                            blockStatements.add(callinDecl.resultVar);
                        }
                        blockStatements.add(callinGen.localVariable(IOTConstants.BASE, callinGen.alienScopeTypeReference(callinGen.baseTypeReference(roleType.baseclass()), callinDecl.scope), (Expression)callinGen.castExpression(callinGen.baseNameReference(CallinImplementorDyn._BASE$), callinGen.alienScopeTypeReference(callinGen.baseTypeReference(roleType.baseclass()), callinDecl.scope), 2)));
                        hasBasePredicate = false;
                        var31_48 = callinDecl.baseMethodSpecs;
                        var30_45 = callinDecl.baseMethodSpecs.length;
                        var29_44 = 0;
                        while (var29_44 < var30_45) {
                            baseMethodSpec = var31_48[var29_44];
                            resultName2 = null;
                            if (callinDecl.callinModifier == 135 && baseMethodSpec.resolvedType() != TypeBinding.VOID) {
                                resultName2 = IOTConstants.RESULT;
                            }
                            if ((predicateCheck = predGen.createBasePredicateCheck(callinDecl, baseMethodSpec, resultName2, stepIntoGen)) != null) {
                                blockStatements.add(predicateCheck);
                                hasBasePredicate = true;
                            }
                            ++var29_44;
                        }
                        blockStatements.add(callinGen.assignment(callinGen.singleNameReference(CallinImplementor.OLD_IS_EXECUTING), stepOverGen.messageSend(stepOverGen.thisReference(), IOTConstants.SET_EXECUTING_CALLIN, new Expression[]{stepOverGen.booleanLiteral(true)})));
                        roleVar = null;
                        if (!isStaticRoleMethod) {
                            if (needLiftedRoleVar) {
                                canLiftingFail |= CallinImplementorDyn.this.checkLiftingProblem(teamDecl, callinDecl, roleType);
                                roleVar = ("local$role$" + statements.size()).toCharArray();
                                roleTypeReference = callinGen.roleTypeReference(teamDecl.getTeamModel().getTThis(), roleType, 0);
                                blockStatements.add(callinGen.localVariable(roleVar, callinGen.alienScopeTypeReference(roleTypeReference, callinDecl.scope), 16, Lifting.liftCall(callMethod.scope, callinGen.thisReference(), callinGen.baseNameReference(IOTConstants.BASE), callMethod.scope.getType(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2, 3), roleType, false, callinGen)));
                                receiver /* !! */  = callinGen.thislikeNameReference(roleVar);
                            } else {
                                receiver /* !! */  = callinGen.qualifiedThisReference(TeamModel.strengthenEnclosing(teamDecl.binding, roleMethodBinding.declaringClass));
                            }
                        } else {
                            receiver /* !! */  = callinGen.singleNameReference(callinDecl.getRoleMethod().declaringClass.sourceName());
                        }
                        baseArgOffset = 0;
                        if (baseSpec.isCallin()) {
                            baseArgOffset += MethodSignatureEnhancer.getEnhancingArgLen(CompilerOptions.WeavingScheme.OTDRE);
                        }
                        if (baseSpec.isStatic() && baseSpec.getDeclaringClass().isRole()) {
                            baseArgOffset += 2;
                        }
                        if (callinDecl.mappings != null || hasBasePredicate && baseSpec.arguments != null) {
                            baseParams = baseSpec.resolvedParameters();
                            i = 0;
                            while (i < baseSpec.arguments.length) {
                                baseArg = baseSpec.arguments[i];
                                init /* !! */  = rawArg = callinGen.arrayReference((Expression)callinGen.singleNameReference(CallinImplementorDyn.ARGUMENTS), i + baseArgOffset);
                                if (!baseParams[i].isTypeVariable()) {
                                    init /* !! */  = callinGen.createCastOrUnboxing((Expression)rawArg, baseParams[i], callinDecl.scope);
                                }
                                baseArgLocal = callinGen.localVariable(baseArg.name, callinGen.alienScopeTypeReference(baseArg.type, callinDecl.scope), (Expression)init /* !! */ );
                                baseArgLocal.modifiers |= baseArg.modifiers & 16;
                                if (hasBasePredicate) {
                                    blockStatements.add(i, baseArgLocal);
                                } else {
                                    baseArgLocal.initialization = new PotentialRoleReceiverExpression(init /* !! */ , roleVar, callinGen.typeReference(roleType));
                                    blockStatements.add(baseArgLocal);
                                }
                                ++i;
                            }
                        }
                        roleParams = callinDecl.roleMethodSpec.resolvedParameters();
                        callArgs = new Expression[roleParams.length + (isReplace != false ? MethodSignatureEnhancer.getEnhancingArgLen(CompilerOptions.WeavingScheme.OTDRE) : 0)];
                        idx = 0;
                        if (isReplace) {
                            var37_62 = CallinImplementorDyn.REPLACE_ARG_NAMES;
                            baseArgLocal = CallinImplementorDyn.REPLACE_ARG_NAMES.length;
                            init = 0;
                            while (init < baseArgLocal) {
                                argName = var37_62[init];
                                callArgs[idx++] = callinGen.singleNameReference(argName);
                                ++init;
                            }
                        }
                        callinDecl.traverse((ASTVisitor)new ReplaceResultReferenceVisitor(callinDecl), callinDecl.scope.classScope());
                        hasArgError = false;
                        i = 0;
                        while (i < roleParams.length) {
                            block66: {
                                roleParam = roleParams[i];
                                if (roleParam.isTypeVariable()) {
                                    tvb = (TypeVariableBinding)roleParam;
                                    if (tvb.declaringElement instanceof MethodBinding && TypeBinding.equalsEquals(((MethodBinding)tvb.declaringElement).declaringClass, roleType)) {
                                        roleParam = roleParam.erasure();
                                    }
                                }
                                localTypeRef = null;
                                if (callinDecl.mappings != null) break block66;
                                arg /* !! */  = callinGen.arrayReference((Expression)callinGen.singleNameReference(CallinImplementorDyn.ARGUMENTS), i + baseArgOffset);
                                baseArgType = baseSpec.resolvedParameters()[i];
                                if (roleParam.isBaseType()) {
                                    arg /* !! */  = callinGen.createUnboxing(arg /* !! */ , (BaseTypeBinding)roleParam);
                                } else if (baseArgType.isBaseType()) {
                                    arg /* !! */  = callinGen.castExpression(arg /* !! */ , callinGen.qualifiedTypeReference(AstGenerator.boxTypeName((BaseTypeBinding)baseArgType)), 2);
                                } else {
                                    baseclass = roleType.baseclass();
                                    if (baseclass instanceof DependentTypeBinding && baseArgType instanceof ReferenceBinding) {
                                        baseArgType = RoleTypeCreator.maybeInstantiateFromPlayedBy(callinDecl.scope, (ReferenceBinding)baseArgType);
                                    }
                                    arg /* !! */  = callinGen.castExpression(arg /* !! */ , callinGen.alienScopeTypeReference(callinGen.typeReference(baseArgType), callinDecl.scope), 0);
                                    if (!roleParam.leafComponentType().isBaseType() && PotentialLiftExpression.isLiftingRequired(callinDecl.scope, roleParam, baseArgType, arg /* !! */ )) {
                                        liftReceiver = null;
                                        if (roleType.isTeam() && TypeBinding.equalsEquals(roleParam.enclosingType(), roleType)) {
                                            liftReceiver = callinGen.singleNameReference(roleVar);
                                        }
                                        arg /* !! */  = callinGen.potentialLift(liftReceiver, arg /* !! */ , roleParam, isReplace);
                                        localTypeRef = callinGen.typeReference(roleParam);
                                        canLiftingFail |= CallinImplementorDyn.this.checkLiftingProblem(teamDecl, callinDecl, (ReferenceBinding)roleParam.leafComponentType());
                                    }
                                }
                                if (localTypeRef == null) {
                                    localTypeRef = callinGen.baseclassReference(baseArgType);
                                }
                                ** GOTO lbl170
                            }
                            localTypeRef = roleParam.isTypeVariable() != false && ((TypeVariableBinding)roleParam).declaringElement instanceof CallinCalloutBinding != false ? callinGen.typeReference(roleParam.erasure()) : callinGen.typeReference(roleParam);
                            arg /* !! */  = CallinImplementorDyn.this.getArgument(callinDecl, (MethodDeclaration)methodDecl, callinDecl.getRoleMethod().parameters, i + idx, baseSpec, roleVar);
                            if (arg /* !! */  == null) {
                                hasArgError = true;
                            } else {
                                if (Lifting.isLiftToMethodCall(arg /* !! */ )) {
                                    canLiftingFail |= CallinImplementorDyn.this.checkLiftingProblem(teamDecl, callinDecl, roleType);
                                }
                                v0 = isBaseReference = arg /* !! */  instanceof SingleNameReference != false && CharOperation.equals(((SingleNameReference)arg /* !! */ ).token, IOTConstants.BASE) != false;
                                if (needLiftedRoleVar) {
                                    arg /* !! */  = new PotentialRoleReceiverExpression(arg /* !! */ , roleVar, callinGen.typeReference(roleType.getRealClass()));
                                }
                                if (isBaseReference) {
                                    arg /* !! */  = callinGen.castExpression(arg /* !! */ , callinGen.typeReference(roleParam), 2);
                                }
lbl170:
                                // 4 sources

                                localName = ("_OT$local$" + i).toCharArray();
                                blockStatements.add(callinGen.localVariable(localName, callinGen.alienScopeTypeReference(localTypeRef, callinDecl.scope), (Expression)arg /* !! */ ));
                                callArgs[i + idx] = callinGen.singleNameReference(localName);
                            }
                            ++i;
                        }
                        if (!hasArgError) {
                            predicateArgs = isReplace != false ? MethodSignatureEnhancer.retrenchBasecallArguments(callArgs, true, CompilerOptions.WeavingScheme.OTDRE) : callArgs;
                            predicateArgs = CallinImplementorDyn.this.maybeAddResultReference(callinDecl, predicateArgs, resultName, callinGen);
                            rolePredicateCheck = predGen.createPredicateCheck(callinDecl, callinDecl.scope.referenceType(), receiver /* !! */ , predicateArgs, callArgs, stepIntoGen);
                            if (rolePredicateCheck != null) {
                                blockStatements.add(rolePredicateCheck);
                            }
                            lhsResolvesToTeamMethod = TypeBinding.equalsEquals(callinDecl.getRoleMethod().declaringClass, roleType.enclosingType());
                            roleMethodCall /* !! */  = callinDecl.getRoleMethod().isPrivate() != false && lhsResolvesToTeamMethod == false ? new PrivateRoleMethodCall(receiver /* !! */ , callinDecl.roleMethodSpec.selector, callArgs, false, callinDecl.scope, roleType, callinDecl.getRoleMethod(), callinGen) : callinGen.messageSend(receiver /* !! */ , callinDecl.roleMethodSpec.selector, callArgs);
                            roleMethodCall /* !! */ .isGenerated = true;
                            roleMethodCall /* !! */ .isPushedOutRoleMethodCall = true;
                            if (isReplace) {
                                result /* !! */  = roleMethodCall /* !! */ ;
                                if (baseSpec.returnNeedsTranslation) {
                                    returnTypes = CallinImplementorDyn.this.getReturnTypes(callinDecl, 0);
                                    lowerReceiver = CallinImplementorDyn.this.isRoleOfCurrentRole(roleType, returnTypes[0]) != false ? stepOverGen.singleNameReference(roleVar) : CallinImplementorDyn.this.genTeamThis(stepOverGen, returnTypes[0]);
                                    result /* !! */  = new Lowering().lowerExpression(methodDecl.scope, result /* !! */ , returnTypes[0], returnTypes[1], lowerReceiver, true, true);
                                }
                                callinDecl.checkResultMapping();
                                v1 = isResultBoxed = baseReturn.isBaseType() != false && baseReturn != TypeBinding.VOID;
                                if (callinDecl.mappings != null && callinDecl.isResultMapped) {
                                    if (isResultBoxed) {
                                        result /* !! */  = callinGen.createUnboxing(result /* !! */ , (BaseTypeBinding)baseReturn);
                                    }
                                    mappedResult = callinDecl.getResultExpression(baseSpec, isResultBoxed, callinGen);
                                    if (!isStaticRoleMethod) {
                                        mappedResult = new PotentialRoleReceiverExpression(mappedResult, roleVar, callinGen.typeReference(roleType.getRealClass()));
                                    }
                                    v2 = new Statement[2];
                                    callinDecl.resultVar = callinGen.localVariable(IOTConstants.RESULT, baseReturn, (Expression)callinGen.castExpression(result /* !! */ , callinGen.typeReference(baseReturn), 2));
                                    v2[0] = callinDecl.resultVar;
                                    v2[1] = callinGen.returnStatement(mappedResult);
                                    messageSendStatements = v2;
                                } else {
                                    messageSendStatements = isResultBoxed ? new Statement[]{callinGen.localVariable(IOTConstants.OT_RESULT, callinGen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), (Expression)result /* !! */ ), CallinImplementor.genResultNotProvidedCheck(teamDecl.binding.readableName(), roleType.readableName(), roleMethodBinding, roleType.baseclass(), baseSpec, callinGen), callinGen.returnStatement(callinGen.singleNameReference(IOTConstants.OT_RESULT))} : new Statement[]{callinGen.returnStatement(result /* !! */ )};
                                }
                            } else {
                                messageSendStatements = new Statement[]{roleMethodCall /* !! */ , callinGen.breakStatement()};
                            }
                            blockStatements.add(CallinImplementorDyn.this.protectRoleMethodCall(messageSendStatements, roleMethodBinding, stepIntoGen));
                            statements.add(callinGen.block(blockStatements.toArray(new Statement[blockStatements.size()])));
                            if (canLiftingFail && callinDecl.rolesWithLiftingProblem != null) {
                                for (Map.Entry<ReferenceBinding, Integer> entry : callinDecl.rolesWithLiftingProblem.entrySet()) {
                                    callinDecl.scope.problemReporter().callinDespiteLiftingProblem(entry.getKey(), entry.getValue(), callinDecl);
                                }
                            }
                        }
                        ++var15_24;
                    }
                }
                needSuperCall = false;
                superTeam = aTeam.getBinding().superclass();
                if (superTeam != null && superTeam.isTeam() && superTeam.id != 101) {
                    i = 0;
                    while (i < callinIdCount) {
                        if (!handledCallinIds[i]) {
                            statements.add(gen.caseStatement(gen.intLiteral(i)));
                            needSuperCall = true;
                        }
                        ++i;
                    }
                    if (!isReplace) {
                        needSuperCall = true;
                    }
                }
                if (needSuperCall) {
                    if (!isReplace) {
                        statements.add(gen.caseStatement(null));
                    }
                    if (isReplace) {
                        selector = CallinImplementorDyn.OT_CALL_REPLACE;
                        argNames = CallinImplementorDyn.REPLACE_ARG_NAMES;
                    } else if (isAfter) {
                        selector = CallinImplementorDyn.OT_CALL_AFTER;
                        argNames = CallinImplementorDyn.AFTER_ARG_NAMES;
                    } else {
                        selector = CallinImplementorDyn.OT_CALL_BEFORE;
                        argNames = CallinImplementorDyn.BEFORE_ARG_NAMES;
                    }
                    superCallArgs = new Expression[argNames.length];
                    idx = 0;
                    while (idx < argNames.length) {
                        superCallArgs[idx] = gen.singleNameReference(argNames[idx]);
                        ++idx;
                    }
                    v3 = superCall = aTeam.hasTSuperTeamMethod(selector) != false ? stepIntoGen.tsuperMessageSend(stepIntoGen.thisReference(), selector, superCallArgs) : stepIntoGen.messageSend(stepIntoGen.superReference(), selector, superCallArgs);
                    if (isReplace) {
                        statements.add(gen.returnStatement(superCall));
                    } else {
                        statements.add(superCall);
                    }
                }
                catchStatement1 = gen.emptyStatement();
                catchStatement2 = gen.emptyStatement();
                if (isReplace) {
                    callArgs = new Expression[CallinImplementorDyn.REPLACE_ARG_NAMES.length + 2];
                    idx = 0;
                    while (idx < CallinImplementorDyn.REPLACE_ARG_NAMES.length) {
                        callArgs[idx] = gen.singleNameReference(CallinImplementorDyn.REPLACE_ARG_NAMES[idx]);
                        ++idx;
                    }
                    callArgs[callArgs.length - 2] = gen.nullLiteral();
                    callArgs[callArgs.length - 1] = gen.intLiteral(0);
                    statements.add(gen.caseStatement(null));
                    statements.add(gen.returnStatement(stepIntoGen.messageSend(stepIntoGen.qualifiedThisReference(aTeam.getBinding()), CallinImplementorDyn.OT_CALL_NEXT, callArgs)));
                    catchStatement1 = gen.returnStatement(stepIntoGen.messageSend(stepIntoGen.qualifiedThisReference(aTeam.getBinding()), CallinImplementorDyn.OT_CALL_NEXT, callArgs));
                    catchStatement2 = gen.returnStatement(stepIntoGen.messageSend(stepIntoGen.qualifiedThisReference(aTeam.getBinding()), CallinImplementorDyn.OT_CALL_NEXT, callArgs));
                }
                switchStat.statements = statements.toArray(new Statement[statements.size()]);
                if (canLiftingFail) {
                    exceptionArguments = new Argument[]{gen.argument("ex".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_LIFTING_VETO)), gen.argument("ex".toCharArray(), gen.qualifiedTypeReference(IOTConstants.O_O_LIFTING_FAILED_EXCEPTION))};
                    exceptionStatementss = new Statement[][]{{catchStatement1}, {catchStatement2}};
                } else {
                    exceptionArguments = new Argument[]{gen.argument("ex".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_LIFTING_VETO))};
                    exceptionStatementss = new Statement[][]{{catchStatement1}};
                }
                tryStats.add(switchStat);
                flagVariable = gen.localVariable(CallinImplementor.OLD_IS_EXECUTING, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_BOOLEAN), (Expression)gen.nullLiteral());
                resetFlag = gen.ifStatement(gen.nonNullCheck(gen.singleNameReference(CallinImplementor.OLD_IS_EXECUTING)), stepOverGen.messageSend(stepOverGen.thisReference(), IOTConstants.SET_EXECUTING_CALLIN, new Expression[]{stepOverGen.singleNameReference(CallinImplementor.OLD_IS_EXECUTING)}));
                methodDecl.statements = new Statement[]{flagVariable, gen.tryStatement(tryStats.toArray(new Statement[tryStats.size()]), exceptionArguments, exceptionStatementss, new Statement[]{resetFlag})};
                methodDecl.hasParsedStatements = true;
                return true;
            }
        });
    }

    Expression[] maybeAddResultReference(CallinMappingDeclaration callinBindingDeclaration, Expression[] messageSendArguments, char[] resultName, AstGenerator gen) {
        Expression[] predicateArgs = null;
        if (callinBindingDeclaration.hasSignature) {
            predicateArgs = messageSendArguments;
            if (resultName != null) {
                int l = messageSendArguments.length;
                predicateArgs = new Expression[l + 1];
                System.arraycopy(messageSendArguments, 0, predicateArgs, 0, l);
                predicateArgs[l] = gen.baseNameReference(resultName);
            }
        }
        return predicateArgs;
    }

    private void generateCallNext(List<CallinMappingDeclaration> callinDecls, TeamModel aTeam) {
        TypeDeclaration teamDecl = aTeam.getAst();
        if (teamDecl == null) {
            return;
        }
        AstGenerator gen = new AstGenerator(teamDecl);
        Argument[] args = new Argument[]{gen.argument(IOTConstants.BASE, gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2)), gen.argument(TEAMS, gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1)), gen.argument(INDEX, gen.typeReference(TypeBinding.INT)), gen.argument(CALLIN_ID, gen.createArrayTypeReference(TypeBinding.INT, 1)), gen.argument(BOUND_METHOD_ID, gen.typeReference(TypeBinding.INT)), gen.argument(ARGUMENTS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument(BASE_CALL_ARGS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument(BASE_CALL_FLAGS, gen.typeReference(TypeBinding.INT))};
        Expression[] superArgs = new Expression[args.length];
        int i = 0;
        while (i < args.length) {
            superArgs[i] = gen.singleNameReference(args[i].name);
            ++i;
        }
        MethodDeclaration decl = gen.method(teamDecl.compilationResult, 1, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), OT_CALL_NEXT, args);
        SwitchStatement swStat = new SwitchStatement();
        swStat.expression = gen.arrayReference((Expression)gen.singleNameReference(CALLIN_ID), gen.singleNameReference(INDEX));
        ArrayList swStatements = new ArrayList();
        char[] resultVar = RESULT;
        for (CallinMappingDeclaration mapping : callinDecls) {
            int nLabels = 0;
            MethodSpec[] methodSpecArray = mapping.baseMethodSpecs;
            int n = mapping.baseMethodSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                MethodSpec baseSpec = methodSpecArray[n2];
                ArrayList<Statement> caseBlockStats = new ArrayList<Statement>();
                int callinId = baseSpec.getCallinId(aTeam, mapping.explicitName());
                caseBlockStats.add(gen.caseStatement(gen.intLiteral(callinId)));
                int nRoleArgs = mapping.getRoleMethod().getSourceParamLength();
                TypeBinding[] roleParams = mapping.getRoleMethod().getSourceParameters();
                int i2 = 0;
                while (i2 < roleParams.length) {
                    if (roleParams[i2].isRole() && TeamModel.isTeamContainingRole(teamDecl.binding, (ReferenceBinding)roleParams[i2])) {
                        roleParams[i2] = TeamModel.strengthenRoleType(teamDecl.binding, roleParams[i2]);
                    }
                    ++i2;
                }
                ArrayList<Assignment> repackingStats = new ArrayList<Assignment>();
                if (mapping.positions != null) {
                    int[] poss = mapping.positions;
                    nLabels = caseBlockStats.size();
                    int argOffset = 0;
                    if (baseSpec.isCallin()) {
                        argOffset += 6;
                    }
                    if (baseSpec.isStatic() && baseSpec.getDeclaringClass().isRole()) {
                        argOffset += 2;
                    }
                    int i3 = 0;
                    while (i3 < poss.length) {
                        if (poss[i3] > 0) {
                            TypeBinding roleSideParameter = roleParams[i3];
                            TypeBinding baseSideParameter = baseSpec.resolvedParameters()[poss[i3] - 1];
                            Expression roleSideArgument = gen.arrayReference((Expression)gen.singleNameReference(BASE_CALL_ARGS), i3);
                            if (TypeBinding.notEquals(roleSideParameter, baseSideParameter)) {
                                roleSideArgument = gen.resolvedCastExpression(roleSideArgument, roleSideParameter, 2);
                            }
                            TypeBinding roleSideLeaf = roleSideParameter.leafComponentType();
                            TypeBinding baseSideLeaf = baseSideParameter.leafComponentType();
                            if (roleSideLeaf.isRole() && ((ReferenceBinding)roleSideLeaf).baseclass() != null && ((ReferenceBinding)roleSideLeaf).baseclass().isCompatibleWith(baseSideLeaf)) {
                                roleSideArgument = new PotentialLowerExpression(roleSideArgument, baseSideParameter, gen.thisReference());
                            }
                            repackingStats.add(gen.assignment(gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), poss[i3] - 1 + argOffset), roleSideArgument));
                        }
                        ++i3;
                    }
                } else if (nRoleArgs > 0) {
                    int i4 = 0;
                    while (i4 < nRoleArgs) {
                        Expression basecallArg = gen.arrayReference((Expression)gen.singleNameReference(BASE_CALL_ARGS), i4);
                        if (baseSpec.argNeedsTranslation(i4)) {
                            basecallArg = new PotentialLowerExpression(gen.castExpression(basecallArg, gen.typeReference(roleParams[i4]), 2), baseSpec.resolvedParameters()[i4], gen.qualifiedThisReference(teamDecl.binding));
                        }
                        repackingStats.add(gen.assignment(gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), i4), basecallArg));
                        ++i4;
                    }
                }
                caseBlockStats.add(gen.ifStatement(gen.nullCheck(gen.singleNameReference(BASE_CALL_ARGS)), gen.emptyStatement(), (Statement)gen.block(repackingStats.toArray(new Statement[repackingStats.size()]))));
                Expression result = this.genSuperCallNext(gen, teamDecl.binding, superArgs);
                if (baseSpec.returnNeedsTranslation) {
                    TypeBinding[] returnTypes = this.getReturnTypes(mapping, 0);
                    ReferenceBinding currentRole = mapping.scope.enclosingReceiverType();
                    Reference liftReceiver = this.isRoleOfCurrentRole(currentRole, returnTypes[0]) ? Lifting.liftCall(mapping.scope, gen.thisReference(), gen.castExpression(gen.singleNameReference(IOTConstants.BASE), gen.typeReference(currentRole.baseclass()), 2), currentRole.baseclass(), currentRole, false) : this.genTeamThis(gen, returnTypes[0]);
                    resultVar = CharOperation.append(resultVar, '$');
                    caseBlockStats.add(gen.localVariable(resultVar, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), result));
                    caseBlockStats.add(gen.ifStatement((Expression)gen.equalExpression(gen.singleNameReference(BASE_CALL_FLAGS), gen.intLiteral(0), 29), gen.assignment(gen.singleNameReference(resultVar), Lifting.liftCall(mapping.scope, liftReceiver, gen.castExpression(gen.singleNameReference(resultVar), gen.baseclassReference(returnTypes[1]), 2), returnTypes[1], returnTypes[0], false, gen)), null));
                    result = gen.singleNameReference(resultVar);
                }
                caseBlockStats.add(gen.returnStatement(result));
                if (caseBlockStats.size() > nLabels) {
                    swStatements.addAll(caseBlockStats);
                }
                ++n2;
            }
        }
        if (swStatements.size() == 0) {
            return;
        }
        swStat.statements = swStatements.toArray(new Statement[swStatements.size()]);
        decl.statements = new Statement[]{swStat, gen.returnStatement(this.genSuperCallNext(gen, teamDecl.binding, superArgs))};
        decl.hasParsedStatements = true;
        AstEdit.addMethod(teamDecl, decl);
    }

    private Expression genSuperCallNext(AstGenerator gen, SourceTypeBinding binding, Expression[] superArgs) {
        if (binding.superclass.isTeam()) {
            return gen.messageSend(gen.superReference(), OT_CALL_NEXT, superArgs);
        }
        Expression[] argsCopy = Arrays.copyOf(superArgs, superArgs.length);
        argsCopy[superArgs.length - 1] = gen.intLiteral(0);
        return gen.messageSend(gen.qualifiedNameReference(IOTConstants.ORG_OBJECTTEAMS_TEAM), OT_TERMINAL_CALL_NEXT, argsCopy);
    }

    Reference genTeamThis(AstGenerator gen, TypeBinding type) {
        ReferenceBinding teamBinding;
        TypeBinding leaf = type.leafComponentType();
        if (leaf instanceof ReferenceBinding && (teamBinding = ((ReferenceBinding)leaf).enclosingType()) != null) {
            return gen.qualifiedThisReference(teamBinding);
        }
        return gen.thisReference();
    }

    TypeBinding[] getReturnTypes(CallinMappingDeclaration mapping, int i) {
        TypeBinding baseReturn = mapping.baseMethodSpecs[i].resolvedType();
        TypeBinding roleReturn = mapping.roleMethodSpec.resolvedType();
        if (roleReturn.isTypeVariable()) {
            roleReturn = ((TypeVariableBinding)roleReturn).firstBound;
        }
        return new TypeBinding[]{roleReturn, baseReturn};
    }

    TryStatement protectRoleMethodCall(Statement[] statements, MethodBinding roleMethod, AstGenerator gen) {
        Argument catch1Arg = gen.argument(CATCH_ARG, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION));
        Statement[] catch1Stat = new Statement[]{gen.throwStatement(gen.singleNameReference(CATCH_ARG))};
        Argument catch2Arg = gen.argument(CATCH_ARG, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_EXCEPTION));
        Statement[] catch2Stat = new Statement[]{gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(IOTConstants.SNEAKY_EXCEPTION), new Expression[]{gen.singleNameReference(CATCH_ARG)}))};
        return gen.tryCatch(statements, new Argument[]{catch1Arg, catch2Arg}, new Statement[][]{catch1Stat, catch2Stat});
    }

    private void generateCallOrigStatic(List<CallinMappingDeclaration> callinDecls, TeamModel aTeam) {
        TypeDeclaration teamDecl = aTeam.getAst();
        if (teamDecl == null) {
            return;
        }
        int idxOfExisting = -1;
        AbstractMethodDeclaration[] teamMethods = teamDecl.methods;
        if (teamMethods != null) {
            int i = 0;
            while (i < teamMethods.length) {
                if (CharOperation.equals(OT_CALL_ORIG_STATIC, teamMethods[i].selector) && teamMethods[i] instanceof TeamMethodGenerator.CopiedTeamMethod) {
                    idxOfExisting = i;
                    break;
                }
                ++i;
            }
        }
        AstGenerator gen = new AstGenerator(teamDecl);
        Argument[] args = new Argument[]{gen.argument(CALLIN_ID, gen.typeReference(TypeBinding.INT)), gen.argument(BOUND_METHOD_ID, gen.typeReference(TypeBinding.INT)), gen.argument(ARGUMENTS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1))};
        Expression[] passThroughArgs = new Expression[]{gen.singleNameReference(BOUND_METHOD_ID), gen.singleNameReference(ARGUMENTS)};
        MethodDeclaration decl = gen.method(teamDecl.compilationResult, 1, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), OT_CALL_ORIG_STATIC, args);
        SwitchStatement swStat = new SwitchStatement();
        swStat.expression = gen.singleNameReference(CALLIN_ID);
        ArrayList<Statement> swStatements = new ArrayList<Statement>();
        for (CallinMappingDeclaration mapping : callinDecls) {
            MethodSpec[] methodSpecArray = mapping.baseMethodSpecs;
            int n = mapping.baseMethodSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                MethodSpec baseSpec = methodSpecArray[n2];
                MethodBinding baseMethod = baseSpec.resolvedMethod;
                if (baseMethod.isStatic()) {
                    ReferenceBinding baseClass = mapping.scope.enclosingReceiverType().baseclass();
                    int callinId = baseSpec.getCallinId(aTeam, mapping.explicitName());
                    swStatements.add(gen.caseStatement(gen.intLiteral(callinId)));
                    MessageSend result = gen.fakeMessageSend(gen.baseTypeReference(baseClass), OT_CALL_ORIG_STATIC, passThroughArgs, baseMethod.declaringClass, mapping.scope.getJavaLangObject());
                    swStatements.add(gen.returnStatement(result));
                }
                ++n2;
            }
        }
        if (swStatements.size() == 0) {
            return;
        }
        swStat.statements = swStatements.toArray(new Statement[swStatements.size()]);
        decl.statements = new Statement[]{swStat, gen.returnStatement(gen.nullLiteral())};
        decl.hasParsedStatements = true;
        if (teamMethods != null && idxOfExisting > -1) {
            teamMethods[idxOfExisting] = decl;
            teamDecl.binding.resolveGeneratedMethod(decl, false, null, false);
        } else {
            AstEdit.addMethod(teamDecl, decl);
        }
    }

    boolean checkLiftingProblem(TypeDeclaration teamDecl, CallinMappingDeclaration callinDecl, ReferenceBinding roleType) {
        int iProblem = teamDecl.getTeamModel().canLiftingFail(roleType);
        if (iProblem != 0) {
            callinDecl.addRoleLiftingProblem(roleType, iProblem);
            return true;
        }
        return false;
    }

    boolean isRoleOfCurrentRole(ReferenceBinding currentRole, TypeBinding type) {
        TypeBinding leafType = type.leafComponentType();
        if (leafType.isRole()) {
            return currentRole.erasure().isCompatibleWith(leafType.enclosingType().erasure());
        }
        return false;
    }
}

