/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.OTType;

public class TypeHelper {
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String ORG_OBJECTTEAMS_TEAM = new String(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM);
    private static final String ICONFINED = new String(IOTConstants.ICONFINED);
    private static final String CONFINED = new String(IOTConstants.CONFINED);
    private static final String ILOWERABLE = new String(IOTConstants.ILOWERABLE);
    private static final String TSUPER_OT_TEAM = "TSuper__OT__Team";

    public static boolean isTeam(int flags) {
        return (flags & 0x4000000) != 0;
    }

    public static boolean isRole(int flags) {
        return (flags & 0x10000) != 0;
    }

    public static IType[] getSuperTypes(IType type) throws JavaModelException {
        LinkedList<IType> parents = new LinkedList<IType>();
        if (type != null) {
            parents.add(type);
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            parents.addAll(Arrays.asList(hierarchy.getAllSupertypes(type)));
        }
        return parents.toArray(new IType[parents.size()]);
    }

    public static IType[] getImplicitSuperTypes(IRoleType role) throws JavaModelException {
        LinkedList<IJavaElement> parents = new LinkedList<IJavaElement>();
        while (role != null) {
            parents.add(role.getCorrespondingJavaElement());
            role = TypeHelper.getParentTeamRoleType(role);
        }
        return parents.toArray(new IType[parents.size()]);
    }

    protected static IRoleType getParentTeamRoleType(IRoleType role) throws JavaModelException {
        IRoleType result = null;
        IType teamType = (IType)role.getTeam().getCorrespondingJavaElement();
        ITypeHierarchy hierarchy = teamType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        if (hierarchy != null) {
            IType parentTeam = hierarchy.getSuperclass(teamType);
            while (parentTeam != null && !parentTeam.getFullyQualifiedName().equals(JAVA_LANG_OBJECT)) {
                result = TypeHelper.getTeamRoleType(parentTeam, role);
                if (result != null) {
                    return result;
                }
                parentTeam = hierarchy.getSuperclass(parentTeam);
            }
        }
        return result;
    }

    protected static IRoleType getTeamRoleType(IType teamType, IRoleType role) throws JavaModelException {
        IRoleType result = null;
        IType[] children = teamType.getTypes();
        if (children != null) {
            String roleName = role.getCorrespondingJavaElement().getElementName();
            int idx = 0;
            while (idx < children.length) {
                if (children[idx].getElementType() == 7 && children[idx].getElementName().equals(roleName)) {
                    IOTType otType = OTModelManager.getOTElement(children[idx]);
                    if (otType != null && otType instanceof IRoleType) {
                        result = (IRoleType)otType;
                        break;
                    }
                    Util.log(new Exception("Unexpected model state!"), "Role " + roleName + " not present in OTM!");
                    break;
                }
                ++idx;
            }
        }
        return result;
    }

    public static IType findRoleType(IType teamType, String roleName) {
        IType roleType = teamType.getType(roleName);
        if (roleType.exists()) {
            return roleType;
        }
        IJavaElement parent = teamType.getParent();
        if (parent.getElementType() == 5) {
            parent = parent.getParent();
        }
        if (parent.getElementType() == 4) {
            IPackageFragment enclosingPackage = (IPackageFragment)parent;
            IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingPackage.getParent();
            try {
                IPackageFragment teamPackage = root.getPackageFragment(String.valueOf(enclosingPackage.getElementName()) + '.' + teamType.getElementName());
                if (teamPackage.exists()) {
                    IJavaElement[] cus = teamPackage.getChildren();
                    int i = 0;
                    while (i < cus.length) {
                        if (cus[i].getElementType() == 5) {
                            ICompilationUnit cu = (ICompilationUnit)cus[i];
                            IJavaElement[] children = cu.getChildren();
                            int j = 0;
                            while (j < children.length) {
                                if (children[j].getElementType() == 7 && children[j].getElementName().equals(roleName)) {
                                    return (IType)children[j];
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public static IType findNestedRoleType(IType teamType, String qualRoleName) {
        if (teamType == null || qualRoleName == null) {
            return null;
        }
        String[] path = qualRoleName.split("\\.");
        IType currType = null;
        int idx = 0;
        while (idx < path.length) {
            String currName = path[idx];
            if (currType != null) {
                currType = TypeHelper.findRoleType(currType, currName);
            } else if (teamType.getElementName().equals(currName)) {
                currType = teamType;
            } else {
                return null;
            }
            ++idx;
        }
        return currType;
    }

    public static IMethodMapping getMethodMapping(IMethod method, IType teamType) throws JavaModelException {
        if (method == null || teamType == null) {
            return null;
        }
        IOTType t = OTModelManager.getOTElement(method.getDeclaringType());
        IRoleType role = TypeHelper.getTeamRoleType(teamType, (IRoleType)t);
        if (role == null) {
            return null;
        }
        String signature = TypeHelper.getMethodSignature(method);
        IRoleType[] roles = TypeHelper.getImplicitSuperRoles(role);
        int roleIdx = 0;
        while (roleIdx < roles.length) {
            IRoleType curRole = roles[roleIdx];
            IMethodMapping[] mappings = curRole.getMethodMappings();
            int methIdx = 0;
            while (methIdx < mappings.length) {
                IMethodMapping mapping = mappings[methIdx];
                if (signature.equals(TypeHelper.getMethodSignature(mapping.getRoleMethod()))) {
                    return mapping;
                }
                ++methIdx;
            }
            ++roleIdx;
        }
        return null;
    }

    public static IType[] getRoleSuperTypes(IRoleType role) throws JavaModelException {
        if (role != null) {
            IType type = (IType)role.getCorrespondingJavaElement();
            return TypeHelper.getSuperTypes(type);
        }
        return null;
    }

    public static IType[] getSuperTeams(IType teamType) throws JavaModelException {
        LinkedList<IType> result = new LinkedList<IType>();
        if (teamType != null) {
            if (teamType instanceof OTType) {
                teamType = (IType)((OTType)teamType).getCorrespondingJavaElement();
            }
            result.add(teamType);
            ITypeHierarchy hierarchy = teamType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] superTeams = hierarchy.getAllSuperclasses(teamType);
            result.addAll(Arrays.asList(superTeams));
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IMethod[] getInheritedRoleMethods(IType teamType, String roleName) throws JavaModelException {
        return TypeHelper.getRoleMethods(teamType, roleName, true);
    }

    public static IMethod[] getAllRoleMethods(IType teamType, String roleName) throws JavaModelException {
        return TypeHelper.getRoleMethods(teamType, roleName, false);
    }

    public static IMethod[] getRoleMethods(IType teamType, String roleName, boolean onlySuperTeams) throws JavaModelException {
        HashMap<String, IMethod> result = new HashMap<String, IMethod>();
        IType[] teams = TypeHelper.getSuperTeams(teamType);
        int teamsIdx = 0;
        while (teamsIdx < teams.length) {
            if (!onlySuperTeams || teamsIdx != 0) {
                if (teams[teamsIdx].getFullyQualifiedName().compareTo(ORG_OBJECTTEAMS_TEAM) == 0) break;
                IType currentRole = OTModelManager.getOTElement(teams[teamsIdx]).getRoleType(roleName);
                if (currentRole != null) {
                    IMethod[] roleMethods = currentRole.getMethods();
                    int methIdx = 0;
                    while (methIdx < roleMethods.length) {
                        String key;
                        if (!(roleMethods[methIdx].getElementName().startsWith("_OT$") || roleMethods[methIdx].isConstructor() || result.containsKey(key = TypeHelper.getMethodSignature(roleMethods[methIdx])))) {
                            result.put(key, roleMethods[methIdx]);
                        }
                        ++methIdx;
                    }
                }
            }
            ++teamsIdx;
        }
        return result.values().toArray(new IMethod[result.size()]);
    }

    public static List<IMethod> getAllRegularInheritedMethods(IRoleType role) throws JavaModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] superTypes = TypeHelper.getRoleSuperTypes(role);
        int typeIdx = 1;
        while (typeIdx < superTypes.length) {
            if (!superTypes[typeIdx].getFullyQualifiedName().equals(JAVA_LANG_OBJECT)) {
                IOTType curRole = OTModelManager.getOTElement(superTypes[typeIdx]);
                if (curRole != null && curRole instanceof IRoleType) {
                    result.addAll(TypeHelper.getAllImplicitInheritedMethods((IRoleType)curRole));
                }
                result.addAll(Arrays.asList(superTypes[typeIdx].getMethods()));
            }
            ++typeIdx;
        }
        return result;
    }

    public static List<IMethod> getAllImplicitInheritedMethods(IRoleType role) throws JavaModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IRoleType[] superRoles = TypeHelper.getImplicitSuperRoles(role);
        int roleIdx = 1;
        while (roleIdx < superRoles.length) {
            result.addAll(Arrays.asList(superRoles[roleIdx].getMethods()));
            ++roleIdx;
        }
        return result;
    }

    public static IMethod[] getRoleMethodsComplete(IRoleType role) throws JavaModelException {
        HashMap<String, IMethod> result = new HashMap<String, IMethod>();
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        IRoleType[] roles = TypeHelper.getImplicitSuperRoles(role);
        int roleIdx = 0;
        while (roleIdx < roles.length) {
            methods.addAll(Arrays.asList(roles[roleIdx].getMethods()));
            ++roleIdx;
        }
        roleIdx = 0;
        while (roleIdx < roles.length) {
            methods.addAll(TypeHelper.getAllRegularInheritedMethods(roles[roleIdx]));
            ++roleIdx;
        }
        for (IMethod meth : methods) {
            String key;
            if (meth == null || meth.getElementName().startsWith("_OT$") || meth.isConstructor() || meth.isMainMethod() || result.containsKey(key = TypeHelper.getMethodSignature(meth))) continue;
            result.put(key, meth);
        }
        return result.values().toArray(new IMethod[result.size()]);
    }

    public static IRoleType[] getImplicitSuperRoles(IRoleType role) throws JavaModelException {
        LinkedList<IRoleType> result = new LinkedList<IRoleType>();
        IOTType teamType = role.getTeam();
        IType[] teams = TypeHelper.getSuperTeams(teamType);
        int teamsIdx = 0;
        while (teamsIdx < teams.length) {
            if (teams[teamsIdx].getFullyQualifiedName().compareTo(ORG_OBJECTTEAMS_TEAM) == 0) break;
            IRoleType superRole = TypeHelper.getTeamRoleType(teams[teamsIdx], role);
            if (superRole != null) {
                result.add(superRole);
            }
            ++teamsIdx;
        }
        return result.toArray(new IRoleType[result.size()]);
    }

    public static IRoleType[] getInheritedRoleTypes(IType teamType) throws JavaModelException {
        return TypeHelper.getRoleTypes(teamType, true);
    }

    public static IRoleType[] getAllRoleTypes(IType teamType) throws JavaModelException {
        return TypeHelper.getRoleTypes(teamType, false);
    }

    public static IRoleType[] getRoleTypes(IType teamType, boolean onlySuperTeams) throws JavaModelException {
        HashMap<String, IOTType> result = new HashMap<String, IOTType>();
        IType[] roles = null;
        IType currentRole = null;
        IType[] superTeams = TypeHelper.getSuperTeams(teamType);
        int teamsIdx = 0;
        while (teamsIdx < superTeams.length) {
            if (!onlySuperTeams || teamsIdx != 0) {
                if (superTeams[teamsIdx].getFullyQualifiedName().compareTo(ORG_OBJECTTEAMS_TEAM) == 0 || !TypeHelper.isTeam(superTeams[teamsIdx].getFlags())) break;
                roles = OTModelManager.getOTElement(superTeams[teamsIdx]).getRoleTypes();
                int roleIdx = 0;
                while (roleIdx < roles.length) {
                    String name;
                    currentRole = roles[roleIdx];
                    if (!(currentRole.isBinary() && (!currentRole.isInterface() || (name = currentRole.getElementName()).equals(TSUPER_OT_TEAM) || name.equals(ILOWERABLE) || name.equals(CONFINED) || name.equals(ICONFINED)) || result.containsKey(currentRole.getElementName()))) {
                        result.put(currentRole.getElementName(), OTModelManager.getOTElement(currentRole));
                    }
                    ++roleIdx;
                }
            }
            ++teamsIdx;
        }
        return result.values().toArray(new IRoleType[result.size()]);
    }

    public static String getMethodSignature(IMethod method) {
        StringBuffer result = new StringBuffer();
        if (method != null) {
            result.append(method.getElementName());
            result.append('(');
            String[] parameterTypes = method.getParameterTypes();
            int idx = 0;
            while (idx < parameterTypes.length) {
                String curType = Signature.toString(parameterTypes[idx]);
                result.append(curType);
                if (idx < parameterTypes.length - 1) {
                    result.append(", ");
                }
                ++idx;
            }
            result.append(')');
        }
        return result.toString();
    }

    public static String getMethodSignature(MethodDeclaration method) {
        StringBuffer result = new StringBuffer();
        if (method != null) {
            result.append(method.getName().getIdentifier());
            result.append('(');
            Iterator params = method.parameters().iterator();
            while (params.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)params.next();
                result.append(param.getType().resolveBinding().getName());
                if (!params.hasNext()) continue;
                result.append(", ");
            }
            result.append(')');
        }
        return result.toString();
    }

    public static String getQualifiedRoleSplitName(IType type) throws JavaModelException {
        IType currentType = type;
        StringBuffer result = new StringBuffer();
        while (currentType != null) {
            int flags;
            result.insert(0, currentType.getElementName());
            if (currentType.isClass() && Flags.isRole(flags = currentType.getFlags())) {
                result.insert(0, IOTConstants.OT_DELIM_NAME);
            }
            if ((currentType = currentType.getDeclaringType()) == null) continue;
            result.insert(0, '$');
        }
        String packageName = type.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return result.toString();
        }
        return String.valueOf(packageName) + '.' + result.toString();
    }

    public static boolean isOrgObjectTeamsTeam(IType type) {
        return CharOperation.equals(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM, type.getFullyQualifiedName().toCharArray());
    }

    public static boolean isConfined(IType type) {
        String simpleTypeName = type.getElementName();
        return CONFINED.equals(simpleTypeName) || ICONFINED.equals(simpleTypeName);
    }

    public static boolean isMarkerInterface(IType superRole) {
        return superRole.getElementName().startsWith("TSuper__OT__");
    }
}

