/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.control;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.ConfigHelper;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.ILogger;

public class Config
implements ConfigHelper.IConfig,
Comparable<Config> {
    WeakReference<Object> client;
    public SoftReference<Parser> parser;
    SoftReference<Parser> plainParser;
    WeakReference<LookupEnvironment> lookupEnvironment;
    public boolean verifyMethods;
    boolean analyzeCode;
    boolean generateCode;
    boolean buildFieldsAndMethods;
    boolean bundledCompleteTypeBindings = false;
    boolean strictDiet = true;
    public boolean ignoreMissingBytecode = false;
    ReferenceBinding castRequired = null;
    boolean loweringRequired = false;
    boolean loweringPossible = false;
    boolean sourceTypeRequired = false;
    private int useCount = 0;
    private long timestamp = System.currentTimeMillis();
    private static final ThreadLocal<Stack<Config>> _configs = new ThreadLocal();
    static final WeakHashMap<Object, Config> configsByClient = new WeakHashMap();
    static final int UPPER_THRESHOLD = 30;
    static final int LOWER_THRESHOLD = 25;
    static final boolean DEBUG = false;
    private static ILogger logger = null;

    public Config(Object client, Parser parser, LookupEnvironment environment) {
        this.client = new WeakReference<Object>(client);
        this.parser = new SoftReference<Parser>(parser);
        this.lookupEnvironment = new WeakReference<LookupEnvironment>(environment);
    }

    Config(Object client, SoftReference<Parser> parser, WeakReference<LookupEnvironment> lookupEnvironment) {
        this.client = new WeakReference<Object>(client);
        this.parser = parser;
        this.lookupEnvironment = lookupEnvironment;
    }

    public void setParser(Parser parser) {
        this.parser = new SoftReference<Parser>(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfig(Config config) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            if (configStack == null) {
                configStack = new Stack();
                _configs.set(configStack);
            }
            configStack.push(config);
            ++config.useCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config createOrResetConfig(Object client) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block4: {
                configStack = _configs.get();
                if (configStack != null && !configStack.empty()) break block4;
                configStack = new Stack();
                _configs.set(configStack);
                Config config = new Config(client, null, null);
                configStack.push(config);
                return null;
            }
            Config existing = configStack.peek();
            Config clone = new Config(client, existing.parser, existing.lookupEnvironment);
            clone.castRequired = existing.castRequired;
            clone.loweringRequired = existing.loweringRequired;
            clone.loweringPossible = existing.loweringPossible;
            clone.client = new WeakReference<Object>(null);
            existing.castRequired = null;
            existing.loweringRequired = false;
            existing.loweringPossible = false;
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreConfig(Config storedConfig) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            if (configStack != null) {
                Config config = configStack.peek();
                config.castRequired = storedConfig.castRequired;
                config.loweringRequired = storedConfig.loweringRequired;
                config.loweringPossible = storedConfig.loweringPossible;
            }
        }
    }

    public static void removeOrRestore(Config storedConfig, Object client) {
        if (storedConfig == null) {
            Config.removeConfig(client);
        } else {
            Config.restoreConfig(storedConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfig(Object client) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            assert (configStack != null);
            if (configStack != null) {
                Config config = configStack.pop();
                assert (config != null);
                if (--config.useCount > 0) {
                    return;
                }
                Object theClient = config.client.get();
                if (theClient != client && theClient != null) {
                    assert (false);
                    configStack.push(config);
                }
            }
        }
    }

    public static Config getConfig() {
        return Config.getConfig(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config getConfig(boolean logError) {
        if (_configs == null) {
            InternalCompilerError.log("Dependencies has no _configs");
            return null;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block6: {
                configStack = _configs.get();
                if (configStack != null && !configStack.isEmpty()) break block6;
                if (logError) {
                    InternalCompilerError.log("Dependencies not configured");
                }
                return null;
            }
            return configStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config safeGetConfig() {
        if (_configs == null) {
            return null;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block5: {
                configStack = _configs.get();
                if (configStack != null && !configStack.isEmpty()) break block5;
                return null;
            }
            return configStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasConfig() {
        if (_configs == null) {
            return false;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block5: {
                configStack = _configs.get();
                if (configStack != null) break block5;
                return false;
            }
            return !configStack.isEmpty();
        }
    }

    public static boolean hasConfig(Object client) {
        Config config = Config.safeGetConfig();
        if (config == null) {
            return false;
        }
        return config.client.get() == client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Config getOrCreateMatchingConfig(Object client, Parser parser, LookupEnvironment environment) {
        Config config = Config.safeGetConfig();
        if (Config.configMatchesRequest(config, client, parser, environment)) {
            ++config.useCount;
            return config;
        }
        boolean shouldCleanUp = false;
        WeakHashMap<Object, Config> weakHashMap = configsByClient;
        synchronized (weakHashMap) {
            if ((parser == null || environment == null) && Config.configMatchesRequest(config = configsByClient.get(client), client, parser, environment)) {
            } else {
                config = new Config(client, new SoftReference<Parser>(parser), new WeakReference<LookupEnvironment>(environment));
                configsByClient.put(client, config);
                shouldCleanUp = true;
            }
        }
        Config.addConfig(config);
        if (shouldCleanUp) {
            Config.cleanupIfNecessary();
        }
        return config;
    }

    @Override
    public int compareTo(Config o) {
        return Long.compare(this.timestamp, o.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupIfNecessary() {
        if (configsByClient.size() > 30) {
            WeakHashMap<Object, Config> weakHashMap = configsByClient;
            synchronized (weakHashMap) {
                Object[] keys = Collections.synchronizedMap(configsByClient).values().toArray();
                Arrays.sort(keys);
                int threshold = keys.length - 25;
                int i = 0;
                while (i < threshold) {
                    if (keys[i] instanceof Config) {
                        Object key;
                        Config config = (Config)keys[i];
                        if (config.client != null && (key = config.client.get()) != null) {
                            configsByClient.remove(key);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static boolean configMatchesRequest(Config config, Object client, Parser parser, LookupEnvironment environment) {
        if (config == null) {
            return false;
        }
        if (config.client.get() != client) {
            return false;
        }
        if (config.parser.get() != parser && parser != null) {
            return false;
        }
        return config.lookupEnvironment.get() == environment || environment == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            assert (configStack != null);
            if (configStack != null) {
                Config config = configStack.pop();
                assert (config != null);
                if (--config.useCount > 0 && !configStack.contains(config)) {
                    configStack.push(config);
                    return;
                }
                if (config != this) {
                    assert (false);
                    configStack.push(config);
                }
            }
        }
    }

    static boolean getVerifyMethods() {
        return Config.getConfig().verifyMethods;
    }

    static boolean getAnalyzeCode() {
        return Config.getConfig().analyzeCode;
    }

    static boolean getGenerateCode() {
        return Config.getConfig().generateCode;
    }

    public static void setCastRequired(ReferenceBinding castType) {
        Config config = Config.getConfig();
        config.castRequired = config.castRequired != null && castType != null ? SourceTypeBinding.MultipleCasts : castType;
    }

    public static ReferenceBinding getCastRequired() {
        return Config.getConfig().castRequired;
    }

    public static void setLoweringRequired(boolean val) {
        Config.getConfig().loweringRequired = val;
    }

    public static boolean getLoweringRequired() {
        return Config.getConfig().loweringRequired;
    }

    public static void setLoweringPossible(boolean val) {
        Config.getConfig().loweringPossible = val;
    }

    public static boolean getLoweringPossible() {
        return Config.getConfig().loweringPossible;
    }

    public static boolean requireTypeAdjustment() {
        boolean result = Config.getCastRequired() != null || Config.getLoweringRequired();
        Config.setCastRequired(null);
        Config.setLoweringRequired(false);
        return result;
    }

    public static void setSourceTypeRequired(boolean val) {
        Config config = Config.getConfig();
        if (config == null) {
            if (!val) {
                return;
            }
            throw new NullPointerException("Not configured when requesting source type.");
        }
        config.sourceTypeRequired = val;
    }

    public static boolean getSourceTypeRequired() {
        Config config = Config.getConfig(false);
        return config != null && config.sourceTypeRequired;
    }

    public static LookupEnvironment getLookupEnvironment() throws NotConfiguredException {
        Config current = Config.getConfig();
        if (current == null) {
            throw new NotConfiguredException("LookupEnvironment not configured");
        }
        return current.lookupEnvironment();
    }

    protected LookupEnvironment lookupEnvironment() {
        return (LookupEnvironment)this.lookupEnvironment.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLookupEnvironment() {
        if (_configs == null) {
            return false;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            block5: {
                if (Config.hasConfig()) break block5;
                return false;
            }
            Config config = Config.getConfig(false);
            return config != null && config.lookupEnvironment.get() != null;
        }
    }

    static boolean getBuildFieldsAndMethods() {
        return Config.getConfig().buildFieldsAndMethods;
    }

    public static void assertBuildFieldsAndMethods(boolean flag) {
        assert (flag == Config.getBuildFieldsAndMethods());
    }

    public static boolean getStrictDiet() {
        return Config.getConfig().strictDiet;
    }

    public static Parser getParser() {
        return Config.getConfig().parser();
    }

    protected Parser parser() {
        return this.parser.get();
    }

    public static boolean isUsingAssistParser() {
        Parser parser = Config.getParser();
        return parser != null && parser.isAssistParser();
    }

    public static void delegateGetMethodBodies(CompilationUnitDeclaration unit) {
        Config config = Config.getConfig();
        Parser parser = config.parser();
        Object theClient = config.client.get();
        if (theClient instanceof ITypeRequestor) {
            Parser plainParser;
            Parser parser2 = plainParser = config.plainParser != null ? config.plainParser.get() : null;
            if (plainParser != null) {
                parser = plainParser;
            } else {
                plainParser = ((ITypeRequestor)theClient).getPlainParser();
                if (plainParser != null) {
                    parser = plainParser;
                    config.plainParser = new SoftReference<Parser>(plainParser);
                }
            }
        }
        parser.getMethodBodies(unit);
    }

    public static boolean areStatementsAcceptable(ConstructorDeclaration cd, boolean hasExplicitConstructorCall, ProblemReporter problemReporter) {
        if (!cd.isGenerated) {
            throw new InternalCompilerError("generated statements in non-generated constructor " + cd.toString());
        }
        if (hasExplicitConstructorCall) {
            if (cd.scope != null) {
                problemReporter.explicitSuperInLiftConstructor(cd.scope.referenceType(), cd);
            }
            return false;
        }
        return true;
    }

    public static boolean clientIsCompiler() {
        Config config = Config.getConfig();
        return config != null && config.client.get() instanceof Compiler;
    }

    public static boolean clientIsBatchCompiler() {
        Config config = Config.safeGetConfig();
        if (config == null) {
            return false;
        }
        Object client = config.client.get();
        return client instanceof Compiler && ((Compiler)client).isBatchCompiler;
    }

    public boolean setBundledCompleteTypeBindingsMode(boolean mode) {
        boolean save = this.bundledCompleteTypeBindings;
        this.bundledCompleteTypeBindings = mode;
        return save;
    }

    public static boolean getBundledCompleteTypeBindingsMode() {
        Config config = Config.getConfig();
        return config.bundledCompleteTypeBindings;
    }

    public static synchronized void setLogger(ILogger aLogger) {
        logger = aLogger;
    }

    public static synchronized void logException(String message, Throwable exception) {
        if (logger != null) {
            logger.logException(message, exception);
        } else {
            System.err.println("OT/J: " + message);
        }
        exception.printStackTrace(System.err);
    }

    public boolean clientHasExactClass(Class<?> clazz) {
        Object theClient = this.client.get();
        return theClient != null && theClient.getClass() == clazz;
    }

    public static class NotConfiguredException
    extends RuntimeException {
        public NotConfiguredException(String string) {
            super(string);
        }

        public void logWarning(String msg) {
            try {
                JavaCore.getJavaCore().getLog().log((IStatus)new Status(2, "org.eclipse.jdt.core", msg, (Throwable)this));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("Warning: " + msg);
                this.printStackTrace(System.err);
            }
        }
    }
}

