/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class AnchorListAttribute
extends ListValueAttribute {
    private MethodBinding _method;
    private char[][] _anchors;
    private static final char[] NO_ANCHOR = "_OT$NoAnchor".toCharArray();
    private static final String ARG_ANCHOR_PREFIX = "_OT$param";

    public AnchorListAttribute(MethodBinding method) {
        super(IOTConstants.TYPE_ANCHOR_LIST, 0, 2);
        this._method = method;
        this._count = method.parameters.length + 1;
    }

    public AnchorListAttribute(MethodInfo info, int readOffset, int structOffset, int[] constantPoolOffsets) {
        super(IOTConstants.TYPE_ANCHOR_LIST, 0, 2);
        this._methodInfo = info;
        this.readList(info, readOffset, structOffset, constantPoolOffsets);
    }

    @Override
    void writeElementValue(int i) {
        if (i == 0) {
            this.writeElement(this._method.returnType);
        } else {
            this.writeElement(this._method.parameters[i - 1]);
        }
    }

    private void writeElement(TypeBinding type) {
        if (type.isArrayType()) {
            type = type.leafComponentType();
        }
        if (type instanceof DependentTypeBinding) {
            DependentTypeBinding roleType = (DependentTypeBinding)type;
            ITeamAnchor anchor = roleType._teamAnchor;
            if (anchor instanceof TThisBinding) {
                this.writeName(NO_ANCHOR);
            } else if (roleType._argumentPosition > -1) {
                this.writeName((ARG_ANCHOR_PREFIX + roleType._argumentPosition).toCharArray());
            } else {
                this.writeName(anchor.getBestName());
            }
        } else {
            this.writeName(NO_ANCHOR);
        }
    }

    @Override
    void read(int i) {
        char[] name;
        if (i == 0) {
            this._anchors = new char[this._count][];
        }
        if (!CharOperation.equals(name = this.consumeName(), NO_ANCHOR)) {
            this._anchors[i] = name;
        }
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        assert (false);
    }

    @Override
    public boolean evaluate(MethodInfo info, MethodBinding methodBinding, LookupEnvironment environment) {
        if (info != this._methodInfo) {
            return false;
        }
        this._method = methodBinding;
        this._method.anchorList = this;
        return true;
    }

    public void wrapTypes(LookupEnvironment environment) {
        int i = 0;
        while (i < this._count) {
            if (this._anchors[i] != null) {
                if (i == 0) {
                    this._method.returnType = this.getWrappedType(this._method.returnType, this._anchors[i], this._method.declaringClass, this._method, environment);
                } else {
                    this._method.parameters[i - 1] = this.getWrappedType(this._method.parameters[i - 1], this._anchors[i], this._method.declaringClass, this._method, environment);
                }
            }
            ++i;
        }
    }

    private TypeBinding getWrappedType(TypeBinding typeToWrap, char[] anchorName, ReferenceBinding site, final MethodBinding declaringMethod, LookupEnvironment environment) {
        assert (!CharOperation.equals(anchorName, NO_ANCHOR)) : "NO_ANCHOR should have been filtered out";
        ReferenceBinding type = (ReferenceBinding)typeToWrap.leafComponentType();
        if (CharOperation.prefixEquals(ARG_ANCHOR_PREFIX.toCharArray(), anchorName)) {
            LocalVariableBinding anchor = new LocalVariableBinding(anchorName, (TypeBinding)type.enclosingType(), 0, true);
            anchor.declaringScope = new CallinCalloutScope(null, null){

                @Override
                public MethodBinding referenceMethodBinding() {
                    return declaringMethod;
                }
            };
            TypeBinding wrappedType = anchor.getRoleTypeBinding(type, typeToWrap.dimensions());
            char[] tail = CharOperation.subarray(anchorName, ARG_ANCHOR_PREFIX.length(), -1);
            DependentTypeBinding wrappedRole = (DependentTypeBinding)wrappedType.leafComponentType();
            wrappedRole._argumentPosition = Integer.parseInt(String.valueOf(tail));
            wrappedRole._declaringMethod = new DependentTypeBinding.IMethodProvider(){

                @Override
                public MethodBinding getMethod() {
                    return declaringMethod;
                }
            };
            return wrappedType;
        }
        return RoleTypeCreator.wrapTypeWithAnchorFromName(typeToWrap, anchorName, site, environment);
    }

    public static void checkAddAnchorList(AbstractMethodDeclaration decl) {
        if (decl.ignoreFurtherInvestigation) {
            return;
        }
        MethodBinding binding = decl.binding;
        if (binding.anchorList != null) {
            return;
        }
        boolean relevantAnchorFound = false;
        if (binding.returnType != null) {
            relevantAnchorFound = AnchorListAttribute.hasRelevantAnchor(binding.returnType);
        }
        int i = 0;
        while (!relevantAnchorFound && i < binding.parameters.length) {
            relevantAnchorFound |= AnchorListAttribute.hasRelevantAnchor(binding.parameters[i++]);
        }
        if (relevantAnchorFound) {
            MethodModel model = MethodModel.getModel(decl);
            model.addAttribute(new AnchorListAttribute(binding));
        }
    }

    private static boolean hasRelevantAnchor(TypeBinding binding) {
        if (binding.isArrayType()) {
            binding = binding.leafComponentType();
        }
        if (binding.isBaseType()) {
            return false;
        }
        ReferenceBinding refBinding = (ReferenceBinding)binding;
        if (!(refBinding instanceof DependentTypeBinding)) {
            return false;
        }
        ITeamAnchor anchor = ((DependentTypeBinding)refBinding)._teamAnchor;
        return !(anchor instanceof TThisBinding);
    }

    @Override
    String toString(int i) {
        if (this._anchors != null) {
            if (this._anchors[i] == null) {
                return "<>";
            }
            return new String(this._anchors[i]);
        }
        if (i == 0) {
            return this.toString(this._method.returnType);
        }
        return this.toString(this._method.parameters[i - 1]);
    }

    private String toString(TypeBinding type) {
        if (type instanceof RoleTypeBinding) {
            return ((RoleTypeBinding)type)._teamAnchor.toString();
        }
        return "<>";
    }
}

