/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.samples;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.objectteams.otdt.internal.samples.OTSamplesPlugin;
import org.eclipse.objectteams.otdt.internal.samples.SampleWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class ShowSampleAction
extends Action
implements IIntroAction {
    private String sampleId;

    public void run(IIntroSite site, Properties params) {
        this.sampleId = params.getProperty("id");
        if (this.sampleId == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SampleWizard wizard = new SampleWizard();
                try {
                    wizard.setInitializationData(null, "class", ShowSampleAction.this.sampleId);
                    wizard.setSwitchPerspective(false);
                    wizard.setSelectRevealEnabled(false);
                    wizard.setActivitiesEnabled(false);
                    WizardDialog dialog = new WizardDialog(ShowSampleAction.this.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        ShowSampleAction.this.switchToSampleStandby(wizard);
                    }
                }
                catch (CoreException e) {
                    OTSamplesPlugin.logException(e, null, null);
                }
            }
        };
        Shell currentShell = this.getActiveWorkbenchWindow().getShell();
        currentShell.getDisplay().asyncExec(r);
    }

    Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = this.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private void switchToSampleStandby(SampleWizard wizard) {
        StringBuffer url = new StringBuffer();
        url.append("http://org.eclipse.ui.intro/showStandby?");
        url.append("pluginId=org.eclipse.pde.ui");
        url.append("&");
        url.append("partId=org.eclipse.pde.ui.sampleStandbyPart");
        url.append("&");
        url.append("input=");
        url.append(this.sampleId);
        IIntroURL introURL = IntroURLFactory.createIntroURL((String)url.toString());
        if (introURL != null) {
            introURL.execute();
            this.ensureProperContext(wizard);
        }
    }

    private void ensureProperContext(SampleWizard wizard) {
        IConfigurationElement sample = wizard.getSelection();
        String perspId = sample.getAttribute("perspectiveId");
        if (perspId != null) {
            try {
                wizard.enableActivities();
                PlatformUI.getWorkbench().showPerspective(perspId, this.getActiveWorkbenchWindow());
                wizard.selectReveal(this.getActiveWorkbenchShell());
            }
            catch (WorkbenchException e) {
                OTSamplesPlugin.logException(e, null, null);
            }
        }
        this.enableActivities(sample);
    }

    private void enableActivities(IConfigurationElement sample) {
    }
}

