/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class TypeAnalyzer {
    public static final int EXACT_MATCH_ONLY = 1;
    public static final int NEEDING_ADJUSTMENT_ONLY = 2;
    public static final int ANY_MATCH = 3;

    public static boolean isEqualMethodSignature(ReferenceBinding superTeam, MethodBinding superMeth, ReferenceBinding subTeam, MethodBinding subMeth, int matchKind) {
        if (subMeth.parameters.length != superMeth.parameters.length) {
            return false;
        }
        TypeBinding[] params = subMeth.parameters;
        boolean needAdjustment = false;
        int i = 0;
        while (i < params.length) {
            TypeBinding param = params[i];
            TypeBinding superTypeBind = superMeth.parameters[i];
            if (!TypeBinding.equalsEquals(param, superTypeBind)) {
                if (TypeAnalyzer.areTypesMatchable(param, subTeam, superTypeBind, superTeam, matchKind)) {
                    needAdjustment = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (matchKind == 2) {
            return needAdjustment;
        }
        return true;
    }

    public static boolean isSameRole(ReferenceBinding r1, ReferenceBinding r2) {
        ReferenceBinding t2;
        if (TypeBinding.equalsEquals(r1, r2)) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (!r1.isRole() || !r2.isRole()) {
            return false;
        }
        ReferenceBinding t1 = r1.enclosingType();
        if (TypeBinding.equalsEquals(t1, t2 = r2.enclosingType()) || t1 == null || t2 == null) {
            return false;
        }
        if (!t1.isCompatibleWith(t2) && !t2.isCompatibleWith(t1)) {
            return false;
        }
        return CharOperation.equals(r1.internalName(), r2.internalName());
    }

    public static boolean refinesExtends(ReferenceBinding role, ReferenceBinding tsuperRole) {
        return !TypeAnalyzer.isSameRole(role.superclass(), tsuperRole.superclass());
    }

    public static boolean isSameType(ReferenceBinding site, TypeBinding t1, TypeBinding t2) {
        if (TypeBinding.equalsEquals(t1, t2)) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.isArrayType()) {
            if (!t2.isArrayType() || t1.dimensions() != t2.dimensions()) {
                return false;
            }
            t1 = t1.leafComponentType();
            t2 = t2.leafComponentType();
        } else if (t2.isArrayType()) {
            return false;
        }
        if (t1.isBaseType()) {
            return TypeBinding.equalsEquals(t1, t2);
        }
        if (t2.isBaseType()) {
            return false;
        }
        ReferenceBinding r1 = (ReferenceBinding)t1;
        ReferenceBinding r2 = (ReferenceBinding)t2;
        if (r1.isDirectRole() && r2.isDirectRole()) {
            r2 = (ReferenceBinding)TeamModel.strengthenRoleType(site, r2);
            return TypeBinding.equalsEquals(r1.roleModel.getInterfacePartBinding(), r2.roleModel.getInterfacePartBinding());
        }
        return false;
    }

    public static boolean areTypesMatchable(TypeBinding currentType, ReferenceBinding subTeam, TypeBinding tsuperType, ReferenceBinding superTeam, int matchKind) {
        TypeBinding closestMatch;
        if (currentType instanceof ProblemReferenceBinding) {
            closestMatch = ((ProblemReferenceBinding)currentType).closestMatch();
            if (closestMatch == null) {
                return CharOperation.equals(currentType.sourceName(), tsuperType.sourceName());
            }
            currentType = closestMatch;
        }
        if (tsuperType instanceof ProblemReferenceBinding) {
            closestMatch = ((ProblemReferenceBinding)tsuperType).closestMatch();
            if (closestMatch == null) {
                return CharOperation.equals(currentType.sourceName(), tsuperType.sourceName());
            }
            tsuperType = closestMatch;
        }
        if (currentType instanceof ArrayBinding || tsuperType instanceof ArrayBinding) {
            if (!(tsuperType instanceof ArrayBinding) || !(currentType instanceof ArrayBinding)) {
                return false;
            }
            ArrayBinding currentArray = (ArrayBinding)currentType;
            ArrayBinding superArray = (ArrayBinding)tsuperType;
            if (currentArray.dimensions() != superArray.dimensions()) {
                return false;
            }
            currentType = currentArray.leafComponentType();
            tsuperType = superArray.leafComponentType();
        }
        if (currentType instanceof ReferenceBinding) {
            char[][] tname2;
            if (currentType instanceof DependentTypeBinding) {
                currentType = ((DependentTypeBinding)currentType).getRealType();
            }
            if (!(tsuperType instanceof ReferenceBinding)) {
                return false;
            }
            if (tsuperType instanceof DependentTypeBinding) {
                tsuperType = ((DependentTypeBinding)tsuperType).getRealType();
            }
            if (currentType.isParameterizedType() || tsuperType.isParameterizedType()) {
                if (currentType.isParameterizedType()) {
                    if (tsuperType.isParameterizedType()) {
                        ParameterizedTypeBinding currentParameterized = (ParameterizedTypeBinding)currentType;
                        ParameterizedTypeBinding tsuperParameterized = (ParameterizedTypeBinding)tsuperType;
                        if (!CharOperation.equals(currentParameterized.genericTypeSignature, tsuperParameterized.genericTypeSignature)) {
                            return false;
                        }
                    } else if (!tsuperType.isRawType()) {
                        return false;
                    }
                } else if (!currentType.isRawType()) {
                    return false;
                }
                currentType = currentType.erasure();
                tsuperType = tsuperType.erasure();
            }
            if (currentType.isTypeVariable() && tsuperType.isTypeVariable()) {
                return TypeBinding.equalsEquals(currentType, tsuperType);
            }
            char[][] tname1 = TypeAnalyzer.compoundNameOfReferenceType((ReferenceBinding)tsuperType, true, true);
            if (CharOperation.equals(tname1, tname2 = TypeAnalyzer.compoundNameOfReferenceType((ReferenceBinding)currentType, true, true))) {
                if (TypeBinding.notEquals(tsuperType, currentType) && tsuperType.isValidBinding()) {
                    throw new InternalCompilerError("different bindings for the same type??" + currentType + ':' + tsuperType);
                }
                return true;
            }
            if (matchKind == 1) {
                return false;
            }
            tname1 = TypeAnalyzer.splitTypeNameRelativeToTeam((ReferenceBinding)tsuperType, superTeam);
            if (!CharOperation.equals(tname1, tname2 = TypeAnalyzer.splitTypeNameRelativeToTeam((ReferenceBinding)currentType, subTeam))) {
                return false;
            }
        } else if (currentType instanceof BaseTypeBinding) {
            if (TypeBinding.notEquals(currentType, tsuperType)) {
                return false;
            }
        } else {
            throw new InternalCompilerError("matching of unexpected type kind: " + currentType);
        }
        return true;
    }

    public static char[][] splitTypeNameRelativeToTeam(ReferenceBinding tb, TypeBinding teamBinding) {
        char[][] qname = new char[][]{tb.internalName()};
        while (tb instanceof MemberTypeBinding) {
            tb = ((MemberTypeBinding)tb).enclosingType;
            if (tb.isTeam()) {
                if (TypeBinding.equalsEquals(tb, teamBinding)) {
                    return qname;
                }
                if (!teamBinding.isCompatibleWith(tb)) continue;
                return qname;
            }
            char[][] qn2 = new char[qname.length + 1][];
            System.arraycopy(qname, 0, qn2, 1, qname.length);
            qn2[0] = tb.internalName();
            qname = qn2;
        }
        return qname;
    }

    public static char[][] compoundNameOfReferenceType(ReferenceBinding tb, boolean includePackage, boolean createTeamAnchor) {
        ReferenceBinding closestMatch;
        if (tb instanceof ProblemReferenceBinding && (closestMatch = (ReferenceBinding)tb.closestMatch()) != null) {
            tb = closestMatch;
        }
        if (!tb.isValidBinding()) {
            if (includePackage) {
                return tb.compoundName;
            }
            int l = tb.compoundName.length;
            return new char[][]{tb.compoundName[l - 1]};
        }
        if (tb instanceof UnresolvedReferenceBinding) {
            LookupEnvironment env = Config.getLookupEnvironment();
            if (env == null) {
                throw new InternalCompilerError("No lookup environment configured");
            }
            tb = ((UnresolvedReferenceBinding)tb).resolve(env, false);
        }
        if (createTeamAnchor && tb instanceof DependentTypeBinding && ((DependentTypeBinding)tb).hasExplicitAnchor()) {
            DependentTypeBinding roleTypeBinding = (DependentTypeBinding)tb;
            ITeamAnchor[] path = roleTypeBinding._teamAnchor.getBestNamePath();
            char[] declaringClass = null;
            int prefixLen = 0;
            if (roleTypeBinding._teamAnchor instanceof FieldBinding) {
                declaringClass = ((FieldBinding)roleTypeBinding._teamAnchor).declaringClass.internalName();
                prefixLen = 2;
            }
            char[][] names = new char[path.length + 1 + prefixLen][];
            if (declaringClass != null) {
                names[0] = declaringClass;
                names[1] = "this".toCharArray();
            }
            int i = 0;
            while (i < path.length) {
                names[i + prefixLen] = path[i].internalName();
                ++i;
            }
            names[path.length + prefixLen] = tb.internalName();
            return names;
        }
        char[][] packName = includePackage && tb.getPackage() != null ? (Object)tb.getPackage().compoundName : new char[][]{};
        char[][] outerName = tb.enclosingType() != null ? (Object)TypeAnalyzer.compoundNameOfReferenceType(tb.enclosingType(), false, createTeamAnchor) : new char[][]{};
        char[][] result = new char[packName.length + outerName.length + 1][];
        System.arraycopy(packName, 0, result, 0, packName.length);
        System.arraycopy(outerName, 0, result, packName.length, outerName.length);
        result[result.length - 1] = tb.internalName();
        return result;
    }

    public static char[] constantPoolNameRelativeToTeam(ReferenceBinding teamBinding, char[] compoundName) {
        char[] teamName = teamBinding.constantPoolName();
        if (!CharOperation.prefixEquals(teamName, compoundName)) {
            return compoundName;
        }
        assert (compoundName[teamName.length] == '$');
        return CharOperation.subarray(compoundName, teamName.length + 1, -1);
    }

    public static boolean equalRoleLocal(ReferenceBinding teamBinding, ReferenceBinding role, char[] typeName) {
        if (role.constantPoolName() == null) {
            return false;
        }
        char[] relativeName = TypeAnalyzer.constantPoolNameRelativeToTeam(teamBinding, role.constantPoolName());
        return CharOperation.equals(typeName, relativeName);
    }

    public static TypeReference weakenTypeReferenceFromBinding(MethodScope scope, TypeReference origRef, TypeBinding origBinding, TypeBinding binding) {
        if (!(binding instanceof ReferenceBinding) && !(binding instanceof ArrayBinding)) {
            return origRef;
        }
        binding = binding.erasure();
        origBinding = origBinding.erasure();
        if (binding instanceof RoleTypeBinding && TypeBinding.equalsEquals(origBinding, ((RoleTypeBinding)binding).getRealType())) {
            return origRef;
        }
        if (TypeBinding.equalsEquals(origBinding, binding)) {
            return origRef;
        }
        AstGenerator gen = new AstGenerator(origRef.sourceStart, origRef.sourceEnd);
        return gen.typeReference(binding);
    }

    public static MethodBinding findMethodInSuperRole(ReferenceBinding subTeam, MethodBinding subMethod, ReferenceBinding superRole, ReferenceBinding superTeam, int matchKind) {
        MethodBinding[] superMethods = superRole.methods();
        int i = 0;
        while (i < superMethods.length) {
            if (TypeAnalyzer.isEqualMethodSignature(superTeam, superMethods[i], subTeam, subMethod, matchKind)) {
                return superMethods[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isOrgObjectteamsTeam(ReferenceBinding type) {
        if (type == null) {
            return false;
        }
        return CharOperation.equals(type.compoundName, IOTConstants.ORG_OBJECTTEAMS_TEAM);
    }

    public static boolean isOrgObjectteamsTeam(CompilationUnitDeclaration unit) {
        if (unit != null && unit.currentPackage != null && unit.types != null && unit.types.length > 0) {
            return CharOperation.equals(IOTConstants.ORG_OBJECTTEAMS, unit.currentPackage.tokens) && CharOperation.equals(IOTConstants.TEAM, unit.types[0].name);
        }
        return false;
    }

    public static boolean isVariableRef(Expression e) {
        return (e.bits & 3) != 0;
    }

    public static FieldBinding findField(ReferenceBinding type, char[] token, boolean isStaticScope, boolean allowOuter, int requiredState) {
        while (type != null) {
            ReferenceBinding currentType = type;
            while (currentType != null) {
                FieldBinding foundVar = currentType.getField(token, true);
                if (foundVar != null) {
                    if (isStaticScope && !foundVar.isStatic()) {
                        return new ProblemFieldBinding(foundVar, currentType, token, 7);
                    }
                    return foundVar;
                }
                if ((currentType = currentType.superclass()) == null || requiredState == -1) continue;
                Dependencies.ensureBindingState(currentType, requiredState);
            }
            if (!allowOuter) {
                return null;
            }
            isStaticScope = type.isStatic();
            type = type.enclosingType();
        }
        return null;
    }

    public static FieldBinding findField(ReferenceBinding type, char[] token, boolean isStaticScope, boolean allowOuter) {
        return TypeAnalyzer.findField(type, token, isStaticScope, allowOuter, -1);
    }

    public static MethodBinding findMethod(Scope scope, ReferenceBinding type, char[] selector, TypeBinding[] params) {
        return TypeAnalyzer.findMethod(scope, type, selector, params, false, null);
    }

    public static @Nullable MethodBinding findMethod(final Scope scope, ReferenceBinding type, char[] selector, TypeBinding[] params, boolean decapsulationAllowed, @Nullable InvocationSite site) {
        if (type == null || scope == null) {
            return null;
        }
        if (site == null) {
            final Expression[] fakeArguments = new Expression[params.length];
            int i = 0;
            while (i < params.length) {
                fakeArguments[i] = new SingleNameReference(("fakeArg" + i).toCharArray(), 0L);
                fakeArguments[i].resolvedType = params[i];
                ++i;
            }
            site = new InvocationSite(){

                @Override
                public int sourceStart() {
                    return 0;
                }

                @Override
                public int sourceEnd() {
                    return 0;
                }

                @Override
                public void setFieldIndex(int depth) {
                }

                @Override
                public void setDepth(int depth) {
                }

                @Override
                public void setActualReceiverType(ReferenceBinding receiverType) {
                }

                @Override
                public boolean receiverIsImplicitThis() {
                    return false;
                }

                @Override
                public boolean isTypeAccess() {
                    return false;
                }

                @Override
                public boolean isSuperAccess() {
                    return false;
                }

                @Override
                public boolean isQualifiedSuper() {
                    return false;
                }

                @Override
                public boolean checkingPotentialCompatibility() {
                    return false;
                }

                @Override
                public void acceptPotentiallyCompatibleMethods(MethodBinding[] methods) {
                }

                @Override
                public TypeBinding invocationTargetType() {
                    return scope.getJavaLangObject();
                }

                @Override
                public ExpressionContext getExpressionContext() {
                    return ExpressionContext.ASSIGNMENT_CONTEXT;
                }

                @Override
                public TypeBinding[] genericTypeArguments() {
                    return null;
                }

                @Override
                public InferenceContext18 freshInferenceContext(Scope someScope) {
                    return new InferenceContext18(someScope, fakeArguments, this, null);
                }
            };
        }
        return scope.getMethod(type, selector, params, site);
    }

    public static MethodBinding findCompatibleMethod(ReferenceBinding site, MethodBinding template) {
        MethodBinding[] methodBindingArray = site.getMethods(template.selector);
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                MethodBinding existingMethod = methodBindingArray[n2];
                if (existingMethod.parameters.length == template.parameters.length) {
                    int j = 0;
                    while (j < template.parameters.length) {
                        if (!TypeBinding.notEquals(existingMethod.parameters[j].erasure(), template.parameters[j].erasure())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return existingMethod;
                }
            }
            ++n2;
        }
        return null;
    }

    public static AbstractMethodDeclaration findMethodDecl(TypeDeclaration typeDeclaration, char[] selector, int nArgs) {
        if (typeDeclaration.methods == null) {
            return null;
        }
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int i = 0;
        while (i < methods.length) {
            if (CharOperation.equals(methods[i].selector, selector) && (methods[i].arguments == null ? nArgs == 0 : methods[i].arguments.length == nArgs)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static MethodBinding getMethod(ReferenceBinding typeBinding, char[] selector) {
        if (typeBinding == null) {
            return null;
        }
        MethodBinding[] foundMethods = typeBinding.getMethods(selector);
        if (foundMethods != Binding.NO_METHODS) {
            return foundMethods[0];
        }
        MethodBinding foundMethod = TypeAnalyzer.getMethod(typeBinding.superclass(), selector);
        if (foundMethod != null) {
            return foundMethod;
        }
        ReferenceBinding[] superInterfaces = typeBinding.superInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            foundMethod = TypeAnalyzer.getMethod(superInterfaces[i], selector);
            if (foundMethod != null) {
                return foundMethod;
            }
            ++i;
        }
        return null;
    }

    public static boolean areRoleTypesEqual(RoleTypeBinding one, RoleTypeBinding two) {
        if (!CharOperation.equals(one.sourceName(), two.sourceName())) {
            return false;
        }
        ReferenceBinding teamOne = one._staticallyKnownTeam;
        ReferenceBinding teamTwo = two._staticallyKnownTeam;
        if (teamOne.isRole() && teamTwo.isRole()) {
            ReferenceBinding outerTwo;
            ReferenceBinding outerOne = teamOne.enclosingType();
            if (TypeBinding.notEquals(outerOne, outerTwo = teamTwo.enclosingType())) {
                if (outerOne.isCompatibleWith(outerTwo)) {
                    teamTwo = (ReferenceBinding)TeamModel.strengthenRoleType(outerOne, teamTwo);
                } else if (outerTwo.isCompatibleWith(outerOne)) {
                    teamOne = (ReferenceBinding)TeamModel.strengthenRoleType(outerTwo, teamOne);
                }
            }
            teamOne = teamOne.roleModel.getInterfacePartBinding();
            teamTwo = teamTwo.roleModel.getInterfacePartBinding();
        }
        if (teamOne.isCompatibleWith(teamTwo)) {
            return true;
        }
        return teamTwo.isCompatibleWith(teamOne);
    }

    public static boolean isTopConfined(ReferenceBinding type) {
        if (OTNameUtils.isPredefinedConfined(type)) {
            return true;
        }
        char[] name = type.internalName();
        return type.isRole() && (CharOperation.equals(name, IOTConstants.ICONFINED) || CharOperation.equals(name, IOTConstants.OTCONFINED) || CharOperation.equals(name, IOTConstants.CONFINED));
    }

    public static boolean isConfined(TypeBinding type) {
        if (type == null || !type.isRole()) {
            return false;
        }
        ReferenceBinding currentType = (ReferenceBinding)type;
        while (currentType != null) {
            if (currentType.id == 1) {
                return false;
            }
            currentType = currentType.superclass();
        }
        return true;
    }

    public static boolean isPredefinedRole(ReferenceBinding type) {
        char[] name = type.internalName();
        if (CharOperation.equals(name, IOTConstants.ROFI_CACHE)) {
            return true;
        }
        if (!type.isRole()) {
            return false;
        }
        return CharOperation.equals(name, IOTConstants.ICONFINED) || CharOperation.equals(name, IOTConstants.OTCONFINED) || CharOperation.equals(name, IOTConstants.CONFINED) || CharOperation.equals(name, IOTConstants.ILOWERABLE) || CharOperation.equals(name, IOTConstants.IBOUNDBASE) || CharOperation.equals(name, IOTConstants.IBOUNDBASE2);
    }

    public static boolean extendsOTConfined(TypeDeclaration type) {
        if (type.superclass instanceof QualifiedTypeReference) {
            return CharOperation.equals(((QualifiedTypeReference)type.superclass).tokens, IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED);
        }
        if (type.superclass instanceof SingleTypeReference) {
            return CharOperation.equals(((SingleTypeReference)type.superclass).token, IOTConstants.OTCONFINED);
        }
        return false;
    }

    public static boolean isSearchingForSyntheticField(MethodScope scope, TypeBinding receiverType, char[] fieldName) {
        return CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, fieldName) && scope != null && ((AbstractMethodDeclaration)scope.referenceContext).isGenerated && receiverType instanceof ReferenceBinding && ((ReferenceBinding)receiverType).isRole();
    }

    public static boolean isSourceTypeWithErrors(ReferenceBinding type) {
        if (type instanceof SourceTypeBinding) {
            SourceTypeBinding sourceType = (SourceTypeBinding)type;
            if (sourceType.scope != null) {
                return sourceType.scope.referenceContext.hasErrors();
            }
        }
        return false;
    }

    public static char[] stripTypeName(char[] typeName) {
        if (CharOperation.prefixEquals(IOTConstants._OT_BASE, typeName)) {
            typeName = CharOperation.subarray(typeName, IOTConstants.OT_DOLLAR_LEN, -1);
        }
        return typeName;
    }

    public static boolean sameOrContained(ReferenceBinding binding, ReferenceBinding targetEnclosingType) {
        while (binding != null) {
            if (TypeBinding.equalsEquals(binding, targetEnclosingType)) {
                return true;
            }
            binding = binding.enclosingType();
        }
        return false;
    }

    public static boolean containsAnchoredBaseclass(CompilationUnitDeclaration parsedUnit) {
        if (parsedUnit.types == null) {
            return false;
        }
        TypeDeclaration[] typeDeclarationArray = parsedUnit.types;
        int n = parsedUnit.types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration type = typeDeclarationArray[n2];
            if (TypeAnalyzer.containsAnchoredBaseclass(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsAnchoredBaseclass(TypeDeclaration type) {
        TypeReference baseRef = type.baseclass;
        if (baseRef instanceof ParameterizedSingleTypeReference) {
            TypeReference[] typeArguments = ((ParameterizedSingleTypeReference)baseRef).typeArguments;
            return typeArguments != null && typeArguments.length > 0 && typeArguments[0] instanceof TypeAnchorReference;
        }
        if (baseRef instanceof QualifiedTypeReference) {
            return true;
        }
        TypeDeclaration[] members = type.memberTypes;
        if (members != null) {
            TypeDeclaration[] typeDeclarationArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration member = typeDeclarationArray[n2];
                if (TypeAnalyzer.containsAnchoredBaseclass(member)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

