/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJrt
extends ClasspathLocation
implements IMultiModuleEntry {
    protected static final Map<String, Map<String, IModule>> modulesCache = new ConcurrentHashMap<String, Map<String, IModule>>();
    protected final String zipFilename;
    protected final JrtFileSystem jrtFileSystem;
    static final Set<String> NO_LIMIT_MODULES = Collections.emptySet();

    protected ClasspathJrt(String zipFilename) {
        this.zipFilename = Objects.requireNonNull(zipFilename);
        JrtFileSystem system = null;
        try {
            system = JRTUtil.getJrtSystem((File)new File(zipFilename), null);
        }
        catch (IOException e) {
            Util.log(e, "Failed to init packages for " + zipFilename);
        }
        this.jrtFileSystem = system;
    }

    public ClasspathJrt(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        this(zipFilename);
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        ClasspathJrt.loadModules(this);
    }

    static Set<String> getModuleNames(ClasspathJrt jrt) {
        if (jrt.zipFilename == null) {
            return Set.of();
        }
        if (modulesCache.isEmpty()) {
            return null;
        }
        Map<String, IModule> modules = modulesCache.get(jrt.getKey());
        if (modules != null) {
            return modules.keySet();
        }
        return null;
    }

    public static void loadModules(final ClasspathJrt jrt) {
        String jrtKey = jrt.getKey();
        if (jrtKey == null) {
            return;
        }
        modulesCache.computeIfAbsent(jrtKey, key -> {
            final HashMap newCache = new HashMap();
            try {
                JRTUtil.walkModuleImage((JrtFileSystem)classpathJrt.jrtFileSystem, (JRTUtil.JrtFileVisitor)new JRTUtil.JrtFileVisitor<Path>(){

                    public FileVisitResult visitModule(Path path, String name) throws IOException {
                        jrt.acceptModule(JRTUtil.getClassfileContent((JrtFileSystem)jrt.jrtFileSystem, (String)"module-info.class", (String)name), name, newCache);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }, (int)4);
            }
            catch (IOException e) {
                Util.log(e, "Failed to init packages for " + String.valueOf(jrt));
            }
            return newCache.isEmpty() ? null : Map.copyOf(newCache);
        });
    }

    protected String getKey() {
        return this.zipFilename;
    }

    void acceptModule(byte[] content, String name, Map<String, IModule> cache) {
        if (content == null) {
            return;
        }
        try {
            ClassFileReader reader = new ClassFileReader(content, "module-info.class".toCharArray());
            IBinaryModule moduleDecl = reader.getModuleDeclaration();
            if (moduleDecl != null) {
                cache.put(name, (IModule)moduleDecl);
            }
        }
        catch (ClassFormatException e) {
            Util.log(e, "Failed to read module-info.class for " + name + " in " + this.toString());
        }
    }

    @Override
    public void cleanup() {
        if (this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
            }
            catch (IOException iOException) {}
            this.annotationZipFile = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrt)) {
            return false;
        }
        ClasspathJrt jar = (ClasspathJrt)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals((Object)jar.accessRuleSet))) {
            return false;
        }
        return this.zipFilename.endsWith(jar.zipFilename) && this.areAllModuleOptionsEqual(jar);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        ClassFileReader reader;
        String fileNameWithoutExtension;
        block6: {
            block5: {
                if (!this.isPackage(qualifiedPackageName, moduleName)) {
                    return null;
                }
                fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                if (this.jrtFileSystem != null) break block5;
                return null;
            }
            reader = JRTUtil.getClassfile((JrtFileSystem)this.jrtFileSystem, (String)qualifiedBinaryFileName, (String)moduleName, moduleNameFilter);
            if (reader != null) break block6;
            return null;
        }
        try {
            return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, reader.getModule());
        }
        catch (IOException | ClassFormatException throwable) {
            return null;
        }
    }

    @Override
    public IPath getProjectRelativePath() {
        return null;
    }

    public int hashCode() {
        return this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        List moduleNames = JRTUtil.getModulesDeclaringPackage((JrtFileSystem)this.jrtFileSystem, (String)qualifiedPackageName, (String)moduleName);
        return CharOperation.toCharArrays((List)moduleNames);
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        return JRTUtil.hasCompilationUnit((JrtFileSystem)this.jrtFileSystem, (String)qualifiedPackageName, (String)moduleName);
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        return JRTUtil.getModulesDeclaringPackage((JrtFileSystem)this.jrtFileSystem, (String)qualifiedPackageName, (String)moduleName) != null;
    }

    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename;
        return start;
    }

    @Override
    public String debugPathString() {
        return this.zipFilename;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    @Override
    public boolean hasModule() {
        return true;
    }

    public IModule getModule(char[] moduleName) {
        return this.getModule(String.valueOf(moduleName));
    }

    public IModule getModule(String moduleName) {
        if (!this.hasModule()) {
            return null;
        }
        Map<String, IModule> modules = modulesCache.get(this.getKey());
        if (modules != null) {
            return modules.get(moduleName);
        }
        return null;
    }

    public Collection<String> getModuleNames(Collection<String> limitModules) {
        Set<String> cache = ClasspathJrt.getModuleNames(this);
        if (cache != null) {
            return this.selectModules(cache, limitModules);
        }
        return Collections.emptyList();
    }

    protected Collection<String> selectModules(Set<String> keySet, Collection<String> limitModules) {
        Collection<String> rootModules;
        if (limitModules == NO_LIMIT_MODULES) {
            rootModules = new HashSet<String>(keySet);
        } else if (limitModules != null) {
            HashSet<String> result = new HashSet<String>(keySet);
            result.retainAll(limitModules);
            rootModules = result;
        } else {
            rootModules = JavaProject.internalDefaultRootModules(keySet, s -> s, this::getModule);
        }
        HashSet<String> allModules = new HashSet<String>(rootModules);
        for (String mod : rootModules) {
            this.addRequired(mod, allModules);
        }
        return allModules;
    }

    protected void addRequired(String mod, Set<String> allModules) {
        IModule iMod = this.getModule(mod);
        if (iMod == null) {
            return;
        }
        IModule.IModuleReference[] iModuleReferenceArray = iMod.requires();
        int n = iModuleReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule.IModuleReference requiredRef = iModuleReferenceArray[n2];
            String moduleName = String.valueOf(requiredRef.name());
            IModule reqMod = this.getModule(moduleName);
            if (reqMod != null && allModules.add(moduleName)) {
                this.addRequired(moduleName, allModules);
            }
            ++n2;
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false, null);
    }

    public static void resetCaches() {
        modulesCache.clear();
    }
}

